// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/retail/v2/completion_service.proto

#include "google/cloud/retail/v2/internal/completion_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace retail_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

CompletionServiceTracingConnection::CompletionServiceTracingConnection(
    std::shared_ptr<retail_v2::CompletionServiceConnection> child)
    : child_(std::move(child)) {}

StatusOr<google::cloud::retail::v2::CompleteQueryResponse>
CompletionServiceTracingConnection::CompleteQuery(
    google::cloud::retail::v2::CompleteQueryRequest const& request) {
  auto span = internal::MakeSpan(
      "retail_v2::CompletionServiceConnection::CompleteQuery");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CompleteQuery(request));
}

future<StatusOr<google::cloud::retail::v2::ImportCompletionDataResponse>>
CompletionServiceTracingConnection::ImportCompletionData(
    google::cloud::retail::v2::ImportCompletionDataRequest const& request) {
  auto span = internal::MakeSpan(
      "retail_v2::CompletionServiceConnection::ImportCompletionData");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->ImportCompletionData(request));
}

StatusOr<google::longrunning::Operation>
CompletionServiceTracingConnection::ImportCompletionData(
    NoAwaitTag,
    google::cloud::retail::v2::ImportCompletionDataRequest const& request) {
  auto span = internal::MakeSpan(
      "retail_v2::CompletionServiceConnection::ImportCompletionData");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->ImportCompletionData(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::retail::v2::ImportCompletionDataResponse>>
CompletionServiceTracingConnection::ImportCompletionData(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "retail_v2::CompletionServiceConnection::ImportCompletionData");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->ImportCompletionData(operation));
}

StreamRange<google::longrunning::Operation>
CompletionServiceTracingConnection::ListOperations(
    google::longrunning::ListOperationsRequest request) {
  auto span = internal::MakeSpan(
      "retail_v2::CompletionServiceConnection::ListOperations");
  internal::OTelScope scope(span);
  auto sr = child_->ListOperations(std::move(request));
  return internal::MakeTracedStreamRange<google::longrunning::Operation>(
      std::move(span), std::move(sr));
}

StatusOr<google::longrunning::Operation>
CompletionServiceTracingConnection::GetOperation(
    google::longrunning::GetOperationRequest const& request) {
  auto span = internal::MakeSpan(
      "retail_v2::CompletionServiceConnection::GetOperation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetOperation(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<retail_v2::CompletionServiceConnection>
MakeCompletionServiceTracingConnection(
    std::shared_ptr<retail_v2::CompletionServiceConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn =
        std::make_shared<CompletionServiceTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace retail_v2_internal
}  // namespace cloud
}  // namespace google
