// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/retail/v2/catalog_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RETAIL_V2_INTERNAL_CATALOG_STUB_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RETAIL_V2_INTERNAL_CATALOG_STUB_H

#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/cloud/retail/v2/catalog_service.grpc.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace retail_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class CatalogServiceStub {
 public:
  virtual ~CatalogServiceStub() = 0;

  virtual StatusOr<google::cloud::retail::v2::ListCatalogsResponse>
  ListCatalogs(
      grpc::ClientContext& context, Options const& options,
      google::cloud::retail::v2::ListCatalogsRequest const& request) = 0;

  virtual StatusOr<google::cloud::retail::v2::Catalog> UpdateCatalog(
      grpc::ClientContext& context, Options const& options,
      google::cloud::retail::v2::UpdateCatalogRequest const& request) = 0;

  virtual Status SetDefaultBranch(
      grpc::ClientContext& context, Options const& options,
      google::cloud::retail::v2::SetDefaultBranchRequest const& request) = 0;

  virtual StatusOr<google::cloud::retail::v2::GetDefaultBranchResponse>
  GetDefaultBranch(
      grpc::ClientContext& context, Options const& options,
      google::cloud::retail::v2::GetDefaultBranchRequest const& request) = 0;

  virtual StatusOr<google::cloud::retail::v2::CompletionConfig>
  GetCompletionConfig(
      grpc::ClientContext& context, Options const& options,
      google::cloud::retail::v2::GetCompletionConfigRequest const& request) = 0;

  virtual StatusOr<google::cloud::retail::v2::CompletionConfig>
  UpdateCompletionConfig(
      grpc::ClientContext& context, Options const& options,
      google::cloud::retail::v2::UpdateCompletionConfigRequest const&
          request) = 0;

  virtual StatusOr<google::cloud::retail::v2::AttributesConfig>
  GetAttributesConfig(
      grpc::ClientContext& context, Options const& options,
      google::cloud::retail::v2::GetAttributesConfigRequest const& request) = 0;

  virtual StatusOr<google::cloud::retail::v2::AttributesConfig>
  UpdateAttributesConfig(
      grpc::ClientContext& context, Options const& options,
      google::cloud::retail::v2::UpdateAttributesConfigRequest const&
          request) = 0;

  virtual StatusOr<google::cloud::retail::v2::AttributesConfig>
  AddCatalogAttribute(
      grpc::ClientContext& context, Options const& options,
      google::cloud::retail::v2::AddCatalogAttributeRequest const& request) = 0;

  virtual StatusOr<google::cloud::retail::v2::AttributesConfig>
  RemoveCatalogAttribute(
      grpc::ClientContext& context, Options const& options,
      google::cloud::retail::v2::RemoveCatalogAttributeRequest const&
          request) = 0;

  virtual StatusOr<google::cloud::retail::v2::AttributesConfig>
  ReplaceCatalogAttribute(
      grpc::ClientContext& context, Options const& options,
      google::cloud::retail::v2::ReplaceCatalogAttributeRequest const&
          request) = 0;

  virtual StatusOr<google::longrunning::ListOperationsResponse> ListOperations(
      grpc::ClientContext& context, Options const& options,
      google::longrunning::ListOperationsRequest const& request) = 0;

  virtual StatusOr<google::longrunning::Operation> GetOperation(
      grpc::ClientContext& context, Options const& options,
      google::longrunning::GetOperationRequest const& request) = 0;
};

class DefaultCatalogServiceStub : public CatalogServiceStub {
 public:
  explicit DefaultCatalogServiceStub(
      std::unique_ptr<google::cloud::retail::v2::CatalogService::StubInterface>
          grpc_stub,
      std::unique_ptr<google::longrunning::Operations::StubInterface>
          operations_stub)
      : grpc_stub_(std::move(grpc_stub)),
        operations_stub_(std::move(operations_stub)) {}

  StatusOr<google::cloud::retail::v2::ListCatalogsResponse> ListCatalogs(
      grpc::ClientContext& context, Options const& options,
      google::cloud::retail::v2::ListCatalogsRequest const& request) override;

  StatusOr<google::cloud::retail::v2::Catalog> UpdateCatalog(
      grpc::ClientContext& context, Options const& options,
      google::cloud::retail::v2::UpdateCatalogRequest const& request) override;

  Status SetDefaultBranch(
      grpc::ClientContext& context, Options const& options,
      google::cloud::retail::v2::SetDefaultBranchRequest const& request)
      override;

  StatusOr<google::cloud::retail::v2::GetDefaultBranchResponse>
  GetDefaultBranch(grpc::ClientContext& context, Options const& options,
                   google::cloud::retail::v2::GetDefaultBranchRequest const&
                       request) override;

  StatusOr<google::cloud::retail::v2::CompletionConfig> GetCompletionConfig(
      grpc::ClientContext& context, Options const& options,
      google::cloud::retail::v2::GetCompletionConfigRequest const& request)
      override;

  StatusOr<google::cloud::retail::v2::CompletionConfig> UpdateCompletionConfig(
      grpc::ClientContext& context, Options const& options,
      google::cloud::retail::v2::UpdateCompletionConfigRequest const& request)
      override;

  StatusOr<google::cloud::retail::v2::AttributesConfig> GetAttributesConfig(
      grpc::ClientContext& context, Options const& options,
      google::cloud::retail::v2::GetAttributesConfigRequest const& request)
      override;

  StatusOr<google::cloud::retail::v2::AttributesConfig> UpdateAttributesConfig(
      grpc::ClientContext& context, Options const& options,
      google::cloud::retail::v2::UpdateAttributesConfigRequest const& request)
      override;

  StatusOr<google::cloud::retail::v2::AttributesConfig> AddCatalogAttribute(
      grpc::ClientContext& context, Options const& options,
      google::cloud::retail::v2::AddCatalogAttributeRequest const& request)
      override;

  StatusOr<google::cloud::retail::v2::AttributesConfig> RemoveCatalogAttribute(
      grpc::ClientContext& context, Options const& options,
      google::cloud::retail::v2::RemoveCatalogAttributeRequest const& request)
      override;

  StatusOr<google::cloud::retail::v2::AttributesConfig> ReplaceCatalogAttribute(
      grpc::ClientContext& context, Options const& options,
      google::cloud::retail::v2::ReplaceCatalogAttributeRequest const& request)
      override;

  StatusOr<google::longrunning::ListOperationsResponse> ListOperations(
      grpc::ClientContext& context, Options const& options,
      google::longrunning::ListOperationsRequest const& request) override;

  StatusOr<google::longrunning::Operation> GetOperation(
      grpc::ClientContext& context, Options const& options,
      google::longrunning::GetOperationRequest const& request) override;

 private:
  std::unique_ptr<google::cloud::retail::v2::CatalogService::StubInterface>
      grpc_stub_;
  std::unique_ptr<google::longrunning::Operations::StubInterface>
      operations_stub_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace retail_v2_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RETAIL_V2_INTERNAL_CATALOG_STUB_H
