// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/resourcemanager/v3/projects.proto

#include "google/cloud/resourcemanager/v3/projects_connection.h"
#include "google/cloud/resourcemanager/v3/internal/projects_connection_impl.h"
#include "google/cloud/resourcemanager/v3/internal/projects_option_defaults.h"
#include "google/cloud/resourcemanager/v3/internal/projects_stub_factory.h"
#include "google/cloud/resourcemanager/v3/internal/projects_tracing_connection.h"
#include "google/cloud/resourcemanager/v3/projects_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace resourcemanager_v3 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ProjectsConnection::~ProjectsConnection() = default;

StatusOr<google::cloud::resourcemanager::v3::Project>
ProjectsConnection::GetProject(
    google::cloud::resourcemanager::v3::GetProjectRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::resourcemanager::v3::Project>
ProjectsConnection::ListProjects(
    google::cloud::resourcemanager::v3::
        ListProjectsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::resourcemanager::v3::Project>>();
}

StreamRange<google::cloud::resourcemanager::v3::Project>
ProjectsConnection::SearchProjects(
    google::cloud::resourcemanager::v3::
        SearchProjectsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::resourcemanager::v3::Project>>();
}

future<StatusOr<google::cloud::resourcemanager::v3::Project>>
ProjectsConnection::CreateProject(
    google::cloud::resourcemanager::v3::CreateProjectRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::resourcemanager::v3::Project>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> ProjectsConnection::CreateProject(
    NoAwaitTag,
    google::cloud::resourcemanager::v3::CreateProjectRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::resourcemanager::v3::Project>>
ProjectsConnection::CreateProject(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::resourcemanager::v3::Project>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::resourcemanager::v3::Project>>
ProjectsConnection::UpdateProject(
    google::cloud::resourcemanager::v3::UpdateProjectRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::resourcemanager::v3::Project>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> ProjectsConnection::UpdateProject(
    NoAwaitTag,
    google::cloud::resourcemanager::v3::UpdateProjectRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::resourcemanager::v3::Project>>
ProjectsConnection::UpdateProject(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::resourcemanager::v3::Project>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::resourcemanager::v3::Project>>
ProjectsConnection::MoveProject(
    google::cloud::resourcemanager::v3::MoveProjectRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::resourcemanager::v3::Project>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> ProjectsConnection::MoveProject(
    NoAwaitTag, google::cloud::resourcemanager::v3::MoveProjectRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::resourcemanager::v3::Project>>
ProjectsConnection::MoveProject(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::resourcemanager::v3::Project>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::resourcemanager::v3::Project>>
ProjectsConnection::DeleteProject(
    google::cloud::resourcemanager::v3::DeleteProjectRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::resourcemanager::v3::Project>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> ProjectsConnection::DeleteProject(
    NoAwaitTag,
    google::cloud::resourcemanager::v3::DeleteProjectRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::resourcemanager::v3::Project>>
ProjectsConnection::DeleteProject(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::resourcemanager::v3::Project>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::resourcemanager::v3::Project>>
ProjectsConnection::UndeleteProject(
    google::cloud::resourcemanager::v3::UndeleteProjectRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::resourcemanager::v3::Project>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> ProjectsConnection::UndeleteProject(
    NoAwaitTag,
    google::cloud::resourcemanager::v3::UndeleteProjectRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::resourcemanager::v3::Project>>
ProjectsConnection::UndeleteProject(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::resourcemanager::v3::Project>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::iam::v1::Policy> ProjectsConnection::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::Policy> ProjectsConnection::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
ProjectsConnection::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::longrunning::Operation> ProjectsConnection::GetOperation(
    google::longrunning::GetOperationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<ProjectsConnection> MakeProjectsConnection(Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 ProjectsPolicyOptionList>(options, __func__);
  options =
      resourcemanager_v3_internal::ProjectsDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = resourcemanager_v3_internal::CreateDefaultProjectsStub(
      std::move(auth), options);
  return resourcemanager_v3_internal::MakeProjectsTracingConnection(
      std::make_shared<resourcemanager_v3_internal::ProjectsConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace resourcemanager_v3
}  // namespace cloud
}  // namespace google
