// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/resourcemanager/v3/tag_bindings.proto

#include "google/cloud/resourcemanager/v3/internal/tag_bindings_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace resourcemanager_v3_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

TagBindingsTracingConnection::TagBindingsTracingConnection(
    std::shared_ptr<resourcemanager_v3::TagBindingsConnection> child)
    : child_(std::move(child)) {}

StreamRange<google::cloud::resourcemanager::v3::TagBinding>
TagBindingsTracingConnection::ListTagBindings(
    google::cloud::resourcemanager::v3::ListTagBindingsRequest request) {
  auto span = internal::MakeSpan(
      "resourcemanager_v3::TagBindingsConnection::ListTagBindings");
  internal::OTelScope scope(span);
  auto sr = child_->ListTagBindings(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::resourcemanager::v3::TagBinding>(std::move(span),
                                                      std::move(sr));
}

future<StatusOr<google::cloud::resourcemanager::v3::TagBinding>>
TagBindingsTracingConnection::CreateTagBinding(
    google::cloud::resourcemanager::v3::CreateTagBindingRequest const&
        request) {
  auto span = internal::MakeSpan(
      "resourcemanager_v3::TagBindingsConnection::CreateTagBinding");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateTagBinding(request));
}

StatusOr<google::longrunning::Operation>
TagBindingsTracingConnection::CreateTagBinding(
    NoAwaitTag,
    google::cloud::resourcemanager::v3::CreateTagBindingRequest const&
        request) {
  auto span = internal::MakeSpan(
      "resourcemanager_v3::TagBindingsConnection::CreateTagBinding");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->CreateTagBinding(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::resourcemanager::v3::TagBinding>>
TagBindingsTracingConnection::CreateTagBinding(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "resourcemanager_v3::TagBindingsConnection::CreateTagBinding");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateTagBinding(operation));
}

future<StatusOr<google::cloud::resourcemanager::v3::DeleteTagBindingMetadata>>
TagBindingsTracingConnection::DeleteTagBinding(
    google::cloud::resourcemanager::v3::DeleteTagBindingRequest const&
        request) {
  auto span = internal::MakeSpan(
      "resourcemanager_v3::TagBindingsConnection::DeleteTagBinding");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteTagBinding(request));
}

StatusOr<google::longrunning::Operation>
TagBindingsTracingConnection::DeleteTagBinding(
    NoAwaitTag,
    google::cloud::resourcemanager::v3::DeleteTagBindingRequest const&
        request) {
  auto span = internal::MakeSpan(
      "resourcemanager_v3::TagBindingsConnection::DeleteTagBinding");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->DeleteTagBinding(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::resourcemanager::v3::DeleteTagBindingMetadata>>
TagBindingsTracingConnection::DeleteTagBinding(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "resourcemanager_v3::TagBindingsConnection::DeleteTagBinding");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteTagBinding(operation));
}

StreamRange<google::cloud::resourcemanager::v3::EffectiveTag>
TagBindingsTracingConnection::ListEffectiveTags(
    google::cloud::resourcemanager::v3::ListEffectiveTagsRequest request) {
  auto span = internal::MakeSpan(
      "resourcemanager_v3::TagBindingsConnection::ListEffectiveTags");
  internal::OTelScope scope(span);
  auto sr = child_->ListEffectiveTags(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::resourcemanager::v3::EffectiveTag>(std::move(span),
                                                        std::move(sr));
}

StatusOr<google::longrunning::Operation>
TagBindingsTracingConnection::GetOperation(
    google::longrunning::GetOperationRequest const& request) {
  auto span = internal::MakeSpan(
      "resourcemanager_v3::TagBindingsConnection::GetOperation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetOperation(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<resourcemanager_v3::TagBindingsConnection>
MakeTagBindingsTracingConnection(
    std::shared_ptr<resourcemanager_v3::TagBindingsConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<TagBindingsTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace resourcemanager_v3_internal
}  // namespace cloud
}  // namespace google
