// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/redis/v1/cloud_redis.proto

#include "google/cloud/redis/v1/cloud_redis_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace redis_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

CloudRedisClient::CloudRedisClient(
    std::shared_ptr<CloudRedisConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
CloudRedisClient::~CloudRedisClient() = default;

StreamRange<google::cloud::redis::v1::Instance> CloudRedisClient::ListInstances(
    std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::redis::v1::ListInstancesRequest request;
  request.set_parent(parent);
  return connection_->ListInstances(request);
}

StreamRange<google::cloud::redis::v1::Instance> CloudRedisClient::ListInstances(
    google::cloud::redis::v1::ListInstancesRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListInstances(std::move(request));
}

StatusOr<google::cloud::redis::v1::Instance> CloudRedisClient::GetInstance(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::redis::v1::GetInstanceRequest request;
  request.set_name(name);
  return connection_->GetInstance(request);
}

StatusOr<google::cloud::redis::v1::Instance> CloudRedisClient::GetInstance(
    google::cloud::redis::v1::GetInstanceRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetInstance(request);
}

StatusOr<google::cloud::redis::v1::InstanceAuthString>
CloudRedisClient::GetInstanceAuthString(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::redis::v1::GetInstanceAuthStringRequest request;
  request.set_name(name);
  return connection_->GetInstanceAuthString(request);
}

StatusOr<google::cloud::redis::v1::InstanceAuthString>
CloudRedisClient::GetInstanceAuthString(
    google::cloud::redis::v1::GetInstanceAuthStringRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetInstanceAuthString(request);
}

future<StatusOr<google::cloud::redis::v1::Instance>>
CloudRedisClient::CreateInstance(
    std::string const& parent, std::string const& instance_id,
    google::cloud::redis::v1::Instance const& instance, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::redis::v1::CreateInstanceRequest request;
  request.set_parent(parent);
  request.set_instance_id(instance_id);
  *request.mutable_instance() = instance;
  return connection_->CreateInstance(request);
}

StatusOr<google::longrunning::Operation> CloudRedisClient::CreateInstance(
    NoAwaitTag, std::string const& parent, std::string const& instance_id,
    google::cloud::redis::v1::Instance const& instance, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::redis::v1::CreateInstanceRequest request;
  request.set_parent(parent);
  request.set_instance_id(instance_id);
  *request.mutable_instance() = instance;
  return connection_->CreateInstance(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::redis::v1::Instance>>
CloudRedisClient::CreateInstance(
    google::cloud::redis::v1::CreateInstanceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateInstance(request);
}

StatusOr<google::longrunning::Operation> CloudRedisClient::CreateInstance(
    NoAwaitTag, google::cloud::redis::v1::CreateInstanceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateInstance(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::redis::v1::Instance>>
CloudRedisClient::CreateInstance(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateInstance(operation);
}

future<StatusOr<google::cloud::redis::v1::Instance>>
CloudRedisClient::UpdateInstance(
    google::protobuf::FieldMask const& update_mask,
    google::cloud::redis::v1::Instance const& instance, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::redis::v1::UpdateInstanceRequest request;
  *request.mutable_update_mask() = update_mask;
  *request.mutable_instance() = instance;
  return connection_->UpdateInstance(request);
}

StatusOr<google::longrunning::Operation> CloudRedisClient::UpdateInstance(
    NoAwaitTag, google::protobuf::FieldMask const& update_mask,
    google::cloud::redis::v1::Instance const& instance, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::redis::v1::UpdateInstanceRequest request;
  *request.mutable_update_mask() = update_mask;
  *request.mutable_instance() = instance;
  return connection_->UpdateInstance(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::redis::v1::Instance>>
CloudRedisClient::UpdateInstance(
    google::cloud::redis::v1::UpdateInstanceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateInstance(request);
}

StatusOr<google::longrunning::Operation> CloudRedisClient::UpdateInstance(
    NoAwaitTag, google::cloud::redis::v1::UpdateInstanceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateInstance(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::redis::v1::Instance>>
CloudRedisClient::UpdateInstance(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateInstance(operation);
}

future<StatusOr<google::cloud::redis::v1::Instance>>
CloudRedisClient::UpgradeInstance(std::string const& name,
                                  std::string const& redis_version,
                                  Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::redis::v1::UpgradeInstanceRequest request;
  request.set_name(name);
  request.set_redis_version(redis_version);
  return connection_->UpgradeInstance(request);
}

StatusOr<google::longrunning::Operation> CloudRedisClient::UpgradeInstance(
    NoAwaitTag, std::string const& name, std::string const& redis_version,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::redis::v1::UpgradeInstanceRequest request;
  request.set_name(name);
  request.set_redis_version(redis_version);
  return connection_->UpgradeInstance(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::redis::v1::Instance>>
CloudRedisClient::UpgradeInstance(
    google::cloud::redis::v1::UpgradeInstanceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpgradeInstance(request);
}

StatusOr<google::longrunning::Operation> CloudRedisClient::UpgradeInstance(
    NoAwaitTag, google::cloud::redis::v1::UpgradeInstanceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpgradeInstance(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::redis::v1::Instance>>
CloudRedisClient::UpgradeInstance(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpgradeInstance(operation);
}

future<StatusOr<google::cloud::redis::v1::Instance>>
CloudRedisClient::ImportInstance(
    std::string const& name,
    google::cloud::redis::v1::InputConfig const& input_config, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::redis::v1::ImportInstanceRequest request;
  request.set_name(name);
  *request.mutable_input_config() = input_config;
  return connection_->ImportInstance(request);
}

StatusOr<google::longrunning::Operation> CloudRedisClient::ImportInstance(
    NoAwaitTag, std::string const& name,
    google::cloud::redis::v1::InputConfig const& input_config, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::redis::v1::ImportInstanceRequest request;
  request.set_name(name);
  *request.mutable_input_config() = input_config;
  return connection_->ImportInstance(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::redis::v1::Instance>>
CloudRedisClient::ImportInstance(
    google::cloud::redis::v1::ImportInstanceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ImportInstance(request);
}

StatusOr<google::longrunning::Operation> CloudRedisClient::ImportInstance(
    NoAwaitTag, google::cloud::redis::v1::ImportInstanceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ImportInstance(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::redis::v1::Instance>>
CloudRedisClient::ImportInstance(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ImportInstance(operation);
}

future<StatusOr<google::cloud::redis::v1::Instance>>
CloudRedisClient::ExportInstance(
    std::string const& name,
    google::cloud::redis::v1::OutputConfig const& output_config, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::redis::v1::ExportInstanceRequest request;
  request.set_name(name);
  *request.mutable_output_config() = output_config;
  return connection_->ExportInstance(request);
}

StatusOr<google::longrunning::Operation> CloudRedisClient::ExportInstance(
    NoAwaitTag, std::string const& name,
    google::cloud::redis::v1::OutputConfig const& output_config, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::redis::v1::ExportInstanceRequest request;
  request.set_name(name);
  *request.mutable_output_config() = output_config;
  return connection_->ExportInstance(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::redis::v1::Instance>>
CloudRedisClient::ExportInstance(
    google::cloud::redis::v1::ExportInstanceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ExportInstance(request);
}

StatusOr<google::longrunning::Operation> CloudRedisClient::ExportInstance(
    NoAwaitTag, google::cloud::redis::v1::ExportInstanceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ExportInstance(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::redis::v1::Instance>>
CloudRedisClient::ExportInstance(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ExportInstance(operation);
}

future<StatusOr<google::cloud::redis::v1::Instance>>
CloudRedisClient::FailoverInstance(
    std::string const& name,
    google::cloud::redis::v1::FailoverInstanceRequest::DataProtectionMode
        data_protection_mode,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::redis::v1::FailoverInstanceRequest request;
  request.set_name(name);
  request.set_data_protection_mode(data_protection_mode);
  return connection_->FailoverInstance(request);
}

StatusOr<google::longrunning::Operation> CloudRedisClient::FailoverInstance(
    NoAwaitTag, std::string const& name,
    google::cloud::redis::v1::FailoverInstanceRequest::DataProtectionMode
        data_protection_mode,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::redis::v1::FailoverInstanceRequest request;
  request.set_name(name);
  request.set_data_protection_mode(data_protection_mode);
  return connection_->FailoverInstance(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::redis::v1::Instance>>
CloudRedisClient::FailoverInstance(
    google::cloud::redis::v1::FailoverInstanceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->FailoverInstance(request);
}

StatusOr<google::longrunning::Operation> CloudRedisClient::FailoverInstance(
    NoAwaitTag,
    google::cloud::redis::v1::FailoverInstanceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->FailoverInstance(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::redis::v1::Instance>>
CloudRedisClient::FailoverInstance(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->FailoverInstance(operation);
}

future<StatusOr<google::cloud::redis::v1::OperationMetadata>>
CloudRedisClient::DeleteInstance(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::redis::v1::DeleteInstanceRequest request;
  request.set_name(name);
  return connection_->DeleteInstance(request);
}

StatusOr<google::longrunning::Operation> CloudRedisClient::DeleteInstance(
    NoAwaitTag, std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::redis::v1::DeleteInstanceRequest request;
  request.set_name(name);
  return connection_->DeleteInstance(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::redis::v1::OperationMetadata>>
CloudRedisClient::DeleteInstance(
    google::cloud::redis::v1::DeleteInstanceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteInstance(request);
}

StatusOr<google::longrunning::Operation> CloudRedisClient::DeleteInstance(
    NoAwaitTag, google::cloud::redis::v1::DeleteInstanceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteInstance(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::redis::v1::OperationMetadata>>
CloudRedisClient::DeleteInstance(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteInstance(operation);
}

future<StatusOr<google::cloud::redis::v1::Instance>>
CloudRedisClient::RescheduleMaintenance(
    std::string const& name,
    google::cloud::redis::v1::RescheduleMaintenanceRequest::RescheduleType
        reschedule_type,
    google::protobuf::Timestamp const& schedule_time, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::redis::v1::RescheduleMaintenanceRequest request;
  request.set_name(name);
  request.set_reschedule_type(reschedule_type);
  *request.mutable_schedule_time() = schedule_time;
  return connection_->RescheduleMaintenance(request);
}

StatusOr<google::longrunning::Operation>
CloudRedisClient::RescheduleMaintenance(
    NoAwaitTag, std::string const& name,
    google::cloud::redis::v1::RescheduleMaintenanceRequest::RescheduleType
        reschedule_type,
    google::protobuf::Timestamp const& schedule_time, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::redis::v1::RescheduleMaintenanceRequest request;
  request.set_name(name);
  request.set_reschedule_type(reschedule_type);
  *request.mutable_schedule_time() = schedule_time;
  return connection_->RescheduleMaintenance(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::redis::v1::Instance>>
CloudRedisClient::RescheduleMaintenance(
    google::cloud::redis::v1::RescheduleMaintenanceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RescheduleMaintenance(request);
}

StatusOr<google::longrunning::Operation>
CloudRedisClient::RescheduleMaintenance(
    NoAwaitTag,
    google::cloud::redis::v1::RescheduleMaintenanceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RescheduleMaintenance(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::redis::v1::Instance>>
CloudRedisClient::RescheduleMaintenance(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RescheduleMaintenance(operation);
}

StreamRange<google::cloud::location::Location> CloudRedisClient::ListLocations(
    google::cloud::location::ListLocationsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListLocations(std::move(request));
}

StatusOr<google::cloud::location::Location> CloudRedisClient::GetLocation(
    google::cloud::location::GetLocationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetLocation(request);
}

StreamRange<google::longrunning::Operation> CloudRedisClient::ListOperations(
    std::string const& name, std::string const& filter, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::ListOperationsRequest request;
  request.set_name(name);
  request.set_filter(filter);
  return connection_->ListOperations(request);
}

StreamRange<google::longrunning::Operation> CloudRedisClient::ListOperations(
    google::longrunning::ListOperationsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListOperations(std::move(request));
}

StatusOr<google::longrunning::Operation> CloudRedisClient::GetOperation(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::GetOperationRequest request;
  request.set_name(name);
  return connection_->GetOperation(request);
}

StatusOr<google::longrunning::Operation> CloudRedisClient::GetOperation(
    google::longrunning::GetOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetOperation(request);
}

Status CloudRedisClient::DeleteOperation(std::string const& name,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::DeleteOperationRequest request;
  request.set_name(name);
  return connection_->DeleteOperation(request);
}

Status CloudRedisClient::DeleteOperation(
    google::longrunning::DeleteOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteOperation(request);
}

Status CloudRedisClient::CancelOperation(std::string const& name,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::CancelOperationRequest request;
  request.set_name(name);
  return connection_->CancelOperation(request);
}

Status CloudRedisClient::CancelOperation(
    google::longrunning::CancelOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CancelOperation(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace redis_v1
}  // namespace cloud
}  // namespace google
