// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/recaptchaenterprise/v1/recaptchaenterprise.proto

#include "google/cloud/internal/disable_deprecation_warnings.inc"
#include "google/cloud/recaptchaenterprise/v1/recaptcha_enterprise_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace recaptchaenterprise_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

RecaptchaEnterpriseServiceClient::RecaptchaEnterpriseServiceClient(
    std::shared_ptr<RecaptchaEnterpriseServiceConnection> connection,
    Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
RecaptchaEnterpriseServiceClient::~RecaptchaEnterpriseServiceClient() = default;

StatusOr<google::cloud::recaptchaenterprise::v1::Assessment>
RecaptchaEnterpriseServiceClient::CreateAssessment(
    std::string const& parent,
    google::cloud::recaptchaenterprise::v1::Assessment const& assessment,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::recaptchaenterprise::v1::CreateAssessmentRequest request;
  request.set_parent(parent);
  *request.mutable_assessment() = assessment;
  return connection_->CreateAssessment(request);
}

StatusOr<google::cloud::recaptchaenterprise::v1::Assessment>
RecaptchaEnterpriseServiceClient::CreateAssessment(
    google::cloud::recaptchaenterprise::v1::CreateAssessmentRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateAssessment(request);
}

StatusOr<google::cloud::recaptchaenterprise::v1::AnnotateAssessmentResponse>
RecaptchaEnterpriseServiceClient::AnnotateAssessment(
    std::string const& name,
    google::cloud::recaptchaenterprise::v1::AnnotateAssessmentRequest::
        Annotation annotation,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::recaptchaenterprise::v1::AnnotateAssessmentRequest request;
  request.set_name(name);
  request.set_annotation(annotation);
  return connection_->AnnotateAssessment(request);
}

StatusOr<google::cloud::recaptchaenterprise::v1::AnnotateAssessmentResponse>
RecaptchaEnterpriseServiceClient::AnnotateAssessment(
    google::cloud::recaptchaenterprise::v1::AnnotateAssessmentRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->AnnotateAssessment(request);
}

StatusOr<google::cloud::recaptchaenterprise::v1::Key>
RecaptchaEnterpriseServiceClient::CreateKey(
    std::string const& parent,
    google::cloud::recaptchaenterprise::v1::Key const& key, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::recaptchaenterprise::v1::CreateKeyRequest request;
  request.set_parent(parent);
  *request.mutable_key() = key;
  return connection_->CreateKey(request);
}

StatusOr<google::cloud::recaptchaenterprise::v1::Key>
RecaptchaEnterpriseServiceClient::CreateKey(
    google::cloud::recaptchaenterprise::v1::CreateKeyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateKey(request);
}

StreamRange<google::cloud::recaptchaenterprise::v1::Key>
RecaptchaEnterpriseServiceClient::ListKeys(std::string const& parent,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::recaptchaenterprise::v1::ListKeysRequest request;
  request.set_parent(parent);
  return connection_->ListKeys(request);
}

StreamRange<google::cloud::recaptchaenterprise::v1::Key>
RecaptchaEnterpriseServiceClient::ListKeys(
    google::cloud::recaptchaenterprise::v1::ListKeysRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListKeys(std::move(request));
}

StatusOr<
    google::cloud::recaptchaenterprise::v1::RetrieveLegacySecretKeyResponse>
RecaptchaEnterpriseServiceClient::RetrieveLegacySecretKey(
    std::string const& key, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::recaptchaenterprise::v1::RetrieveLegacySecretKeyRequest
      request;
  request.set_key(key);
  return connection_->RetrieveLegacySecretKey(request);
}

StatusOr<
    google::cloud::recaptchaenterprise::v1::RetrieveLegacySecretKeyResponse>
RecaptchaEnterpriseServiceClient::RetrieveLegacySecretKey(
    google::cloud::recaptchaenterprise::v1::
        RetrieveLegacySecretKeyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RetrieveLegacySecretKey(request);
}

StatusOr<google::cloud::recaptchaenterprise::v1::Key>
RecaptchaEnterpriseServiceClient::GetKey(std::string const& name,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::recaptchaenterprise::v1::GetKeyRequest request;
  request.set_name(name);
  return connection_->GetKey(request);
}

StatusOr<google::cloud::recaptchaenterprise::v1::Key>
RecaptchaEnterpriseServiceClient::GetKey(
    google::cloud::recaptchaenterprise::v1::GetKeyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetKey(request);
}

StatusOr<google::cloud::recaptchaenterprise::v1::Key>
RecaptchaEnterpriseServiceClient::UpdateKey(
    google::cloud::recaptchaenterprise::v1::Key const& key,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::recaptchaenterprise::v1::UpdateKeyRequest request;
  *request.mutable_key() = key;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateKey(request);
}

StatusOr<google::cloud::recaptchaenterprise::v1::Key>
RecaptchaEnterpriseServiceClient::UpdateKey(
    google::cloud::recaptchaenterprise::v1::UpdateKeyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateKey(request);
}

Status RecaptchaEnterpriseServiceClient::DeleteKey(std::string const& name,
                                                   Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::recaptchaenterprise::v1::DeleteKeyRequest request;
  request.set_name(name);
  return connection_->DeleteKey(request);
}

Status RecaptchaEnterpriseServiceClient::DeleteKey(
    google::cloud::recaptchaenterprise::v1::DeleteKeyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteKey(request);
}

StatusOr<google::cloud::recaptchaenterprise::v1::Key>
RecaptchaEnterpriseServiceClient::MigrateKey(
    google::cloud::recaptchaenterprise::v1::MigrateKeyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->MigrateKey(request);
}

StatusOr<google::cloud::recaptchaenterprise::v1::AddIpOverrideResponse>
RecaptchaEnterpriseServiceClient::AddIpOverride(
    std::string const& name,
    google::cloud::recaptchaenterprise::v1::IpOverrideData const&
        ip_override_data,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::recaptchaenterprise::v1::AddIpOverrideRequest request;
  request.set_name(name);
  *request.mutable_ip_override_data() = ip_override_data;
  return connection_->AddIpOverride(request);
}

StatusOr<google::cloud::recaptchaenterprise::v1::AddIpOverrideResponse>
RecaptchaEnterpriseServiceClient::AddIpOverride(
    google::cloud::recaptchaenterprise::v1::AddIpOverrideRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->AddIpOverride(request);
}

StatusOr<google::cloud::recaptchaenterprise::v1::RemoveIpOverrideResponse>
RecaptchaEnterpriseServiceClient::RemoveIpOverride(
    std::string const& name,
    google::cloud::recaptchaenterprise::v1::IpOverrideData const&
        ip_override_data,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::recaptchaenterprise::v1::RemoveIpOverrideRequest request;
  request.set_name(name);
  *request.mutable_ip_override_data() = ip_override_data;
  return connection_->RemoveIpOverride(request);
}

StatusOr<google::cloud::recaptchaenterprise::v1::RemoveIpOverrideResponse>
RecaptchaEnterpriseServiceClient::RemoveIpOverride(
    google::cloud::recaptchaenterprise::v1::RemoveIpOverrideRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RemoveIpOverride(request);
}

StreamRange<google::cloud::recaptchaenterprise::v1::IpOverrideData>
RecaptchaEnterpriseServiceClient::ListIpOverrides(std::string const& parent,
                                                  Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::recaptchaenterprise::v1::ListIpOverridesRequest request;
  request.set_parent(parent);
  return connection_->ListIpOverrides(request);
}

StreamRange<google::cloud::recaptchaenterprise::v1::IpOverrideData>
RecaptchaEnterpriseServiceClient::ListIpOverrides(
    google::cloud::recaptchaenterprise::v1::ListIpOverridesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListIpOverrides(std::move(request));
}

StatusOr<google::cloud::recaptchaenterprise::v1::Metrics>
RecaptchaEnterpriseServiceClient::GetMetrics(std::string const& name,
                                             Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::recaptchaenterprise::v1::GetMetricsRequest request;
  request.set_name(name);
  return connection_->GetMetrics(request);
}

StatusOr<google::cloud::recaptchaenterprise::v1::Metrics>
RecaptchaEnterpriseServiceClient::GetMetrics(
    google::cloud::recaptchaenterprise::v1::GetMetricsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetMetrics(request);
}

StatusOr<google::cloud::recaptchaenterprise::v1::FirewallPolicy>
RecaptchaEnterpriseServiceClient::CreateFirewallPolicy(
    std::string const& parent,
    google::cloud::recaptchaenterprise::v1::FirewallPolicy const&
        firewall_policy,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::recaptchaenterprise::v1::CreateFirewallPolicyRequest request;
  request.set_parent(parent);
  *request.mutable_firewall_policy() = firewall_policy;
  return connection_->CreateFirewallPolicy(request);
}

StatusOr<google::cloud::recaptchaenterprise::v1::FirewallPolicy>
RecaptchaEnterpriseServiceClient::CreateFirewallPolicy(
    google::cloud::recaptchaenterprise::v1::CreateFirewallPolicyRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateFirewallPolicy(request);
}

StreamRange<google::cloud::recaptchaenterprise::v1::FirewallPolicy>
RecaptchaEnterpriseServiceClient::ListFirewallPolicies(
    std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::recaptchaenterprise::v1::ListFirewallPoliciesRequest request;
  request.set_parent(parent);
  return connection_->ListFirewallPolicies(request);
}

StreamRange<google::cloud::recaptchaenterprise::v1::FirewallPolicy>
RecaptchaEnterpriseServiceClient::ListFirewallPolicies(
    google::cloud::recaptchaenterprise::v1::ListFirewallPoliciesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListFirewallPolicies(std::move(request));
}

StatusOr<google::cloud::recaptchaenterprise::v1::FirewallPolicy>
RecaptchaEnterpriseServiceClient::GetFirewallPolicy(std::string const& name,
                                                    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::recaptchaenterprise::v1::GetFirewallPolicyRequest request;
  request.set_name(name);
  return connection_->GetFirewallPolicy(request);
}

StatusOr<google::cloud::recaptchaenterprise::v1::FirewallPolicy>
RecaptchaEnterpriseServiceClient::GetFirewallPolicy(
    google::cloud::recaptchaenterprise::v1::GetFirewallPolicyRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetFirewallPolicy(request);
}

StatusOr<google::cloud::recaptchaenterprise::v1::FirewallPolicy>
RecaptchaEnterpriseServiceClient::UpdateFirewallPolicy(
    google::cloud::recaptchaenterprise::v1::FirewallPolicy const&
        firewall_policy,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::recaptchaenterprise::v1::UpdateFirewallPolicyRequest request;
  *request.mutable_firewall_policy() = firewall_policy;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateFirewallPolicy(request);
}

StatusOr<google::cloud::recaptchaenterprise::v1::FirewallPolicy>
RecaptchaEnterpriseServiceClient::UpdateFirewallPolicy(
    google::cloud::recaptchaenterprise::v1::UpdateFirewallPolicyRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateFirewallPolicy(request);
}

Status RecaptchaEnterpriseServiceClient::DeleteFirewallPolicy(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::recaptchaenterprise::v1::DeleteFirewallPolicyRequest request;
  request.set_name(name);
  return connection_->DeleteFirewallPolicy(request);
}

Status RecaptchaEnterpriseServiceClient::DeleteFirewallPolicy(
    google::cloud::recaptchaenterprise::v1::DeleteFirewallPolicyRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteFirewallPolicy(request);
}

StatusOr<
    google::cloud::recaptchaenterprise::v1::ReorderFirewallPoliciesResponse>
RecaptchaEnterpriseServiceClient::ReorderFirewallPolicies(
    std::string const& parent, std::vector<std::string> const& names,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::recaptchaenterprise::v1::ReorderFirewallPoliciesRequest
      request;
  request.set_parent(parent);
  *request.mutable_names() = {names.begin(), names.end()};
  return connection_->ReorderFirewallPolicies(request);
}

StatusOr<
    google::cloud::recaptchaenterprise::v1::ReorderFirewallPoliciesResponse>
RecaptchaEnterpriseServiceClient::ReorderFirewallPolicies(
    google::cloud::recaptchaenterprise::v1::
        ReorderFirewallPoliciesRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ReorderFirewallPolicies(request);
}

StreamRange<google::cloud::recaptchaenterprise::v1::RelatedAccountGroup>
RecaptchaEnterpriseServiceClient::ListRelatedAccountGroups(
    std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::recaptchaenterprise::v1::ListRelatedAccountGroupsRequest
      request;
  request.set_parent(parent);
  return connection_->ListRelatedAccountGroups(request);
}

StreamRange<google::cloud::recaptchaenterprise::v1::RelatedAccountGroup>
RecaptchaEnterpriseServiceClient::ListRelatedAccountGroups(
    google::cloud::recaptchaenterprise::v1::ListRelatedAccountGroupsRequest
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListRelatedAccountGroups(std::move(request));
}

StreamRange<
    google::cloud::recaptchaenterprise::v1::RelatedAccountGroupMembership>
RecaptchaEnterpriseServiceClient::ListRelatedAccountGroupMemberships(
    std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::recaptchaenterprise::v1::
      ListRelatedAccountGroupMembershipsRequest request;
  request.set_parent(parent);
  return connection_->ListRelatedAccountGroupMemberships(request);
}

StreamRange<
    google::cloud::recaptchaenterprise::v1::RelatedAccountGroupMembership>
RecaptchaEnterpriseServiceClient::ListRelatedAccountGroupMemberships(
    google::cloud::recaptchaenterprise::v1::
        ListRelatedAccountGroupMembershipsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListRelatedAccountGroupMemberships(std::move(request));
}

StreamRange<
    google::cloud::recaptchaenterprise::v1::RelatedAccountGroupMembership>
RecaptchaEnterpriseServiceClient::SearchRelatedAccountGroupMemberships(
    std::string const& project, std::string const& hashed_account_id,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::recaptchaenterprise::v1::
      SearchRelatedAccountGroupMembershipsRequest request;
  request.set_project(project);
  request.set_hashed_account_id(hashed_account_id);
  return connection_->SearchRelatedAccountGroupMemberships(request);
}

StreamRange<
    google::cloud::recaptchaenterprise::v1::RelatedAccountGroupMembership>
RecaptchaEnterpriseServiceClient::SearchRelatedAccountGroupMemberships(
    google::cloud::recaptchaenterprise::v1::
        SearchRelatedAccountGroupMembershipsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SearchRelatedAccountGroupMemberships(std::move(request));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace recaptchaenterprise_v1
}  // namespace cloud
}  // namespace google
