// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source:
// google/cloud/rapidmigrationassessment/v1/rapidmigrationassessment.proto

#include "google/cloud/rapidmigrationassessment/v1/rapid_migration_assessment_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace rapidmigrationassessment_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

RapidMigrationAssessmentConnectionIdempotencyPolicy::
    ~RapidMigrationAssessmentConnectionIdempotencyPolicy() = default;

std::unique_ptr<RapidMigrationAssessmentConnectionIdempotencyPolicy>
RapidMigrationAssessmentConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<RapidMigrationAssessmentConnectionIdempotencyPolicy>(
      *this);
}

Idempotency
RapidMigrationAssessmentConnectionIdempotencyPolicy::CreateCollector(
    google::cloud::rapidmigrationassessment::v1::
        CreateCollectorRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
RapidMigrationAssessmentConnectionIdempotencyPolicy::CreateAnnotation(
    google::cloud::rapidmigrationassessment::v1::
        CreateAnnotationRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency RapidMigrationAssessmentConnectionIdempotencyPolicy::GetAnnotation(
    google::cloud::rapidmigrationassessment::v1::GetAnnotationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency RapidMigrationAssessmentConnectionIdempotencyPolicy::ListCollectors(
    google::cloud::rapidmigrationassessment::v1::
        ListCollectorsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency RapidMigrationAssessmentConnectionIdempotencyPolicy::GetCollector(
    google::cloud::rapidmigrationassessment::v1::GetCollectorRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency
RapidMigrationAssessmentConnectionIdempotencyPolicy::UpdateCollector(
    google::cloud::rapidmigrationassessment::v1::
        UpdateCollectorRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
RapidMigrationAssessmentConnectionIdempotencyPolicy::DeleteCollector(
    google::cloud::rapidmigrationassessment::v1::
        DeleteCollectorRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
RapidMigrationAssessmentConnectionIdempotencyPolicy::ResumeCollector(
    google::cloud::rapidmigrationassessment::v1::
        ResumeCollectorRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
RapidMigrationAssessmentConnectionIdempotencyPolicy::RegisterCollector(
    google::cloud::rapidmigrationassessment::v1::
        RegisterCollectorRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency RapidMigrationAssessmentConnectionIdempotencyPolicy::PauseCollector(
    google::cloud::rapidmigrationassessment::v1::PauseCollectorRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency RapidMigrationAssessmentConnectionIdempotencyPolicy::ListLocations(
    google::cloud::location::ListLocationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency RapidMigrationAssessmentConnectionIdempotencyPolicy::GetLocation(
    google::cloud::location::GetLocationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency RapidMigrationAssessmentConnectionIdempotencyPolicy::ListOperations(
    google::longrunning::ListOperationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency RapidMigrationAssessmentConnectionIdempotencyPolicy::GetOperation(
    google::longrunning::GetOperationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency
RapidMigrationAssessmentConnectionIdempotencyPolicy::DeleteOperation(
    google::longrunning::DeleteOperationRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
RapidMigrationAssessmentConnectionIdempotencyPolicy::CancelOperation(
    google::longrunning::CancelOperationRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<RapidMigrationAssessmentConnectionIdempotencyPolicy>
MakeDefaultRapidMigrationAssessmentConnectionIdempotencyPolicy() {
  return std::make_unique<
      RapidMigrationAssessmentConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace rapidmigrationassessment_v1
}  // namespace cloud
}  // namespace google
