// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source:
// google/cloud/rapidmigrationassessment/v1/rapidmigrationassessment.proto

#include "google/cloud/rapidmigrationassessment/v1/rapid_migration_assessment_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace rapidmigrationassessment_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

RapidMigrationAssessmentClient::RapidMigrationAssessmentClient(
    std::shared_ptr<RapidMigrationAssessmentConnection> connection,
    Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
RapidMigrationAssessmentClient::~RapidMigrationAssessmentClient() = default;

future<StatusOr<google::cloud::rapidmigrationassessment::v1::Collector>>
RapidMigrationAssessmentClient::CreateCollector(
    std::string const& parent,
    google::cloud::rapidmigrationassessment::v1::Collector const& collector,
    std::string const& collector_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::rapidmigrationassessment::v1::CreateCollectorRequest request;
  request.set_parent(parent);
  *request.mutable_collector() = collector;
  request.set_collector_id(collector_id);
  return connection_->CreateCollector(request);
}

StatusOr<google::longrunning::Operation>
RapidMigrationAssessmentClient::CreateCollector(
    NoAwaitTag, std::string const& parent,
    google::cloud::rapidmigrationassessment::v1::Collector const& collector,
    std::string const& collector_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::rapidmigrationassessment::v1::CreateCollectorRequest request;
  request.set_parent(parent);
  *request.mutable_collector() = collector;
  request.set_collector_id(collector_id);
  return connection_->CreateCollector(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::rapidmigrationassessment::v1::Collector>>
RapidMigrationAssessmentClient::CreateCollector(
    google::cloud::rapidmigrationassessment::v1::CreateCollectorRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateCollector(request);
}

StatusOr<google::longrunning::Operation>
RapidMigrationAssessmentClient::CreateCollector(
    NoAwaitTag,
    google::cloud::rapidmigrationassessment::v1::CreateCollectorRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateCollector(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::rapidmigrationassessment::v1::Collector>>
RapidMigrationAssessmentClient::CreateCollector(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateCollector(operation);
}

future<StatusOr<google::cloud::rapidmigrationassessment::v1::Annotation>>
RapidMigrationAssessmentClient::CreateAnnotation(
    std::string const& parent,
    google::cloud::rapidmigrationassessment::v1::Annotation const& annotation,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::rapidmigrationassessment::v1::CreateAnnotationRequest request;
  request.set_parent(parent);
  *request.mutable_annotation() = annotation;
  return connection_->CreateAnnotation(request);
}

StatusOr<google::longrunning::Operation>
RapidMigrationAssessmentClient::CreateAnnotation(
    NoAwaitTag, std::string const& parent,
    google::cloud::rapidmigrationassessment::v1::Annotation const& annotation,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::rapidmigrationassessment::v1::CreateAnnotationRequest request;
  request.set_parent(parent);
  *request.mutable_annotation() = annotation;
  return connection_->CreateAnnotation(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::rapidmigrationassessment::v1::Annotation>>
RapidMigrationAssessmentClient::CreateAnnotation(
    google::cloud::rapidmigrationassessment::v1::CreateAnnotationRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateAnnotation(request);
}

StatusOr<google::longrunning::Operation>
RapidMigrationAssessmentClient::CreateAnnotation(
    NoAwaitTag,
    google::cloud::rapidmigrationassessment::v1::CreateAnnotationRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateAnnotation(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::rapidmigrationassessment::v1::Annotation>>
RapidMigrationAssessmentClient::CreateAnnotation(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateAnnotation(operation);
}

StatusOr<google::cloud::rapidmigrationassessment::v1::Annotation>
RapidMigrationAssessmentClient::GetAnnotation(std::string const& name,
                                              Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::rapidmigrationassessment::v1::GetAnnotationRequest request;
  request.set_name(name);
  return connection_->GetAnnotation(request);
}

StatusOr<google::cloud::rapidmigrationassessment::v1::Annotation>
RapidMigrationAssessmentClient::GetAnnotation(
    google::cloud::rapidmigrationassessment::v1::GetAnnotationRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetAnnotation(request);
}

StreamRange<google::cloud::rapidmigrationassessment::v1::Collector>
RapidMigrationAssessmentClient::ListCollectors(std::string const& parent,
                                               Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::rapidmigrationassessment::v1::ListCollectorsRequest request;
  request.set_parent(parent);
  return connection_->ListCollectors(request);
}

StreamRange<google::cloud::rapidmigrationassessment::v1::Collector>
RapidMigrationAssessmentClient::ListCollectors(
    google::cloud::rapidmigrationassessment::v1::ListCollectorsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListCollectors(std::move(request));
}

StatusOr<google::cloud::rapidmigrationassessment::v1::Collector>
RapidMigrationAssessmentClient::GetCollector(std::string const& name,
                                             Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::rapidmigrationassessment::v1::GetCollectorRequest request;
  request.set_name(name);
  return connection_->GetCollector(request);
}

StatusOr<google::cloud::rapidmigrationassessment::v1::Collector>
RapidMigrationAssessmentClient::GetCollector(
    google::cloud::rapidmigrationassessment::v1::GetCollectorRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetCollector(request);
}

future<StatusOr<google::cloud::rapidmigrationassessment::v1::Collector>>
RapidMigrationAssessmentClient::UpdateCollector(
    google::cloud::rapidmigrationassessment::v1::Collector const& collector,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::rapidmigrationassessment::v1::UpdateCollectorRequest request;
  *request.mutable_collector() = collector;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateCollector(request);
}

StatusOr<google::longrunning::Operation>
RapidMigrationAssessmentClient::UpdateCollector(
    NoAwaitTag,
    google::cloud::rapidmigrationassessment::v1::Collector const& collector,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::rapidmigrationassessment::v1::UpdateCollectorRequest request;
  *request.mutable_collector() = collector;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateCollector(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::rapidmigrationassessment::v1::Collector>>
RapidMigrationAssessmentClient::UpdateCollector(
    google::cloud::rapidmigrationassessment::v1::UpdateCollectorRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateCollector(request);
}

StatusOr<google::longrunning::Operation>
RapidMigrationAssessmentClient::UpdateCollector(
    NoAwaitTag,
    google::cloud::rapidmigrationassessment::v1::UpdateCollectorRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateCollector(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::rapidmigrationassessment::v1::Collector>>
RapidMigrationAssessmentClient::UpdateCollector(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateCollector(operation);
}

future<StatusOr<google::cloud::rapidmigrationassessment::v1::Collector>>
RapidMigrationAssessmentClient::DeleteCollector(std::string const& name,
                                                Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::rapidmigrationassessment::v1::DeleteCollectorRequest request;
  request.set_name(name);
  return connection_->DeleteCollector(request);
}

StatusOr<google::longrunning::Operation>
RapidMigrationAssessmentClient::DeleteCollector(NoAwaitTag,
                                                std::string const& name,
                                                Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::rapidmigrationassessment::v1::DeleteCollectorRequest request;
  request.set_name(name);
  return connection_->DeleteCollector(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::rapidmigrationassessment::v1::Collector>>
RapidMigrationAssessmentClient::DeleteCollector(
    google::cloud::rapidmigrationassessment::v1::DeleteCollectorRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteCollector(request);
}

StatusOr<google::longrunning::Operation>
RapidMigrationAssessmentClient::DeleteCollector(
    NoAwaitTag,
    google::cloud::rapidmigrationassessment::v1::DeleteCollectorRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteCollector(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::rapidmigrationassessment::v1::Collector>>
RapidMigrationAssessmentClient::DeleteCollector(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteCollector(operation);
}

future<StatusOr<google::cloud::rapidmigrationassessment::v1::Collector>>
RapidMigrationAssessmentClient::ResumeCollector(std::string const& name,
                                                Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::rapidmigrationassessment::v1::ResumeCollectorRequest request;
  request.set_name(name);
  return connection_->ResumeCollector(request);
}

StatusOr<google::longrunning::Operation>
RapidMigrationAssessmentClient::ResumeCollector(NoAwaitTag,
                                                std::string const& name,
                                                Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::rapidmigrationassessment::v1::ResumeCollectorRequest request;
  request.set_name(name);
  return connection_->ResumeCollector(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::rapidmigrationassessment::v1::Collector>>
RapidMigrationAssessmentClient::ResumeCollector(
    google::cloud::rapidmigrationassessment::v1::ResumeCollectorRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ResumeCollector(request);
}

StatusOr<google::longrunning::Operation>
RapidMigrationAssessmentClient::ResumeCollector(
    NoAwaitTag,
    google::cloud::rapidmigrationassessment::v1::ResumeCollectorRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ResumeCollector(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::rapidmigrationassessment::v1::Collector>>
RapidMigrationAssessmentClient::ResumeCollector(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ResumeCollector(operation);
}

future<StatusOr<google::cloud::rapidmigrationassessment::v1::Collector>>
RapidMigrationAssessmentClient::RegisterCollector(std::string const& name,
                                                  Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::rapidmigrationassessment::v1::RegisterCollectorRequest request;
  request.set_name(name);
  return connection_->RegisterCollector(request);
}

StatusOr<google::longrunning::Operation>
RapidMigrationAssessmentClient::RegisterCollector(NoAwaitTag,
                                                  std::string const& name,
                                                  Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::rapidmigrationassessment::v1::RegisterCollectorRequest request;
  request.set_name(name);
  return connection_->RegisterCollector(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::rapidmigrationassessment::v1::Collector>>
RapidMigrationAssessmentClient::RegisterCollector(
    google::cloud::rapidmigrationassessment::v1::RegisterCollectorRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RegisterCollector(request);
}

StatusOr<google::longrunning::Operation>
RapidMigrationAssessmentClient::RegisterCollector(
    NoAwaitTag,
    google::cloud::rapidmigrationassessment::v1::RegisterCollectorRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RegisterCollector(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::rapidmigrationassessment::v1::Collector>>
RapidMigrationAssessmentClient::RegisterCollector(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RegisterCollector(operation);
}

future<StatusOr<google::cloud::rapidmigrationassessment::v1::Collector>>
RapidMigrationAssessmentClient::PauseCollector(std::string const& name,
                                               Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::rapidmigrationassessment::v1::PauseCollectorRequest request;
  request.set_name(name);
  return connection_->PauseCollector(request);
}

StatusOr<google::longrunning::Operation>
RapidMigrationAssessmentClient::PauseCollector(NoAwaitTag,
                                               std::string const& name,
                                               Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::rapidmigrationassessment::v1::PauseCollectorRequest request;
  request.set_name(name);
  return connection_->PauseCollector(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::rapidmigrationassessment::v1::Collector>>
RapidMigrationAssessmentClient::PauseCollector(
    google::cloud::rapidmigrationassessment::v1::PauseCollectorRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PauseCollector(request);
}

StatusOr<google::longrunning::Operation>
RapidMigrationAssessmentClient::PauseCollector(
    NoAwaitTag,
    google::cloud::rapidmigrationassessment::v1::PauseCollectorRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PauseCollector(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::rapidmigrationassessment::v1::Collector>>
RapidMigrationAssessmentClient::PauseCollector(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PauseCollector(operation);
}

StreamRange<google::cloud::location::Location>
RapidMigrationAssessmentClient::ListLocations(
    google::cloud::location::ListLocationsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListLocations(std::move(request));
}

StatusOr<google::cloud::location::Location>
RapidMigrationAssessmentClient::GetLocation(
    google::cloud::location::GetLocationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetLocation(request);
}

StreamRange<google::longrunning::Operation>
RapidMigrationAssessmentClient::ListOperations(std::string const& name,
                                               std::string const& filter,
                                               Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::ListOperationsRequest request;
  request.set_name(name);
  request.set_filter(filter);
  return connection_->ListOperations(request);
}

StreamRange<google::longrunning::Operation>
RapidMigrationAssessmentClient::ListOperations(
    google::longrunning::ListOperationsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListOperations(std::move(request));
}

StatusOr<google::longrunning::Operation>
RapidMigrationAssessmentClient::GetOperation(std::string const& name,
                                             Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::GetOperationRequest request;
  request.set_name(name);
  return connection_->GetOperation(request);
}

StatusOr<google::longrunning::Operation>
RapidMigrationAssessmentClient::GetOperation(
    google::longrunning::GetOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetOperation(request);
}

Status RapidMigrationAssessmentClient::DeleteOperation(std::string const& name,
                                                       Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::DeleteOperationRequest request;
  request.set_name(name);
  return connection_->DeleteOperation(request);
}

Status RapidMigrationAssessmentClient::DeleteOperation(
    google::longrunning::DeleteOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteOperation(request);
}

Status RapidMigrationAssessmentClient::CancelOperation(std::string const& name,
                                                       Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::CancelOperationRequest request;
  request.set_name(name);
  return connection_->CancelOperation(request);
}

Status RapidMigrationAssessmentClient::CancelOperation(
    google::longrunning::CancelOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CancelOperation(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace rapidmigrationassessment_v1
}  // namespace cloud
}  // namespace google
