// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source:
// google/cloud/rapidmigrationassessment/v1/rapidmigrationassessment.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RAPIDMIGRATIONASSESSMENT_V1_INTERNAL_RAPID_MIGRATION_ASSESSMENT_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RAPIDMIGRATIONASSESSMENT_V1_INTERNAL_RAPID_MIGRATION_ASSESSMENT_TRACING_CONNECTION_H

#include "google/cloud/rapidmigrationassessment/v1/rapid_migration_assessment_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace rapidmigrationassessment_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class RapidMigrationAssessmentTracingConnection
    : public rapidmigrationassessment_v1::RapidMigrationAssessmentConnection {
 public:
  ~RapidMigrationAssessmentTracingConnection() override = default;

  explicit RapidMigrationAssessmentTracingConnection(
      std::shared_ptr<
          rapidmigrationassessment_v1::RapidMigrationAssessmentConnection>
          child);

  Options options() override { return child_->options(); }

  future<StatusOr<google::cloud::rapidmigrationassessment::v1::Collector>>
  CreateCollector(
      google::cloud::rapidmigrationassessment::v1::CreateCollectorRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> CreateCollector(
      NoAwaitTag,
      google::cloud::rapidmigrationassessment::v1::CreateCollectorRequest const&
          request) override;

  future<StatusOr<google::cloud::rapidmigrationassessment::v1::Collector>>
  CreateCollector(google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::rapidmigrationassessment::v1::Annotation>>
  CreateAnnotation(google::cloud::rapidmigrationassessment::v1::
                       CreateAnnotationRequest const& request) override;

  StatusOr<google::longrunning::Operation> CreateAnnotation(
      NoAwaitTag, google::cloud::rapidmigrationassessment::v1::
                      CreateAnnotationRequest const& request) override;

  future<StatusOr<google::cloud::rapidmigrationassessment::v1::Annotation>>
  CreateAnnotation(google::longrunning::Operation const& operation) override;

  StatusOr<google::cloud::rapidmigrationassessment::v1::Annotation>
  GetAnnotation(
      google::cloud::rapidmigrationassessment::v1::GetAnnotationRequest const&
          request) override;

  StreamRange<google::cloud::rapidmigrationassessment::v1::Collector>
  ListCollectors(
      google::cloud::rapidmigrationassessment::v1::ListCollectorsRequest
          request) override;

  StatusOr<google::cloud::rapidmigrationassessment::v1::Collector> GetCollector(
      google::cloud::rapidmigrationassessment::v1::GetCollectorRequest const&
          request) override;

  future<StatusOr<google::cloud::rapidmigrationassessment::v1::Collector>>
  UpdateCollector(
      google::cloud::rapidmigrationassessment::v1::UpdateCollectorRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> UpdateCollector(
      NoAwaitTag,
      google::cloud::rapidmigrationassessment::v1::UpdateCollectorRequest const&
          request) override;

  future<StatusOr<google::cloud::rapidmigrationassessment::v1::Collector>>
  UpdateCollector(google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::rapidmigrationassessment::v1::Collector>>
  DeleteCollector(
      google::cloud::rapidmigrationassessment::v1::DeleteCollectorRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> DeleteCollector(
      NoAwaitTag,
      google::cloud::rapidmigrationassessment::v1::DeleteCollectorRequest const&
          request) override;

  future<StatusOr<google::cloud::rapidmigrationassessment::v1::Collector>>
  DeleteCollector(google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::rapidmigrationassessment::v1::Collector>>
  ResumeCollector(
      google::cloud::rapidmigrationassessment::v1::ResumeCollectorRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> ResumeCollector(
      NoAwaitTag,
      google::cloud::rapidmigrationassessment::v1::ResumeCollectorRequest const&
          request) override;

  future<StatusOr<google::cloud::rapidmigrationassessment::v1::Collector>>
  ResumeCollector(google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::rapidmigrationassessment::v1::Collector>>
  RegisterCollector(google::cloud::rapidmigrationassessment::v1::
                        RegisterCollectorRequest const& request) override;

  StatusOr<google::longrunning::Operation> RegisterCollector(
      NoAwaitTag, google::cloud::rapidmigrationassessment::v1::
                      RegisterCollectorRequest const& request) override;

  future<StatusOr<google::cloud::rapidmigrationassessment::v1::Collector>>
  RegisterCollector(google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::rapidmigrationassessment::v1::Collector>>
  PauseCollector(
      google::cloud::rapidmigrationassessment::v1::PauseCollectorRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> PauseCollector(
      NoAwaitTag,
      google::cloud::rapidmigrationassessment::v1::PauseCollectorRequest const&
          request) override;

  future<StatusOr<google::cloud::rapidmigrationassessment::v1::Collector>>
  PauseCollector(google::longrunning::Operation const& operation) override;

  StreamRange<google::cloud::location::Location> ListLocations(
      google::cloud::location::ListLocationsRequest request) override;

  StatusOr<google::cloud::location::Location> GetLocation(
      google::cloud::location::GetLocationRequest const& request) override;

  StreamRange<google::longrunning::Operation> ListOperations(
      google::longrunning::ListOperationsRequest request) override;

  StatusOr<google::longrunning::Operation> GetOperation(
      google::longrunning::GetOperationRequest const& request) override;

  Status DeleteOperation(
      google::longrunning::DeleteOperationRequest const& request) override;

  Status CancelOperation(
      google::longrunning::CancelOperationRequest const& request) override;

 private:
  std::shared_ptr<
      rapidmigrationassessment_v1::RapidMigrationAssessmentConnection>
      child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<rapidmigrationassessment_v1::RapidMigrationAssessmentConnection>
MakeRapidMigrationAssessmentTracingConnection(
    std::shared_ptr<
        rapidmigrationassessment_v1::RapidMigrationAssessmentConnection>
        conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace rapidmigrationassessment_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RAPIDMIGRATIONASSESSMENT_V1_INTERNAL_RAPID_MIGRATION_ASSESSMENT_TRACING_CONNECTION_H
