// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/pubsub/v1/schema.proto

#include "google/cloud/pubsub/internal/schema_connection_impl.h"
#include "google/cloud/pubsub/internal/schema_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace pubsub_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<pubsub::SchemaServiceRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<pubsub::SchemaServiceRetryPolicyOption>()->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options.get<pubsub::SchemaServiceBackoffPolicyOption>()->clone();
}

std::unique_ptr<pubsub::SchemaServiceConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options.get<pubsub::SchemaServiceConnectionIdempotencyPolicyOption>()
      ->clone();
}

}  // namespace

SchemaServiceConnectionImpl::SchemaServiceConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<pubsub_internal::SchemaServiceStub> stub, Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(std::move(options),
                                      SchemaServiceConnection::options())) {}

StatusOr<google::pubsub::v1::Schema> SchemaServiceConnectionImpl::CreateSchema(
    google::pubsub::v1::CreateSchemaRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateSchema(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::pubsub::v1::CreateSchemaRequest const& request) {
        return stub_->CreateSchema(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::pubsub::v1::Schema> SchemaServiceConnectionImpl::GetSchema(
    google::pubsub::v1::GetSchemaRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetSchema(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::pubsub::v1::GetSchemaRequest const& request) {
        return stub_->GetSchema(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::pubsub::v1::Schema>
SchemaServiceConnectionImpl::ListSchemas(
    google::pubsub::v1::ListSchemasRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListSchemas(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::pubsub::v1::Schema>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<pubsub::SchemaServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::pubsub::v1::ListSchemasRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::pubsub::v1::ListSchemasRequest const& request) {
              return stub->ListSchemas(context, options, request);
            },
            options, r, function_name);
      },
      [](google::pubsub::v1::ListSchemasResponse r) {
        std::vector<google::pubsub::v1::Schema> result(r.schemas().size());
        auto& messages = *r.mutable_schemas();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StreamRange<google::pubsub::v1::Schema>
SchemaServiceConnectionImpl::ListSchemaRevisions(
    google::pubsub::v1::ListSchemaRevisionsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListSchemaRevisions(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::pubsub::v1::Schema>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<pubsub::SchemaServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::pubsub::v1::ListSchemaRevisionsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context, Options const& options,
                google::pubsub::v1::ListSchemaRevisionsRequest const& request) {
              return stub->ListSchemaRevisions(context, options, request);
            },
            options, r, function_name);
      },
      [](google::pubsub::v1::ListSchemaRevisionsResponse r) {
        std::vector<google::pubsub::v1::Schema> result(r.schemas().size());
        auto& messages = *r.mutable_schemas();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::pubsub::v1::Schema> SchemaServiceConnectionImpl::CommitSchema(
    google::pubsub::v1::CommitSchemaRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CommitSchema(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::pubsub::v1::CommitSchemaRequest const& request) {
        return stub_->CommitSchema(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::pubsub::v1::Schema>
SchemaServiceConnectionImpl::RollbackSchema(
    google::pubsub::v1::RollbackSchemaRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->RollbackSchema(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::pubsub::v1::RollbackSchemaRequest const& request) {
        return stub_->RollbackSchema(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::pubsub::v1::Schema>
SchemaServiceConnectionImpl::DeleteSchemaRevision(
    google::pubsub::v1::DeleteSchemaRevisionRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteSchemaRevision(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::pubsub::v1::DeleteSchemaRevisionRequest const& request) {
        return stub_->DeleteSchemaRevision(context, options, request);
      },
      *current, request, __func__);
}

Status SchemaServiceConnectionImpl::DeleteSchema(
    google::pubsub::v1::DeleteSchemaRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteSchema(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::pubsub::v1::DeleteSchemaRequest const& request) {
        return stub_->DeleteSchema(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::pubsub::v1::ValidateSchemaResponse>
SchemaServiceConnectionImpl::ValidateSchema(
    google::pubsub::v1::ValidateSchemaRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->ValidateSchema(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::pubsub::v1::ValidateSchemaRequest const& request) {
        return stub_->ValidateSchema(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::pubsub::v1::ValidateMessageResponse>
SchemaServiceConnectionImpl::ValidateMessage(
    google::pubsub::v1::ValidateMessageRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->ValidateMessage(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::pubsub::v1::ValidateMessageRequest const& request) {
        return stub_->ValidateMessage(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::iam::v1::Policy> SchemaServiceConnectionImpl::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->SetIamPolicy(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::iam::v1::SetIamPolicyRequest const& request) {
        return stub_->SetIamPolicy(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::iam::v1::Policy> SchemaServiceConnectionImpl::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetIamPolicy(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::iam::v1::GetIamPolicyRequest const& request) {
        return stub_->GetIamPolicy(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
SchemaServiceConnectionImpl::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->TestIamPermissions(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::iam::v1::TestIamPermissionsRequest const& request) {
        return stub_->TestIamPermissions(context, options, request);
      },
      *current, request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace pubsub_internal
}  // namespace cloud
}  // namespace google
