// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/pubsub/v1/schema.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_PUBSUB_INTERNAL_SCHEMA_AUTH_DECORATOR_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_PUBSUB_INTERNAL_SCHEMA_AUTH_DECORATOR_H

#include "google/cloud/pubsub/internal/schema_stub.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include "google/cloud/version.h"
#include <memory>
#include <set>
#include <string>

namespace google {
namespace cloud {
namespace pubsub_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class SchemaServiceAuth : public SchemaServiceStub {
 public:
  ~SchemaServiceAuth() override = default;
  SchemaServiceAuth(
      std::shared_ptr<google::cloud::internal::GrpcAuthenticationStrategy> auth,
      std::shared_ptr<SchemaServiceStub> child);

  StatusOr<google::pubsub::v1::Schema> CreateSchema(
      grpc::ClientContext& context, Options const& options,
      google::pubsub::v1::CreateSchemaRequest const& request) override;

  StatusOr<google::pubsub::v1::Schema> GetSchema(
      grpc::ClientContext& context, Options const& options,
      google::pubsub::v1::GetSchemaRequest const& request) override;

  StatusOr<google::pubsub::v1::ListSchemasResponse> ListSchemas(
      grpc::ClientContext& context, Options const& options,
      google::pubsub::v1::ListSchemasRequest const& request) override;

  StatusOr<google::pubsub::v1::ListSchemaRevisionsResponse> ListSchemaRevisions(
      grpc::ClientContext& context, Options const& options,
      google::pubsub::v1::ListSchemaRevisionsRequest const& request) override;

  StatusOr<google::pubsub::v1::Schema> CommitSchema(
      grpc::ClientContext& context, Options const& options,
      google::pubsub::v1::CommitSchemaRequest const& request) override;

  StatusOr<google::pubsub::v1::Schema> RollbackSchema(
      grpc::ClientContext& context, Options const& options,
      google::pubsub::v1::RollbackSchemaRequest const& request) override;

  StatusOr<google::pubsub::v1::Schema> DeleteSchemaRevision(
      grpc::ClientContext& context, Options const& options,
      google::pubsub::v1::DeleteSchemaRevisionRequest const& request) override;

  Status DeleteSchema(
      grpc::ClientContext& context, Options const& options,
      google::pubsub::v1::DeleteSchemaRequest const& request) override;

  StatusOr<google::pubsub::v1::ValidateSchemaResponse> ValidateSchema(
      grpc::ClientContext& context, Options const& options,
      google::pubsub::v1::ValidateSchemaRequest const& request) override;

  StatusOr<google::pubsub::v1::ValidateMessageResponse> ValidateMessage(
      grpc::ClientContext& context, Options const& options,
      google::pubsub::v1::ValidateMessageRequest const& request) override;

  StatusOr<google::iam::v1::Policy> SetIamPolicy(
      grpc::ClientContext& context, Options const& options,
      google::iam::v1::SetIamPolicyRequest const& request) override;

  StatusOr<google::iam::v1::Policy> GetIamPolicy(
      grpc::ClientContext& context, Options const& options,
      google::iam::v1::GetIamPolicyRequest const& request) override;

  StatusOr<google::iam::v1::TestIamPermissionsResponse> TestIamPermissions(
      grpc::ClientContext& context, Options const& options,
      google::iam::v1::TestIamPermissionsRequest const& request) override;

 private:
  std::shared_ptr<google::cloud::internal::GrpcAuthenticationStrategy> auth_;
  std::shared_ptr<SchemaServiceStub> child_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace pubsub_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_PUBSUB_INTERNAL_SCHEMA_AUTH_DECORATOR_H
