// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.proto

#include "google/cloud/privilegedaccessmanager/v1/privileged_access_manager_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace privilegedaccessmanager_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

PrivilegedAccessManagerClient::PrivilegedAccessManagerClient(
    std::shared_ptr<PrivilegedAccessManagerConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
PrivilegedAccessManagerClient::~PrivilegedAccessManagerClient() = default;

StatusOr<
    google::cloud::privilegedaccessmanager::v1::CheckOnboardingStatusResponse>
PrivilegedAccessManagerClient::CheckOnboardingStatus(
    google::cloud::privilegedaccessmanager::v1::
        CheckOnboardingStatusRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CheckOnboardingStatus(request);
}

StreamRange<google::cloud::privilegedaccessmanager::v1::Entitlement>
PrivilegedAccessManagerClient::ListEntitlements(std::string const& parent,
                                                Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::privilegedaccessmanager::v1::ListEntitlementsRequest request;
  request.set_parent(parent);
  return connection_->ListEntitlements(request);
}

StreamRange<google::cloud::privilegedaccessmanager::v1::Entitlement>
PrivilegedAccessManagerClient::ListEntitlements(
    google::cloud::privilegedaccessmanager::v1::ListEntitlementsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListEntitlements(std::move(request));
}

StreamRange<google::cloud::privilegedaccessmanager::v1::Entitlement>
PrivilegedAccessManagerClient::SearchEntitlements(
    google::cloud::privilegedaccessmanager::v1::SearchEntitlementsRequest
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SearchEntitlements(std::move(request));
}

StatusOr<google::cloud::privilegedaccessmanager::v1::Entitlement>
PrivilegedAccessManagerClient::GetEntitlement(std::string const& name,
                                              Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::privilegedaccessmanager::v1::GetEntitlementRequest request;
  request.set_name(name);
  return connection_->GetEntitlement(request);
}

StatusOr<google::cloud::privilegedaccessmanager::v1::Entitlement>
PrivilegedAccessManagerClient::GetEntitlement(
    google::cloud::privilegedaccessmanager::v1::GetEntitlementRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetEntitlement(request);
}

future<StatusOr<google::cloud::privilegedaccessmanager::v1::Entitlement>>
PrivilegedAccessManagerClient::CreateEntitlement(
    std::string const& parent,
    google::cloud::privilegedaccessmanager::v1::Entitlement const& entitlement,
    std::string const& entitlement_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::privilegedaccessmanager::v1::CreateEntitlementRequest request;
  request.set_parent(parent);
  *request.mutable_entitlement() = entitlement;
  request.set_entitlement_id(entitlement_id);
  return connection_->CreateEntitlement(request);
}

StatusOr<google::longrunning::Operation>
PrivilegedAccessManagerClient::CreateEntitlement(
    NoAwaitTag, std::string const& parent,
    google::cloud::privilegedaccessmanager::v1::Entitlement const& entitlement,
    std::string const& entitlement_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::privilegedaccessmanager::v1::CreateEntitlementRequest request;
  request.set_parent(parent);
  *request.mutable_entitlement() = entitlement;
  request.set_entitlement_id(entitlement_id);
  return connection_->CreateEntitlement(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::privilegedaccessmanager::v1::Entitlement>>
PrivilegedAccessManagerClient::CreateEntitlement(
    google::cloud::privilegedaccessmanager::v1::CreateEntitlementRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateEntitlement(request);
}

StatusOr<google::longrunning::Operation>
PrivilegedAccessManagerClient::CreateEntitlement(
    NoAwaitTag,
    google::cloud::privilegedaccessmanager::v1::CreateEntitlementRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateEntitlement(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::privilegedaccessmanager::v1::Entitlement>>
PrivilegedAccessManagerClient::CreateEntitlement(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateEntitlement(operation);
}

future<StatusOr<google::cloud::privilegedaccessmanager::v1::Entitlement>>
PrivilegedAccessManagerClient::DeleteEntitlement(std::string const& name,
                                                 Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::privilegedaccessmanager::v1::DeleteEntitlementRequest request;
  request.set_name(name);
  return connection_->DeleteEntitlement(request);
}

StatusOr<google::longrunning::Operation>
PrivilegedAccessManagerClient::DeleteEntitlement(NoAwaitTag,
                                                 std::string const& name,
                                                 Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::privilegedaccessmanager::v1::DeleteEntitlementRequest request;
  request.set_name(name);
  return connection_->DeleteEntitlement(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::privilegedaccessmanager::v1::Entitlement>>
PrivilegedAccessManagerClient::DeleteEntitlement(
    google::cloud::privilegedaccessmanager::v1::DeleteEntitlementRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteEntitlement(request);
}

StatusOr<google::longrunning::Operation>
PrivilegedAccessManagerClient::DeleteEntitlement(
    NoAwaitTag,
    google::cloud::privilegedaccessmanager::v1::DeleteEntitlementRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteEntitlement(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::privilegedaccessmanager::v1::Entitlement>>
PrivilegedAccessManagerClient::DeleteEntitlement(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteEntitlement(operation);
}

future<StatusOr<google::cloud::privilegedaccessmanager::v1::Entitlement>>
PrivilegedAccessManagerClient::UpdateEntitlement(
    google::cloud::privilegedaccessmanager::v1::Entitlement const& entitlement,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::privilegedaccessmanager::v1::UpdateEntitlementRequest request;
  *request.mutable_entitlement() = entitlement;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateEntitlement(request);
}

StatusOr<google::longrunning::Operation>
PrivilegedAccessManagerClient::UpdateEntitlement(
    NoAwaitTag,
    google::cloud::privilegedaccessmanager::v1::Entitlement const& entitlement,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::privilegedaccessmanager::v1::UpdateEntitlementRequest request;
  *request.mutable_entitlement() = entitlement;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateEntitlement(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::privilegedaccessmanager::v1::Entitlement>>
PrivilegedAccessManagerClient::UpdateEntitlement(
    google::cloud::privilegedaccessmanager::v1::UpdateEntitlementRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateEntitlement(request);
}

StatusOr<google::longrunning::Operation>
PrivilegedAccessManagerClient::UpdateEntitlement(
    NoAwaitTag,
    google::cloud::privilegedaccessmanager::v1::UpdateEntitlementRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateEntitlement(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::privilegedaccessmanager::v1::Entitlement>>
PrivilegedAccessManagerClient::UpdateEntitlement(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateEntitlement(operation);
}

StreamRange<google::cloud::privilegedaccessmanager::v1::Grant>
PrivilegedAccessManagerClient::ListGrants(std::string const& parent,
                                          Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::privilegedaccessmanager::v1::ListGrantsRequest request;
  request.set_parent(parent);
  return connection_->ListGrants(request);
}

StreamRange<google::cloud::privilegedaccessmanager::v1::Grant>
PrivilegedAccessManagerClient::ListGrants(
    google::cloud::privilegedaccessmanager::v1::ListGrantsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListGrants(std::move(request));
}

StreamRange<google::cloud::privilegedaccessmanager::v1::Grant>
PrivilegedAccessManagerClient::SearchGrants(
    google::cloud::privilegedaccessmanager::v1::SearchGrantsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SearchGrants(std::move(request));
}

StatusOr<google::cloud::privilegedaccessmanager::v1::Grant>
PrivilegedAccessManagerClient::GetGrant(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::privilegedaccessmanager::v1::GetGrantRequest request;
  request.set_name(name);
  return connection_->GetGrant(request);
}

StatusOr<google::cloud::privilegedaccessmanager::v1::Grant>
PrivilegedAccessManagerClient::GetGrant(
    google::cloud::privilegedaccessmanager::v1::GetGrantRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetGrant(request);
}

StatusOr<google::cloud::privilegedaccessmanager::v1::Grant>
PrivilegedAccessManagerClient::CreateGrant(
    std::string const& parent,
    google::cloud::privilegedaccessmanager::v1::Grant const& grant,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::privilegedaccessmanager::v1::CreateGrantRequest request;
  request.set_parent(parent);
  *request.mutable_grant() = grant;
  return connection_->CreateGrant(request);
}

StatusOr<google::cloud::privilegedaccessmanager::v1::Grant>
PrivilegedAccessManagerClient::CreateGrant(
    google::cloud::privilegedaccessmanager::v1::CreateGrantRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateGrant(request);
}

StatusOr<google::cloud::privilegedaccessmanager::v1::Grant>
PrivilegedAccessManagerClient::ApproveGrant(
    google::cloud::privilegedaccessmanager::v1::ApproveGrantRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ApproveGrant(request);
}

StatusOr<google::cloud::privilegedaccessmanager::v1::Grant>
PrivilegedAccessManagerClient::DenyGrant(
    google::cloud::privilegedaccessmanager::v1::DenyGrantRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DenyGrant(request);
}

future<StatusOr<google::cloud::privilegedaccessmanager::v1::Grant>>
PrivilegedAccessManagerClient::RevokeGrant(
    google::cloud::privilegedaccessmanager::v1::RevokeGrantRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RevokeGrant(request);
}

StatusOr<google::longrunning::Operation>
PrivilegedAccessManagerClient::RevokeGrant(
    NoAwaitTag,
    google::cloud::privilegedaccessmanager::v1::RevokeGrantRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RevokeGrant(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::privilegedaccessmanager::v1::Grant>>
PrivilegedAccessManagerClient::RevokeGrant(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RevokeGrant(operation);
}

StreamRange<google::cloud::location::Location>
PrivilegedAccessManagerClient::ListLocations(
    google::cloud::location::ListLocationsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListLocations(std::move(request));
}

StatusOr<google::cloud::location::Location>
PrivilegedAccessManagerClient::GetLocation(
    google::cloud::location::GetLocationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetLocation(request);
}

StreamRange<google::longrunning::Operation>
PrivilegedAccessManagerClient::ListOperations(std::string const& name,
                                              std::string const& filter,
                                              Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::ListOperationsRequest request;
  request.set_name(name);
  request.set_filter(filter);
  return connection_->ListOperations(request);
}

StreamRange<google::longrunning::Operation>
PrivilegedAccessManagerClient::ListOperations(
    google::longrunning::ListOperationsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListOperations(std::move(request));
}

StatusOr<google::longrunning::Operation>
PrivilegedAccessManagerClient::GetOperation(std::string const& name,
                                            Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::GetOperationRequest request;
  request.set_name(name);
  return connection_->GetOperation(request);
}

StatusOr<google::longrunning::Operation>
PrivilegedAccessManagerClient::GetOperation(
    google::longrunning::GetOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetOperation(request);
}

Status PrivilegedAccessManagerClient::DeleteOperation(std::string const& name,
                                                      Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::DeleteOperationRequest request;
  request.set_name(name);
  return connection_->DeleteOperation(request);
}

Status PrivilegedAccessManagerClient::DeleteOperation(
    google::longrunning::DeleteOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteOperation(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace privilegedaccessmanager_v1
}  // namespace cloud
}  // namespace google
