// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.proto

#include "google/cloud/privilegedaccessmanager/v1/internal/privileged_access_manager_logging_decorator.h"
#include "google/cloud/internal/log_wrapper.h"
#include "google/cloud/status_or.h"
#include <google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.grpc.pb.h>
#include <memory>
#include <set>
#include <string>
#include <utility>

namespace google {
namespace cloud {
namespace privilegedaccessmanager_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

PrivilegedAccessManagerLogging::PrivilegedAccessManagerLogging(
    std::shared_ptr<PrivilegedAccessManagerStub> child,
    TracingOptions tracing_options, std::set<std::string> const&)
    : child_(std::move(child)), tracing_options_(std::move(tracing_options)) {}

StatusOr<
    google::cloud::privilegedaccessmanager::v1::CheckOnboardingStatusResponse>
PrivilegedAccessManagerLogging::CheckOnboardingStatus(
    grpc::ClientContext& context, Options const& options,
    google::cloud::privilegedaccessmanager::v1::
        CheckOnboardingStatusRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::privilegedaccessmanager::v1::
                 CheckOnboardingStatusRequest const& request) {
        return child_->CheckOnboardingStatus(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::privilegedaccessmanager::v1::ListEntitlementsResponse>
PrivilegedAccessManagerLogging::ListEntitlements(
    grpc::ClientContext& context, Options const& options,
    google::cloud::privilegedaccessmanager::v1::ListEntitlementsRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::privilegedaccessmanager::v1::
                 ListEntitlementsRequest const& request) {
        return child_->ListEntitlements(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::privilegedaccessmanager::v1::SearchEntitlementsResponse>
PrivilegedAccessManagerLogging::SearchEntitlements(
    grpc::ClientContext& context, Options const& options,
    google::cloud::privilegedaccessmanager::v1::SearchEntitlementsRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::privilegedaccessmanager::v1::
                 SearchEntitlementsRequest const& request) {
        return child_->SearchEntitlements(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::privilegedaccessmanager::v1::Entitlement>
PrivilegedAccessManagerLogging::GetEntitlement(
    grpc::ClientContext& context, Options const& options,
    google::cloud::privilegedaccessmanager::v1::GetEntitlementRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::privilegedaccessmanager::v1::
                 GetEntitlementRequest const& request) {
        return child_->GetEntitlement(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
PrivilegedAccessManagerLogging::AsyncCreateEntitlement(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::privilegedaccessmanager::v1::CreateEntitlementRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::privilegedaccessmanager::v1::
                 CreateEntitlementRequest const& request) {
        return child_->AsyncCreateEntitlement(cq, std::move(context),
                                              std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
PrivilegedAccessManagerLogging::CreateEntitlement(
    grpc::ClientContext& context, Options options,
    google::cloud::privilegedaccessmanager::v1::CreateEntitlementRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::privilegedaccessmanager::v1::
                 CreateEntitlementRequest const& request) {
        return child_->CreateEntitlement(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
PrivilegedAccessManagerLogging::AsyncDeleteEntitlement(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::privilegedaccessmanager::v1::DeleteEntitlementRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::privilegedaccessmanager::v1::
                 DeleteEntitlementRequest const& request) {
        return child_->AsyncDeleteEntitlement(cq, std::move(context),
                                              std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
PrivilegedAccessManagerLogging::DeleteEntitlement(
    grpc::ClientContext& context, Options options,
    google::cloud::privilegedaccessmanager::v1::DeleteEntitlementRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::privilegedaccessmanager::v1::
                 DeleteEntitlementRequest const& request) {
        return child_->DeleteEntitlement(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
PrivilegedAccessManagerLogging::AsyncUpdateEntitlement(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::privilegedaccessmanager::v1::UpdateEntitlementRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::privilegedaccessmanager::v1::
                 UpdateEntitlementRequest const& request) {
        return child_->AsyncUpdateEntitlement(cq, std::move(context),
                                              std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
PrivilegedAccessManagerLogging::UpdateEntitlement(
    grpc::ClientContext& context, Options options,
    google::cloud::privilegedaccessmanager::v1::UpdateEntitlementRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::privilegedaccessmanager::v1::
                 UpdateEntitlementRequest const& request) {
        return child_->UpdateEntitlement(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::privilegedaccessmanager::v1::ListGrantsResponse>
PrivilegedAccessManagerLogging::ListGrants(
    grpc::ClientContext& context, Options const& options,
    google::cloud::privilegedaccessmanager::v1::ListGrantsRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::privilegedaccessmanager::v1::ListGrantsRequest const&
              request) {
        return child_->ListGrants(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::privilegedaccessmanager::v1::SearchGrantsResponse>
PrivilegedAccessManagerLogging::SearchGrants(
    grpc::ClientContext& context, Options const& options,
    google::cloud::privilegedaccessmanager::v1::SearchGrantsRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::privilegedaccessmanager::v1::SearchGrantsRequest const&
              request) {
        return child_->SearchGrants(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::privilegedaccessmanager::v1::Grant>
PrivilegedAccessManagerLogging::GetGrant(
    grpc::ClientContext& context, Options const& options,
    google::cloud::privilegedaccessmanager::v1::GetGrantRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::privilegedaccessmanager::v1::GetGrantRequest const&
                 request) {
        return child_->GetGrant(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::privilegedaccessmanager::v1::Grant>
PrivilegedAccessManagerLogging::CreateGrant(
    grpc::ClientContext& context, Options const& options,
    google::cloud::privilegedaccessmanager::v1::CreateGrantRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::privilegedaccessmanager::v1::CreateGrantRequest const&
              request) {
        return child_->CreateGrant(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::privilegedaccessmanager::v1::Grant>
PrivilegedAccessManagerLogging::ApproveGrant(
    grpc::ClientContext& context, Options const& options,
    google::cloud::privilegedaccessmanager::v1::ApproveGrantRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::privilegedaccessmanager::v1::ApproveGrantRequest const&
              request) {
        return child_->ApproveGrant(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::privilegedaccessmanager::v1::Grant>
PrivilegedAccessManagerLogging::DenyGrant(
    grpc::ClientContext& context, Options const& options,
    google::cloud::privilegedaccessmanager::v1::DenyGrantRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::privilegedaccessmanager::v1::DenyGrantRequest const&
                 request) {
        return child_->DenyGrant(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
PrivilegedAccessManagerLogging::AsyncRevokeGrant(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::privilegedaccessmanager::v1::RevokeGrantRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::privilegedaccessmanager::v1::RevokeGrantRequest const&
              request) {
        return child_->AsyncRevokeGrant(cq, std::move(context),
                                        std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::longrunning::Operation>
PrivilegedAccessManagerLogging::RevokeGrant(
    grpc::ClientContext& context, Options options,
    google::cloud::privilegedaccessmanager::v1::RevokeGrantRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::privilegedaccessmanager::v1::RevokeGrantRequest const&
              request) {
        return child_->RevokeGrant(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::location::ListLocationsResponse>
PrivilegedAccessManagerLogging::ListLocations(
    grpc::ClientContext& context, Options const& options,
    google::cloud::location::ListLocationsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::location::ListLocationsRequest const& request) {
        return child_->ListLocations(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::location::Location>
PrivilegedAccessManagerLogging::GetLocation(
    grpc::ClientContext& context, Options const& options,
    google::cloud::location::GetLocationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::location::GetLocationRequest const& request) {
        return child_->GetLocation(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::longrunning::ListOperationsResponse>
PrivilegedAccessManagerLogging::ListOperations(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::ListOperationsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::longrunning::ListOperationsRequest const& request) {
        return child_->ListOperations(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::longrunning::Operation>
PrivilegedAccessManagerLogging::GetOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::GetOperationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::longrunning::GetOperationRequest const& request) {
        return child_->GetOperation(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

Status PrivilegedAccessManagerLogging::DeleteOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::DeleteOperationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::longrunning::DeleteOperationRequest const& request) {
        return child_->DeleteOperation(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
PrivilegedAccessManagerLogging::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::longrunning::GetOperationRequest const& request) {
        return child_->AsyncGetOperation(cq, std::move(context),
                                         std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

future<Status> PrivilegedAccessManagerLogging::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::cloud::internal::ImmutableOptions options,
             google::longrunning::CancelOperationRequest const& request) {
        return child_->AsyncCancelOperation(cq, std::move(context),
                                            std::move(options), request);
      },
      cq, std::move(context), std::move(options), request, __func__,
      tracing_options_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace privilegedaccessmanager_v1_internal
}  // namespace cloud
}  // namespace google
