// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.proto

#include "google/cloud/privilegedaccessmanager/v1/internal/privileged_access_manager_connection_impl.h"
#include "google/cloud/privilegedaccessmanager/v1/internal/privileged_access_manager_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace privilegedaccessmanager_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<privilegedaccessmanager_v1::PrivilegedAccessManagerRetryPolicy>
retry_policy(Options const& options) {
  return options
      .get<privilegedaccessmanager_v1::
               PrivilegedAccessManagerRetryPolicyOption>()
      ->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options
      .get<privilegedaccessmanager_v1::
               PrivilegedAccessManagerBackoffPolicyOption>()
      ->clone();
}

std::unique_ptr<privilegedaccessmanager_v1::
                    PrivilegedAccessManagerConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<privilegedaccessmanager_v1::
               PrivilegedAccessManagerConnectionIdempotencyPolicyOption>()
      ->clone();
}

std::unique_ptr<PollingPolicy> polling_policy(Options const& options) {
  return options
      .get<privilegedaccessmanager_v1::
               PrivilegedAccessManagerPollingPolicyOption>()
      ->clone();
}

}  // namespace

PrivilegedAccessManagerConnectionImpl::PrivilegedAccessManagerConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<
        privilegedaccessmanager_v1_internal::PrivilegedAccessManagerStub>
        stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(
          std::move(options), PrivilegedAccessManagerConnection::options())) {}

StatusOr<
    google::cloud::privilegedaccessmanager::v1::CheckOnboardingStatusResponse>
PrivilegedAccessManagerConnectionImpl::CheckOnboardingStatus(
    google::cloud::privilegedaccessmanager::v1::
        CheckOnboardingStatusRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CheckOnboardingStatus(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::privilegedaccessmanager::v1::
                 CheckOnboardingStatusRequest const& request) {
        return stub_->CheckOnboardingStatus(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::privilegedaccessmanager::v1::Entitlement>
PrivilegedAccessManagerConnectionImpl::ListEntitlements(
    google::cloud::privilegedaccessmanager::v1::ListEntitlementsRequest
        request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListEntitlements(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::privilegedaccessmanager::v1::Entitlement>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<
           privilegedaccessmanager_v1::PrivilegedAccessManagerRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options, google::cloud::privilegedaccessmanager::v1::
                                      ListEntitlementsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::privilegedaccessmanager::v1::
                       ListEntitlementsRequest const& request) {
              return stub->ListEntitlements(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::privilegedaccessmanager::v1::ListEntitlementsResponse
             r) {
        std::vector<google::cloud::privilegedaccessmanager::v1::Entitlement>
            result(r.entitlements().size());
        auto& messages = *r.mutable_entitlements();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StreamRange<google::cloud::privilegedaccessmanager::v1::Entitlement>
PrivilegedAccessManagerConnectionImpl::SearchEntitlements(
    google::cloud::privilegedaccessmanager::v1::SearchEntitlementsRequest
        request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->SearchEntitlements(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::privilegedaccessmanager::v1::Entitlement>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<
           privilegedaccessmanager_v1::PrivilegedAccessManagerRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options, google::cloud::privilegedaccessmanager::v1::
                                      SearchEntitlementsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::privilegedaccessmanager::v1::
                       SearchEntitlementsRequest const& request) {
              return stub->SearchEntitlements(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::privilegedaccessmanager::v1::SearchEntitlementsResponse
             r) {
        std::vector<google::cloud::privilegedaccessmanager::v1::Entitlement>
            result(r.entitlements().size());
        auto& messages = *r.mutable_entitlements();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::privilegedaccessmanager::v1::Entitlement>
PrivilegedAccessManagerConnectionImpl::GetEntitlement(
    google::cloud::privilegedaccessmanager::v1::GetEntitlementRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetEntitlement(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::privilegedaccessmanager::v1::
                 GetEntitlementRequest const& request) {
        return stub_->GetEntitlement(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::privilegedaccessmanager::v1::Entitlement>>
PrivilegedAccessManagerConnectionImpl::CreateEntitlement(
    google::cloud::privilegedaccessmanager::v1::CreateEntitlementRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->CreateEntitlement(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::privilegedaccessmanager::v1::Entitlement>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::cloud::privilegedaccessmanager::v1::
                         CreateEntitlementRequest const& request) {
        return stub->AsyncCreateEntitlement(cq, std::move(context),
                                            std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::privilegedaccessmanager::v1::Entitlement>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
PrivilegedAccessManagerConnectionImpl::CreateEntitlement(
    NoAwaitTag,
    google::cloud::privilegedaccessmanager::v1::CreateEntitlementRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateEntitlement(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::privilegedaccessmanager::v1::
                 CreateEntitlementRequest const& request) {
        return stub_->CreateEntitlement(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::privilegedaccessmanager::v1::Entitlement>>
PrivilegedAccessManagerConnectionImpl::CreateEntitlement(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::privilegedaccessmanager::v1::
                   OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::privilegedaccessmanager::v1::Entitlement>>(
        internal::InvalidArgumentError(
            "operation does not correspond to CreateEntitlement",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::privilegedaccessmanager::v1::Entitlement>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::privilegedaccessmanager::v1::Entitlement>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::privilegedaccessmanager::v1::Entitlement>>
PrivilegedAccessManagerConnectionImpl::DeleteEntitlement(
    google::cloud::privilegedaccessmanager::v1::DeleteEntitlementRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->DeleteEntitlement(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::privilegedaccessmanager::v1::Entitlement>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::cloud::privilegedaccessmanager::v1::
                         DeleteEntitlementRequest const& request) {
        return stub->AsyncDeleteEntitlement(cq, std::move(context),
                                            std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::privilegedaccessmanager::v1::Entitlement>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
PrivilegedAccessManagerConnectionImpl::DeleteEntitlement(
    NoAwaitTag,
    google::cloud::privilegedaccessmanager::v1::DeleteEntitlementRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteEntitlement(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::privilegedaccessmanager::v1::
                 DeleteEntitlementRequest const& request) {
        return stub_->DeleteEntitlement(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::privilegedaccessmanager::v1::Entitlement>>
PrivilegedAccessManagerConnectionImpl::DeleteEntitlement(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::privilegedaccessmanager::v1::
                   OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::privilegedaccessmanager::v1::Entitlement>>(
        internal::InvalidArgumentError(
            "operation does not correspond to DeleteEntitlement",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::privilegedaccessmanager::v1::Entitlement>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::privilegedaccessmanager::v1::Entitlement>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::privilegedaccessmanager::v1::Entitlement>>
PrivilegedAccessManagerConnectionImpl::UpdateEntitlement(
    google::cloud::privilegedaccessmanager::v1::UpdateEntitlementRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->UpdateEntitlement(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::privilegedaccessmanager::v1::Entitlement>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::cloud::privilegedaccessmanager::v1::
                         UpdateEntitlementRequest const& request) {
        return stub->AsyncUpdateEntitlement(cq, std::move(context),
                                            std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::privilegedaccessmanager::v1::Entitlement>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
PrivilegedAccessManagerConnectionImpl::UpdateEntitlement(
    NoAwaitTag,
    google::cloud::privilegedaccessmanager::v1::UpdateEntitlementRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateEntitlement(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::privilegedaccessmanager::v1::
                 UpdateEntitlementRequest const& request) {
        return stub_->UpdateEntitlement(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::privilegedaccessmanager::v1::Entitlement>>
PrivilegedAccessManagerConnectionImpl::UpdateEntitlement(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::privilegedaccessmanager::v1::
                   OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::privilegedaccessmanager::v1::Entitlement>>(
        internal::InvalidArgumentError(
            "operation does not correspond to UpdateEntitlement",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::privilegedaccessmanager::v1::Entitlement>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::privilegedaccessmanager::v1::Entitlement>,
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::privilegedaccessmanager::v1::Grant>
PrivilegedAccessManagerConnectionImpl::ListGrants(
    google::cloud::privilegedaccessmanager::v1::ListGrantsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListGrants(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::privilegedaccessmanager::v1::Grant>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<
           privilegedaccessmanager_v1::PrivilegedAccessManagerRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::privilegedaccessmanager::v1::ListGrantsRequest const&
              r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::privilegedaccessmanager::v1::
                       ListGrantsRequest const& request) {
              return stub->ListGrants(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::privilegedaccessmanager::v1::ListGrantsResponse r) {
        std::vector<google::cloud::privilegedaccessmanager::v1::Grant> result(
            r.grants().size());
        auto& messages = *r.mutable_grants();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StreamRange<google::cloud::privilegedaccessmanager::v1::Grant>
PrivilegedAccessManagerConnectionImpl::SearchGrants(
    google::cloud::privilegedaccessmanager::v1::SearchGrantsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->SearchGrants(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::privilegedaccessmanager::v1::Grant>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<
           privilegedaccessmanager_v1::PrivilegedAccessManagerRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::privilegedaccessmanager::v1::SearchGrantsRequest const&
              r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::privilegedaccessmanager::v1::
                       SearchGrantsRequest const& request) {
              return stub->SearchGrants(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::privilegedaccessmanager::v1::SearchGrantsResponse r) {
        std::vector<google::cloud::privilegedaccessmanager::v1::Grant> result(
            r.grants().size());
        auto& messages = *r.mutable_grants();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::privilegedaccessmanager::v1::Grant>
PrivilegedAccessManagerConnectionImpl::GetGrant(
    google::cloud::privilegedaccessmanager::v1::GetGrantRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetGrant(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::privilegedaccessmanager::v1::GetGrantRequest const&
                 request) {
        return stub_->GetGrant(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::privilegedaccessmanager::v1::Grant>
PrivilegedAccessManagerConnectionImpl::CreateGrant(
    google::cloud::privilegedaccessmanager::v1::CreateGrantRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateGrant(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::privilegedaccessmanager::v1::CreateGrantRequest const&
              request) {
        return stub_->CreateGrant(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::privilegedaccessmanager::v1::Grant>
PrivilegedAccessManagerConnectionImpl::ApproveGrant(
    google::cloud::privilegedaccessmanager::v1::ApproveGrantRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->ApproveGrant(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::privilegedaccessmanager::v1::ApproveGrantRequest const&
              request) {
        return stub_->ApproveGrant(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::privilegedaccessmanager::v1::Grant>
PrivilegedAccessManagerConnectionImpl::DenyGrant(
    google::cloud::privilegedaccessmanager::v1::DenyGrantRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DenyGrant(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::privilegedaccessmanager::v1::DenyGrantRequest const&
                 request) {
        return stub_->DenyGrant(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::privilegedaccessmanager::v1::Grant>>
PrivilegedAccessManagerConnectionImpl::RevokeGrant(
    google::cloud::privilegedaccessmanager::v1::RevokeGrantRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->RevokeGrant(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::privilegedaccessmanager::v1::Grant>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::privilegedaccessmanager::v1::RevokeGrantRequest const&
              request) {
        return stub->AsyncRevokeGrant(cq, std::move(context),
                                      std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::privilegedaccessmanager::v1::Grant>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
PrivilegedAccessManagerConnectionImpl::RevokeGrant(
    NoAwaitTag,
    google::cloud::privilegedaccessmanager::v1::RevokeGrantRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->RevokeGrant(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::privilegedaccessmanager::v1::RevokeGrantRequest const&
              request) {
        return stub_->RevokeGrant(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::privilegedaccessmanager::v1::Grant>>
PrivilegedAccessManagerConnectionImpl::RevokeGrant(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::privilegedaccessmanager::v1::
                   OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::privilegedaccessmanager::v1::Grant>>(
        internal::InvalidArgumentError(
            "operation does not correspond to RevokeGrant",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::privilegedaccessmanager::v1::Grant>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::privilegedaccessmanager::v1::Grant>,
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::location::Location>
PrivilegedAccessManagerConnectionImpl::ListLocations(
    google::cloud::location::ListLocationsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListLocations(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::location::Location>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<
           privilegedaccessmanager_v1::PrivilegedAccessManagerRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::location::ListLocationsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context, Options const& options,
                google::cloud::location::ListLocationsRequest const& request) {
              return stub->ListLocations(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::location::ListLocationsResponse r) {
        std::vector<google::cloud::location::Location> result(
            r.locations().size());
        auto& messages = *r.mutable_locations();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::location::Location>
PrivilegedAccessManagerConnectionImpl::GetLocation(
    google::cloud::location::GetLocationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetLocation(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::location::GetLocationRequest const& request) {
        return stub_->GetLocation(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::longrunning::Operation>
PrivilegedAccessManagerConnectionImpl::ListOperations(
    google::longrunning::ListOperationsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListOperations(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::longrunning::Operation>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<
           privilegedaccessmanager_v1::PrivilegedAccessManagerRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::longrunning::ListOperationsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::longrunning::ListOperationsRequest const& request) {
              return stub->ListOperations(context, options, request);
            },
            options, r, function_name);
      },
      [](google::longrunning::ListOperationsResponse r) {
        std::vector<google::longrunning::Operation> result(
            r.operations().size());
        auto& messages = *r.mutable_operations();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::longrunning::Operation>
PrivilegedAccessManagerConnectionImpl::GetOperation(
    google::longrunning::GetOperationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetOperation(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::longrunning::GetOperationRequest const& request) {
        return stub_->GetOperation(context, options, request);
      },
      *current, request, __func__);
}

Status PrivilegedAccessManagerConnectionImpl::DeleteOperation(
    google::longrunning::DeleteOperationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteOperation(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::longrunning::DeleteOperationRequest const& request) {
        return stub_->DeleteOperation(context, options, request);
      },
      *current, request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace privilegedaccessmanager_v1_internal
}  // namespace cloud
}  // namespace google
