// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/policysimulator/v1/simulator.proto

#include "google/cloud/policysimulator/v1/simulator_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace policysimulator_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

SimulatorClient::SimulatorClient(
    std::shared_ptr<SimulatorConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
SimulatorClient::~SimulatorClient() = default;

StatusOr<google::cloud::policysimulator::v1::Replay> SimulatorClient::GetReplay(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::policysimulator::v1::GetReplayRequest request;
  request.set_name(name);
  return connection_->GetReplay(request);
}

StatusOr<google::cloud::policysimulator::v1::Replay> SimulatorClient::GetReplay(
    google::cloud::policysimulator::v1::GetReplayRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetReplay(request);
}

future<StatusOr<google::cloud::policysimulator::v1::Replay>>
SimulatorClient::CreateReplay(
    std::string const& parent,
    google::cloud::policysimulator::v1::Replay const& replay, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::policysimulator::v1::CreateReplayRequest request;
  request.set_parent(parent);
  *request.mutable_replay() = replay;
  return connection_->CreateReplay(request);
}

StatusOr<google::longrunning::Operation> SimulatorClient::CreateReplay(
    NoAwaitTag, std::string const& parent,
    google::cloud::policysimulator::v1::Replay const& replay, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::policysimulator::v1::CreateReplayRequest request;
  request.set_parent(parent);
  *request.mutable_replay() = replay;
  return connection_->CreateReplay(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::policysimulator::v1::Replay>>
SimulatorClient::CreateReplay(
    google::cloud::policysimulator::v1::CreateReplayRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateReplay(request);
}

StatusOr<google::longrunning::Operation> SimulatorClient::CreateReplay(
    NoAwaitTag,
    google::cloud::policysimulator::v1::CreateReplayRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateReplay(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::policysimulator::v1::Replay>>
SimulatorClient::CreateReplay(google::longrunning::Operation const& operation,
                              Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateReplay(operation);
}

StreamRange<google::cloud::policysimulator::v1::ReplayResult>
SimulatorClient::ListReplayResults(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::policysimulator::v1::ListReplayResultsRequest request;
  request.set_parent(parent);
  return connection_->ListReplayResults(request);
}

StreamRange<google::cloud::policysimulator::v1::ReplayResult>
SimulatorClient::ListReplayResults(
    google::cloud::policysimulator::v1::ListReplayResultsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListReplayResults(std::move(request));
}

StreamRange<google::longrunning::Operation> SimulatorClient::ListOperations(
    std::string const& name, std::string const& filter, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::ListOperationsRequest request;
  request.set_name(name);
  request.set_filter(filter);
  return connection_->ListOperations(request);
}

StreamRange<google::longrunning::Operation> SimulatorClient::ListOperations(
    google::longrunning::ListOperationsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListOperations(std::move(request));
}

StatusOr<google::longrunning::Operation> SimulatorClient::GetOperation(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::GetOperationRequest request;
  request.set_name(name);
  return connection_->GetOperation(request);
}

StatusOr<google::longrunning::Operation> SimulatorClient::GetOperation(
    google::longrunning::GetOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetOperation(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace policysimulator_v1
}  // namespace cloud
}  // namespace google
