// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/parallelstore/v1/parallelstore.proto

#include "google/cloud/parallelstore/v1/parallelstore_connection.h"
#include "google/cloud/parallelstore/v1/internal/parallelstore_connection_impl.h"
#include "google/cloud/parallelstore/v1/internal/parallelstore_option_defaults.h"
#include "google/cloud/parallelstore/v1/internal/parallelstore_stub_factory.h"
#include "google/cloud/parallelstore/v1/internal/parallelstore_tracing_connection.h"
#include "google/cloud/parallelstore/v1/parallelstore_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace parallelstore_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ParallelstoreConnection::~ParallelstoreConnection() = default;

StreamRange<google::cloud::parallelstore::v1::Instance>
ParallelstoreConnection::ListInstances(
    google::cloud::parallelstore::v1::
        ListInstancesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::parallelstore::v1::Instance>>();
}

StatusOr<google::cloud::parallelstore::v1::Instance>
ParallelstoreConnection::GetInstance(
    google::cloud::parallelstore::v1::GetInstanceRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::parallelstore::v1::Instance>>
ParallelstoreConnection::CreateInstance(
    google::cloud::parallelstore::v1::CreateInstanceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::parallelstore::v1::Instance>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
ParallelstoreConnection::CreateInstance(
    NoAwaitTag,
    google::cloud::parallelstore::v1::CreateInstanceRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::parallelstore::v1::Instance>>
ParallelstoreConnection::CreateInstance(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::parallelstore::v1::Instance>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::parallelstore::v1::Instance>>
ParallelstoreConnection::UpdateInstance(
    google::cloud::parallelstore::v1::UpdateInstanceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::parallelstore::v1::Instance>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
ParallelstoreConnection::UpdateInstance(
    NoAwaitTag,
    google::cloud::parallelstore::v1::UpdateInstanceRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::parallelstore::v1::Instance>>
ParallelstoreConnection::UpdateInstance(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::parallelstore::v1::Instance>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::parallelstore::v1::OperationMetadata>>
ParallelstoreConnection::DeleteInstance(
    google::cloud::parallelstore::v1::DeleteInstanceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::parallelstore::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
ParallelstoreConnection::DeleteInstance(
    NoAwaitTag,
    google::cloud::parallelstore::v1::DeleteInstanceRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::parallelstore::v1::OperationMetadata>>
ParallelstoreConnection::DeleteInstance(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::parallelstore::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::parallelstore::v1::ImportDataResponse>>
ParallelstoreConnection::ImportData(
    google::cloud::parallelstore::v1::ImportDataRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::parallelstore::v1::ImportDataResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> ParallelstoreConnection::ImportData(
    NoAwaitTag, google::cloud::parallelstore::v1::ImportDataRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::parallelstore::v1::ImportDataResponse>>
ParallelstoreConnection::ImportData(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::parallelstore::v1::ImportDataResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::parallelstore::v1::ExportDataResponse>>
ParallelstoreConnection::ExportData(
    google::cloud::parallelstore::v1::ExportDataRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::parallelstore::v1::ExportDataResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> ParallelstoreConnection::ExportData(
    NoAwaitTag, google::cloud::parallelstore::v1::ExportDataRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::parallelstore::v1::ExportDataResponse>>
ParallelstoreConnection::ExportData(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::parallelstore::v1::ExportDataResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::location::Location>
ParallelstoreConnection::ListLocations(
    google::cloud::location::
        ListLocationsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::location::Location>>();
}

StatusOr<google::cloud::location::Location>
ParallelstoreConnection::GetLocation(
    google::cloud::location::GetLocationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::longrunning::Operation>
ParallelstoreConnection::ListOperations(
    google::longrunning::
        ListOperationsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::longrunning::Operation>>();
}

StatusOr<google::longrunning::Operation> ParallelstoreConnection::GetOperation(
    google::longrunning::GetOperationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status ParallelstoreConnection::DeleteOperation(
    google::longrunning::DeleteOperationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status ParallelstoreConnection::CancelOperation(
    google::longrunning::CancelOperationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<ParallelstoreConnection> MakeParallelstoreConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 ParallelstorePolicyOptionList>(options,
                                                                __func__);
  options = parallelstore_v1_internal::ParallelstoreDefaultOptions(
      std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = parallelstore_v1_internal::CreateDefaultParallelstoreStub(
      std::move(auth), options);
  return parallelstore_v1_internal::MakeParallelstoreTracingConnection(
      std::make_shared<parallelstore_v1_internal::ParallelstoreConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace parallelstore_v1
}  // namespace cloud
}  // namespace google
