// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/parallelstore/v1/parallelstore.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_PARALLELSTORE_V1_INTERNAL_PARALLELSTORE_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_PARALLELSTORE_V1_INTERNAL_PARALLELSTORE_TRACING_CONNECTION_H

#include "google/cloud/parallelstore/v1/parallelstore_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace parallelstore_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class ParallelstoreTracingConnection
    : public parallelstore_v1::ParallelstoreConnection {
 public:
  ~ParallelstoreTracingConnection() override = default;

  explicit ParallelstoreTracingConnection(
      std::shared_ptr<parallelstore_v1::ParallelstoreConnection> child);

  Options options() override { return child_->options(); }

  StreamRange<google::cloud::parallelstore::v1::Instance> ListInstances(
      google::cloud::parallelstore::v1::ListInstancesRequest request) override;

  StatusOr<google::cloud::parallelstore::v1::Instance> GetInstance(
      google::cloud::parallelstore::v1::GetInstanceRequest const& request)
      override;

  future<StatusOr<google::cloud::parallelstore::v1::Instance>> CreateInstance(
      google::cloud::parallelstore::v1::CreateInstanceRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> CreateInstance(
      NoAwaitTag,
      google::cloud::parallelstore::v1::CreateInstanceRequest const& request)
      override;

  future<StatusOr<google::cloud::parallelstore::v1::Instance>> CreateInstance(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::parallelstore::v1::Instance>> UpdateInstance(
      google::cloud::parallelstore::v1::UpdateInstanceRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> UpdateInstance(
      NoAwaitTag,
      google::cloud::parallelstore::v1::UpdateInstanceRequest const& request)
      override;

  future<StatusOr<google::cloud::parallelstore::v1::Instance>> UpdateInstance(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::parallelstore::v1::OperationMetadata>>
  DeleteInstance(google::cloud::parallelstore::v1::DeleteInstanceRequest const&
                     request) override;

  StatusOr<google::longrunning::Operation> DeleteInstance(
      NoAwaitTag,
      google::cloud::parallelstore::v1::DeleteInstanceRequest const& request)
      override;

  future<StatusOr<google::cloud::parallelstore::v1::OperationMetadata>>
  DeleteInstance(google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::parallelstore::v1::ImportDataResponse>>
  ImportData(google::cloud::parallelstore::v1::ImportDataRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> ImportData(
      NoAwaitTag,
      google::cloud::parallelstore::v1::ImportDataRequest const& request)
      override;

  future<StatusOr<google::cloud::parallelstore::v1::ImportDataResponse>>
  ImportData(google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::parallelstore::v1::ExportDataResponse>>
  ExportData(google::cloud::parallelstore::v1::ExportDataRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> ExportData(
      NoAwaitTag,
      google::cloud::parallelstore::v1::ExportDataRequest const& request)
      override;

  future<StatusOr<google::cloud::parallelstore::v1::ExportDataResponse>>
  ExportData(google::longrunning::Operation const& operation) override;

  StreamRange<google::cloud::location::Location> ListLocations(
      google::cloud::location::ListLocationsRequest request) override;

  StatusOr<google::cloud::location::Location> GetLocation(
      google::cloud::location::GetLocationRequest const& request) override;

  StreamRange<google::longrunning::Operation> ListOperations(
      google::longrunning::ListOperationsRequest request) override;

  StatusOr<google::longrunning::Operation> GetOperation(
      google::longrunning::GetOperationRequest const& request) override;

  Status DeleteOperation(
      google::longrunning::DeleteOperationRequest const& request) override;

  Status CancelOperation(
      google::longrunning::CancelOperationRequest const& request) override;

 private:
  std::shared_ptr<parallelstore_v1::ParallelstoreConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<parallelstore_v1::ParallelstoreConnection>
MakeParallelstoreTracingConnection(
    std::shared_ptr<parallelstore_v1::ParallelstoreConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace parallelstore_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_PARALLELSTORE_V1_INTERNAL_PARALLELSTORE_TRACING_CONNECTION_H
