// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/parallelstore/v1/parallelstore.proto

#include "google/cloud/parallelstore/v1/internal/parallelstore_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace parallelstore_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

ParallelstoreTracingConnection::ParallelstoreTracingConnection(
    std::shared_ptr<parallelstore_v1::ParallelstoreConnection> child)
    : child_(std::move(child)) {}

StreamRange<google::cloud::parallelstore::v1::Instance>
ParallelstoreTracingConnection::ListInstances(
    google::cloud::parallelstore::v1::ListInstancesRequest request) {
  auto span = internal::MakeSpan(
      "parallelstore_v1::ParallelstoreConnection::ListInstances");
  internal::OTelScope scope(span);
  auto sr = child_->ListInstances(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::parallelstore::v1::Instance>(std::move(span),
                                                  std::move(sr));
}

StatusOr<google::cloud::parallelstore::v1::Instance>
ParallelstoreTracingConnection::GetInstance(
    google::cloud::parallelstore::v1::GetInstanceRequest const& request) {
  auto span = internal::MakeSpan(
      "parallelstore_v1::ParallelstoreConnection::GetInstance");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetInstance(request));
}

future<StatusOr<google::cloud::parallelstore::v1::Instance>>
ParallelstoreTracingConnection::CreateInstance(
    google::cloud::parallelstore::v1::CreateInstanceRequest const& request) {
  auto span = internal::MakeSpan(
      "parallelstore_v1::ParallelstoreConnection::CreateInstance");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateInstance(request));
}

StatusOr<google::longrunning::Operation>
ParallelstoreTracingConnection::CreateInstance(
    NoAwaitTag,
    google::cloud::parallelstore::v1::CreateInstanceRequest const& request) {
  auto span = internal::MakeSpan(
      "parallelstore_v1::ParallelstoreConnection::CreateInstance");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->CreateInstance(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::parallelstore::v1::Instance>>
ParallelstoreTracingConnection::CreateInstance(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "parallelstore_v1::ParallelstoreConnection::CreateInstance");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateInstance(operation));
}

future<StatusOr<google::cloud::parallelstore::v1::Instance>>
ParallelstoreTracingConnection::UpdateInstance(
    google::cloud::parallelstore::v1::UpdateInstanceRequest const& request) {
  auto span = internal::MakeSpan(
      "parallelstore_v1::ParallelstoreConnection::UpdateInstance");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateInstance(request));
}

StatusOr<google::longrunning::Operation>
ParallelstoreTracingConnection::UpdateInstance(
    NoAwaitTag,
    google::cloud::parallelstore::v1::UpdateInstanceRequest const& request) {
  auto span = internal::MakeSpan(
      "parallelstore_v1::ParallelstoreConnection::UpdateInstance");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->UpdateInstance(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::parallelstore::v1::Instance>>
ParallelstoreTracingConnection::UpdateInstance(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "parallelstore_v1::ParallelstoreConnection::UpdateInstance");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateInstance(operation));
}

future<StatusOr<google::cloud::parallelstore::v1::OperationMetadata>>
ParallelstoreTracingConnection::DeleteInstance(
    google::cloud::parallelstore::v1::DeleteInstanceRequest const& request) {
  auto span = internal::MakeSpan(
      "parallelstore_v1::ParallelstoreConnection::DeleteInstance");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteInstance(request));
}

StatusOr<google::longrunning::Operation>
ParallelstoreTracingConnection::DeleteInstance(
    NoAwaitTag,
    google::cloud::parallelstore::v1::DeleteInstanceRequest const& request) {
  auto span = internal::MakeSpan(
      "parallelstore_v1::ParallelstoreConnection::DeleteInstance");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->DeleteInstance(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::parallelstore::v1::OperationMetadata>>
ParallelstoreTracingConnection::DeleteInstance(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "parallelstore_v1::ParallelstoreConnection::DeleteInstance");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteInstance(operation));
}

future<StatusOr<google::cloud::parallelstore::v1::ImportDataResponse>>
ParallelstoreTracingConnection::ImportData(
    google::cloud::parallelstore::v1::ImportDataRequest const& request) {
  auto span = internal::MakeSpan(
      "parallelstore_v1::ParallelstoreConnection::ImportData");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->ImportData(request));
}

StatusOr<google::longrunning::Operation>
ParallelstoreTracingConnection::ImportData(
    NoAwaitTag,
    google::cloud::parallelstore::v1::ImportDataRequest const& request) {
  auto span = internal::MakeSpan(
      "parallelstore_v1::ParallelstoreConnection::ImportData");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->ImportData(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::parallelstore::v1::ImportDataResponse>>
ParallelstoreTracingConnection::ImportData(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "parallelstore_v1::ParallelstoreConnection::ImportData");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->ImportData(operation));
}

future<StatusOr<google::cloud::parallelstore::v1::ExportDataResponse>>
ParallelstoreTracingConnection::ExportData(
    google::cloud::parallelstore::v1::ExportDataRequest const& request) {
  auto span = internal::MakeSpan(
      "parallelstore_v1::ParallelstoreConnection::ExportData");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->ExportData(request));
}

StatusOr<google::longrunning::Operation>
ParallelstoreTracingConnection::ExportData(
    NoAwaitTag,
    google::cloud::parallelstore::v1::ExportDataRequest const& request) {
  auto span = internal::MakeSpan(
      "parallelstore_v1::ParallelstoreConnection::ExportData");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->ExportData(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::parallelstore::v1::ExportDataResponse>>
ParallelstoreTracingConnection::ExportData(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "parallelstore_v1::ParallelstoreConnection::ExportData");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->ExportData(operation));
}

StreamRange<google::cloud::location::Location>
ParallelstoreTracingConnection::ListLocations(
    google::cloud::location::ListLocationsRequest request) {
  auto span = internal::MakeSpan(
      "parallelstore_v1::ParallelstoreConnection::ListLocations");
  internal::OTelScope scope(span);
  auto sr = child_->ListLocations(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::location::Location>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::location::Location>
ParallelstoreTracingConnection::GetLocation(
    google::cloud::location::GetLocationRequest const& request) {
  auto span = internal::MakeSpan(
      "parallelstore_v1::ParallelstoreConnection::GetLocation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetLocation(request));
}

StreamRange<google::longrunning::Operation>
ParallelstoreTracingConnection::ListOperations(
    google::longrunning::ListOperationsRequest request) {
  auto span = internal::MakeSpan(
      "parallelstore_v1::ParallelstoreConnection::ListOperations");
  internal::OTelScope scope(span);
  auto sr = child_->ListOperations(std::move(request));
  return internal::MakeTracedStreamRange<google::longrunning::Operation>(
      std::move(span), std::move(sr));
}

StatusOr<google::longrunning::Operation>
ParallelstoreTracingConnection::GetOperation(
    google::longrunning::GetOperationRequest const& request) {
  auto span = internal::MakeSpan(
      "parallelstore_v1::ParallelstoreConnection::GetOperation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetOperation(request));
}

Status ParallelstoreTracingConnection::DeleteOperation(
    google::longrunning::DeleteOperationRequest const& request) {
  auto span = internal::MakeSpan(
      "parallelstore_v1::ParallelstoreConnection::DeleteOperation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteOperation(request));
}

Status ParallelstoreTracingConnection::CancelOperation(
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpan(
      "parallelstore_v1::ParallelstoreConnection::CancelOperation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CancelOperation(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<parallelstore_v1::ParallelstoreConnection>
MakeParallelstoreTracingConnection(
    std::shared_ptr<parallelstore_v1::ParallelstoreConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<ParallelstoreTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace parallelstore_v1_internal
}  // namespace cloud
}  // namespace google
