// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/optimization/v1/fleet_routing.proto

#include "google/cloud/optimization/v1/fleet_routing_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace optimization_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

FleetRoutingConnectionIdempotencyPolicy::
    ~FleetRoutingConnectionIdempotencyPolicy() = default;

std::unique_ptr<FleetRoutingConnectionIdempotencyPolicy>
FleetRoutingConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<FleetRoutingConnectionIdempotencyPolicy>(*this);
}

Idempotency FleetRoutingConnectionIdempotencyPolicy::OptimizeTours(
    google::cloud::optimization::v1::OptimizeToursRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency FleetRoutingConnectionIdempotencyPolicy::BatchOptimizeTours(
    google::cloud::optimization::v1::BatchOptimizeToursRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency FleetRoutingConnectionIdempotencyPolicy::GetOperation(
    google::longrunning::GetOperationRequest const&) {
  return Idempotency::kIdempotent;
}

std::unique_ptr<FleetRoutingConnectionIdempotencyPolicy>
MakeDefaultFleetRoutingConnectionIdempotencyPolicy() {
  return std::make_unique<FleetRoutingConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace optimization_v1
}  // namespace cloud
}  // namespace google
