// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/notebooks/v1/service.proto

#include "google/cloud/notebooks/v1/notebook_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace notebooks_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

NotebookServiceClient::NotebookServiceClient(
    std::shared_ptr<NotebookServiceConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
NotebookServiceClient::~NotebookServiceClient() = default;

StreamRange<google::cloud::notebooks::v1::Instance>
NotebookServiceClient::ListInstances(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::notebooks::v1::ListInstancesRequest request;
  request.set_parent(parent);
  return connection_->ListInstances(request);
}

StreamRange<google::cloud::notebooks::v1::Instance>
NotebookServiceClient::ListInstances(
    google::cloud::notebooks::v1::ListInstancesRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListInstances(std::move(request));
}

StatusOr<google::cloud::notebooks::v1::Instance>
NotebookServiceClient::GetInstance(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::notebooks::v1::GetInstanceRequest request;
  request.set_name(name);
  return connection_->GetInstance(request);
}

StatusOr<google::cloud::notebooks::v1::Instance>
NotebookServiceClient::GetInstance(
    google::cloud::notebooks::v1::GetInstanceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetInstance(request);
}

future<StatusOr<google::cloud::notebooks::v1::Instance>>
NotebookServiceClient::CreateInstance(
    std::string const& parent,
    google::cloud::notebooks::v1::Instance const& instance,
    std::string const& instance_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::notebooks::v1::CreateInstanceRequest request;
  request.set_parent(parent);
  *request.mutable_instance() = instance;
  request.set_instance_id(instance_id);
  return connection_->CreateInstance(request);
}

StatusOr<google::longrunning::Operation> NotebookServiceClient::CreateInstance(
    NoAwaitTag, std::string const& parent,
    google::cloud::notebooks::v1::Instance const& instance,
    std::string const& instance_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::notebooks::v1::CreateInstanceRequest request;
  request.set_parent(parent);
  *request.mutable_instance() = instance;
  request.set_instance_id(instance_id);
  return connection_->CreateInstance(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::notebooks::v1::Instance>>
NotebookServiceClient::CreateInstance(
    google::cloud::notebooks::v1::CreateInstanceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateInstance(request);
}

StatusOr<google::longrunning::Operation> NotebookServiceClient::CreateInstance(
    NoAwaitTag,
    google::cloud::notebooks::v1::CreateInstanceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateInstance(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::notebooks::v1::Instance>>
NotebookServiceClient::CreateInstance(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateInstance(operation);
}

future<StatusOr<google::cloud::notebooks::v1::Instance>>
NotebookServiceClient::RegisterInstance(
    google::cloud::notebooks::v1::RegisterInstanceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RegisterInstance(request);
}

StatusOr<google::longrunning::Operation>
NotebookServiceClient::RegisterInstance(
    NoAwaitTag,
    google::cloud::notebooks::v1::RegisterInstanceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RegisterInstance(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::notebooks::v1::Instance>>
NotebookServiceClient::RegisterInstance(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RegisterInstance(operation);
}

future<StatusOr<google::cloud::notebooks::v1::Instance>>
NotebookServiceClient::SetInstanceAccelerator(
    google::cloud::notebooks::v1::SetInstanceAcceleratorRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetInstanceAccelerator(request);
}

StatusOr<google::longrunning::Operation>
NotebookServiceClient::SetInstanceAccelerator(
    NoAwaitTag,
    google::cloud::notebooks::v1::SetInstanceAcceleratorRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetInstanceAccelerator(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::notebooks::v1::Instance>>
NotebookServiceClient::SetInstanceAccelerator(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetInstanceAccelerator(operation);
}

future<StatusOr<google::cloud::notebooks::v1::Instance>>
NotebookServiceClient::SetInstanceMachineType(
    google::cloud::notebooks::v1::SetInstanceMachineTypeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetInstanceMachineType(request);
}

StatusOr<google::longrunning::Operation>
NotebookServiceClient::SetInstanceMachineType(
    NoAwaitTag,
    google::cloud::notebooks::v1::SetInstanceMachineTypeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetInstanceMachineType(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::notebooks::v1::Instance>>
NotebookServiceClient::SetInstanceMachineType(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetInstanceMachineType(operation);
}

future<StatusOr<google::cloud::notebooks::v1::Instance>>
NotebookServiceClient::UpdateInstanceConfig(
    google::cloud::notebooks::v1::UpdateInstanceConfigRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateInstanceConfig(request);
}

StatusOr<google::longrunning::Operation>
NotebookServiceClient::UpdateInstanceConfig(
    NoAwaitTag,
    google::cloud::notebooks::v1::UpdateInstanceConfigRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateInstanceConfig(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::notebooks::v1::Instance>>
NotebookServiceClient::UpdateInstanceConfig(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateInstanceConfig(operation);
}

future<StatusOr<google::cloud::notebooks::v1::Instance>>
NotebookServiceClient::UpdateShieldedInstanceConfig(
    google::cloud::notebooks::v1::UpdateShieldedInstanceConfigRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateShieldedInstanceConfig(request);
}

StatusOr<google::longrunning::Operation>
NotebookServiceClient::UpdateShieldedInstanceConfig(
    NoAwaitTag,
    google::cloud::notebooks::v1::UpdateShieldedInstanceConfigRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateShieldedInstanceConfig(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::notebooks::v1::Instance>>
NotebookServiceClient::UpdateShieldedInstanceConfig(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateShieldedInstanceConfig(operation);
}

future<StatusOr<google::cloud::notebooks::v1::Instance>>
NotebookServiceClient::SetInstanceLabels(
    google::cloud::notebooks::v1::SetInstanceLabelsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetInstanceLabels(request);
}

StatusOr<google::longrunning::Operation>
NotebookServiceClient::SetInstanceLabels(
    NoAwaitTag,
    google::cloud::notebooks::v1::SetInstanceLabelsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetInstanceLabels(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::notebooks::v1::Instance>>
NotebookServiceClient::SetInstanceLabels(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetInstanceLabels(operation);
}

StatusOr<google::cloud::notebooks::v1::UpdateInstanceMetadataItemsResponse>
NotebookServiceClient::UpdateInstanceMetadataItems(
    google::cloud::notebooks::v1::UpdateInstanceMetadataItemsRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateInstanceMetadataItems(request);
}

future<StatusOr<google::cloud::notebooks::v1::OperationMetadata>>
NotebookServiceClient::DeleteInstance(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::notebooks::v1::DeleteInstanceRequest request;
  request.set_name(name);
  return connection_->DeleteInstance(request);
}

StatusOr<google::longrunning::Operation> NotebookServiceClient::DeleteInstance(
    NoAwaitTag, std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::notebooks::v1::DeleteInstanceRequest request;
  request.set_name(name);
  return connection_->DeleteInstance(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::notebooks::v1::OperationMetadata>>
NotebookServiceClient::DeleteInstance(
    google::cloud::notebooks::v1::DeleteInstanceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteInstance(request);
}

StatusOr<google::longrunning::Operation> NotebookServiceClient::DeleteInstance(
    NoAwaitTag,
    google::cloud::notebooks::v1::DeleteInstanceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteInstance(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::notebooks::v1::OperationMetadata>>
NotebookServiceClient::DeleteInstance(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteInstance(operation);
}

future<StatusOr<google::cloud::notebooks::v1::Instance>>
NotebookServiceClient::StartInstance(
    google::cloud::notebooks::v1::StartInstanceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->StartInstance(request);
}

StatusOr<google::longrunning::Operation> NotebookServiceClient::StartInstance(
    NoAwaitTag,
    google::cloud::notebooks::v1::StartInstanceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->StartInstance(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::notebooks::v1::Instance>>
NotebookServiceClient::StartInstance(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->StartInstance(operation);
}

future<StatusOr<google::cloud::notebooks::v1::Instance>>
NotebookServiceClient::StopInstance(
    google::cloud::notebooks::v1::StopInstanceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->StopInstance(request);
}

StatusOr<google::longrunning::Operation> NotebookServiceClient::StopInstance(
    NoAwaitTag,
    google::cloud::notebooks::v1::StopInstanceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->StopInstance(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::notebooks::v1::Instance>>
NotebookServiceClient::StopInstance(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->StopInstance(operation);
}

future<StatusOr<google::cloud::notebooks::v1::Instance>>
NotebookServiceClient::ResetInstance(
    google::cloud::notebooks::v1::ResetInstanceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ResetInstance(request);
}

StatusOr<google::longrunning::Operation> NotebookServiceClient::ResetInstance(
    NoAwaitTag,
    google::cloud::notebooks::v1::ResetInstanceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ResetInstance(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::notebooks::v1::Instance>>
NotebookServiceClient::ResetInstance(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ResetInstance(operation);
}

future<StatusOr<google::cloud::notebooks::v1::Instance>>
NotebookServiceClient::ReportInstanceInfo(
    google::cloud::notebooks::v1::ReportInstanceInfoRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ReportInstanceInfo(request);
}

StatusOr<google::longrunning::Operation>
NotebookServiceClient::ReportInstanceInfo(
    NoAwaitTag,
    google::cloud::notebooks::v1::ReportInstanceInfoRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ReportInstanceInfo(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::notebooks::v1::Instance>>
NotebookServiceClient::ReportInstanceInfo(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ReportInstanceInfo(operation);
}

StatusOr<google::cloud::notebooks::v1::IsInstanceUpgradeableResponse>
NotebookServiceClient::IsInstanceUpgradeable(
    google::cloud::notebooks::v1::IsInstanceUpgradeableRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->IsInstanceUpgradeable(request);
}

StatusOr<google::cloud::notebooks::v1::GetInstanceHealthResponse>
NotebookServiceClient::GetInstanceHealth(std::string const& name,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::notebooks::v1::GetInstanceHealthRequest request;
  request.set_name(name);
  return connection_->GetInstanceHealth(request);
}

StatusOr<google::cloud::notebooks::v1::GetInstanceHealthResponse>
NotebookServiceClient::GetInstanceHealth(
    google::cloud::notebooks::v1::GetInstanceHealthRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetInstanceHealth(request);
}

future<StatusOr<google::cloud::notebooks::v1::Instance>>
NotebookServiceClient::UpgradeInstance(
    google::cloud::notebooks::v1::UpgradeInstanceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpgradeInstance(request);
}

StatusOr<google::longrunning::Operation> NotebookServiceClient::UpgradeInstance(
    NoAwaitTag,
    google::cloud::notebooks::v1::UpgradeInstanceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpgradeInstance(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::notebooks::v1::Instance>>
NotebookServiceClient::UpgradeInstance(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpgradeInstance(operation);
}

future<StatusOr<google::cloud::notebooks::v1::Instance>>
NotebookServiceClient::RollbackInstance(
    google::cloud::notebooks::v1::RollbackInstanceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RollbackInstance(request);
}

StatusOr<google::longrunning::Operation>
NotebookServiceClient::RollbackInstance(
    NoAwaitTag,
    google::cloud::notebooks::v1::RollbackInstanceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RollbackInstance(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::notebooks::v1::Instance>>
NotebookServiceClient::RollbackInstance(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RollbackInstance(operation);
}

future<StatusOr<google::cloud::notebooks::v1::Instance>>
NotebookServiceClient::DiagnoseInstance(
    std::string const& name,
    google::cloud::notebooks::v1::DiagnosticConfig const& diagnostic_config,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::notebooks::v1::DiagnoseInstanceRequest request;
  request.set_name(name);
  *request.mutable_diagnostic_config() = diagnostic_config;
  return connection_->DiagnoseInstance(request);
}

StatusOr<google::longrunning::Operation>
NotebookServiceClient::DiagnoseInstance(
    NoAwaitTag, std::string const& name,
    google::cloud::notebooks::v1::DiagnosticConfig const& diagnostic_config,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::notebooks::v1::DiagnoseInstanceRequest request;
  request.set_name(name);
  *request.mutable_diagnostic_config() = diagnostic_config;
  return connection_->DiagnoseInstance(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::notebooks::v1::Instance>>
NotebookServiceClient::DiagnoseInstance(
    google::cloud::notebooks::v1::DiagnoseInstanceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DiagnoseInstance(request);
}

StatusOr<google::longrunning::Operation>
NotebookServiceClient::DiagnoseInstance(
    NoAwaitTag,
    google::cloud::notebooks::v1::DiagnoseInstanceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DiagnoseInstance(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::notebooks::v1::Instance>>
NotebookServiceClient::DiagnoseInstance(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DiagnoseInstance(operation);
}

future<StatusOr<google::cloud::notebooks::v1::Instance>>
NotebookServiceClient::UpgradeInstanceInternal(
    google::cloud::notebooks::v1::UpgradeInstanceInternalRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpgradeInstanceInternal(request);
}

StatusOr<google::longrunning::Operation>
NotebookServiceClient::UpgradeInstanceInternal(
    NoAwaitTag,
    google::cloud::notebooks::v1::UpgradeInstanceInternalRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpgradeInstanceInternal(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::notebooks::v1::Instance>>
NotebookServiceClient::UpgradeInstanceInternal(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpgradeInstanceInternal(operation);
}

StreamRange<google::cloud::notebooks::v1::Environment>
NotebookServiceClient::ListEnvironments(std::string const& parent,
                                        Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::notebooks::v1::ListEnvironmentsRequest request;
  request.set_parent(parent);
  return connection_->ListEnvironments(request);
}

StreamRange<google::cloud::notebooks::v1::Environment>
NotebookServiceClient::ListEnvironments(
    google::cloud::notebooks::v1::ListEnvironmentsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListEnvironments(std::move(request));
}

StatusOr<google::cloud::notebooks::v1::Environment>
NotebookServiceClient::GetEnvironment(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::notebooks::v1::GetEnvironmentRequest request;
  request.set_name(name);
  return connection_->GetEnvironment(request);
}

StatusOr<google::cloud::notebooks::v1::Environment>
NotebookServiceClient::GetEnvironment(
    google::cloud::notebooks::v1::GetEnvironmentRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetEnvironment(request);
}

future<StatusOr<google::cloud::notebooks::v1::Environment>>
NotebookServiceClient::CreateEnvironment(
    std::string const& parent,
    google::cloud::notebooks::v1::Environment const& environment,
    std::string const& environment_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::notebooks::v1::CreateEnvironmentRequest request;
  request.set_parent(parent);
  *request.mutable_environment() = environment;
  request.set_environment_id(environment_id);
  return connection_->CreateEnvironment(request);
}

StatusOr<google::longrunning::Operation>
NotebookServiceClient::CreateEnvironment(
    NoAwaitTag, std::string const& parent,
    google::cloud::notebooks::v1::Environment const& environment,
    std::string const& environment_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::notebooks::v1::CreateEnvironmentRequest request;
  request.set_parent(parent);
  *request.mutable_environment() = environment;
  request.set_environment_id(environment_id);
  return connection_->CreateEnvironment(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::notebooks::v1::Environment>>
NotebookServiceClient::CreateEnvironment(
    google::cloud::notebooks::v1::CreateEnvironmentRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateEnvironment(request);
}

StatusOr<google::longrunning::Operation>
NotebookServiceClient::CreateEnvironment(
    NoAwaitTag,
    google::cloud::notebooks::v1::CreateEnvironmentRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateEnvironment(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::notebooks::v1::Environment>>
NotebookServiceClient::CreateEnvironment(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateEnvironment(operation);
}

future<StatusOr<google::cloud::notebooks::v1::OperationMetadata>>
NotebookServiceClient::DeleteEnvironment(std::string const& name,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::notebooks::v1::DeleteEnvironmentRequest request;
  request.set_name(name);
  return connection_->DeleteEnvironment(request);
}

StatusOr<google::longrunning::Operation>
NotebookServiceClient::DeleteEnvironment(NoAwaitTag, std::string const& name,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::notebooks::v1::DeleteEnvironmentRequest request;
  request.set_name(name);
  return connection_->DeleteEnvironment(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::notebooks::v1::OperationMetadata>>
NotebookServiceClient::DeleteEnvironment(
    google::cloud::notebooks::v1::DeleteEnvironmentRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteEnvironment(request);
}

StatusOr<google::longrunning::Operation>
NotebookServiceClient::DeleteEnvironment(
    NoAwaitTag,
    google::cloud::notebooks::v1::DeleteEnvironmentRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteEnvironment(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::notebooks::v1::OperationMetadata>>
NotebookServiceClient::DeleteEnvironment(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteEnvironment(operation);
}

StreamRange<google::cloud::notebooks::v1::Schedule>
NotebookServiceClient::ListSchedules(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::notebooks::v1::ListSchedulesRequest request;
  request.set_parent(parent);
  return connection_->ListSchedules(request);
}

StreamRange<google::cloud::notebooks::v1::Schedule>
NotebookServiceClient::ListSchedules(
    google::cloud::notebooks::v1::ListSchedulesRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListSchedules(std::move(request));
}

StatusOr<google::cloud::notebooks::v1::Schedule>
NotebookServiceClient::GetSchedule(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::notebooks::v1::GetScheduleRequest request;
  request.set_name(name);
  return connection_->GetSchedule(request);
}

StatusOr<google::cloud::notebooks::v1::Schedule>
NotebookServiceClient::GetSchedule(
    google::cloud::notebooks::v1::GetScheduleRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetSchedule(request);
}

future<StatusOr<google::cloud::notebooks::v1::OperationMetadata>>
NotebookServiceClient::DeleteSchedule(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::notebooks::v1::DeleteScheduleRequest request;
  request.set_name(name);
  return connection_->DeleteSchedule(request);
}

StatusOr<google::longrunning::Operation> NotebookServiceClient::DeleteSchedule(
    NoAwaitTag, std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::notebooks::v1::DeleteScheduleRequest request;
  request.set_name(name);
  return connection_->DeleteSchedule(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::notebooks::v1::OperationMetadata>>
NotebookServiceClient::DeleteSchedule(
    google::cloud::notebooks::v1::DeleteScheduleRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteSchedule(request);
}

StatusOr<google::longrunning::Operation> NotebookServiceClient::DeleteSchedule(
    NoAwaitTag,
    google::cloud::notebooks::v1::DeleteScheduleRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteSchedule(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::notebooks::v1::OperationMetadata>>
NotebookServiceClient::DeleteSchedule(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteSchedule(operation);
}

future<StatusOr<google::cloud::notebooks::v1::Schedule>>
NotebookServiceClient::CreateSchedule(
    std::string const& parent,
    google::cloud::notebooks::v1::Schedule const& schedule,
    std::string const& schedule_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::notebooks::v1::CreateScheduleRequest request;
  request.set_parent(parent);
  *request.mutable_schedule() = schedule;
  request.set_schedule_id(schedule_id);
  return connection_->CreateSchedule(request);
}

StatusOr<google::longrunning::Operation> NotebookServiceClient::CreateSchedule(
    NoAwaitTag, std::string const& parent,
    google::cloud::notebooks::v1::Schedule const& schedule,
    std::string const& schedule_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::notebooks::v1::CreateScheduleRequest request;
  request.set_parent(parent);
  *request.mutable_schedule() = schedule;
  request.set_schedule_id(schedule_id);
  return connection_->CreateSchedule(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::notebooks::v1::Schedule>>
NotebookServiceClient::CreateSchedule(
    google::cloud::notebooks::v1::CreateScheduleRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateSchedule(request);
}

StatusOr<google::longrunning::Operation> NotebookServiceClient::CreateSchedule(
    NoAwaitTag,
    google::cloud::notebooks::v1::CreateScheduleRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateSchedule(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::notebooks::v1::Schedule>>
NotebookServiceClient::CreateSchedule(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateSchedule(operation);
}

future<StatusOr<google::cloud::notebooks::v1::Schedule>>
NotebookServiceClient::TriggerSchedule(
    google::cloud::notebooks::v1::TriggerScheduleRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->TriggerSchedule(request);
}

StatusOr<google::longrunning::Operation> NotebookServiceClient::TriggerSchedule(
    NoAwaitTag,
    google::cloud::notebooks::v1::TriggerScheduleRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->TriggerSchedule(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::notebooks::v1::Schedule>>
NotebookServiceClient::TriggerSchedule(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->TriggerSchedule(operation);
}

StreamRange<google::cloud::notebooks::v1::Execution>
NotebookServiceClient::ListExecutions(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::notebooks::v1::ListExecutionsRequest request;
  request.set_parent(parent);
  return connection_->ListExecutions(request);
}

StreamRange<google::cloud::notebooks::v1::Execution>
NotebookServiceClient::ListExecutions(
    google::cloud::notebooks::v1::ListExecutionsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListExecutions(std::move(request));
}

StatusOr<google::cloud::notebooks::v1::Execution>
NotebookServiceClient::GetExecution(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::notebooks::v1::GetExecutionRequest request;
  request.set_name(name);
  return connection_->GetExecution(request);
}

StatusOr<google::cloud::notebooks::v1::Execution>
NotebookServiceClient::GetExecution(
    google::cloud::notebooks::v1::GetExecutionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetExecution(request);
}

future<StatusOr<google::cloud::notebooks::v1::OperationMetadata>>
NotebookServiceClient::DeleteExecution(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::notebooks::v1::DeleteExecutionRequest request;
  request.set_name(name);
  return connection_->DeleteExecution(request);
}

StatusOr<google::longrunning::Operation> NotebookServiceClient::DeleteExecution(
    NoAwaitTag, std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::notebooks::v1::DeleteExecutionRequest request;
  request.set_name(name);
  return connection_->DeleteExecution(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::notebooks::v1::OperationMetadata>>
NotebookServiceClient::DeleteExecution(
    google::cloud::notebooks::v1::DeleteExecutionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteExecution(request);
}

StatusOr<google::longrunning::Operation> NotebookServiceClient::DeleteExecution(
    NoAwaitTag,
    google::cloud::notebooks::v1::DeleteExecutionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteExecution(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::notebooks::v1::OperationMetadata>>
NotebookServiceClient::DeleteExecution(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteExecution(operation);
}

future<StatusOr<google::cloud::notebooks::v1::Execution>>
NotebookServiceClient::CreateExecution(
    std::string const& parent,
    google::cloud::notebooks::v1::Execution const& execution,
    std::string const& execution_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::notebooks::v1::CreateExecutionRequest request;
  request.set_parent(parent);
  *request.mutable_execution() = execution;
  request.set_execution_id(execution_id);
  return connection_->CreateExecution(request);
}

StatusOr<google::longrunning::Operation> NotebookServiceClient::CreateExecution(
    NoAwaitTag, std::string const& parent,
    google::cloud::notebooks::v1::Execution const& execution,
    std::string const& execution_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::notebooks::v1::CreateExecutionRequest request;
  request.set_parent(parent);
  *request.mutable_execution() = execution;
  request.set_execution_id(execution_id);
  return connection_->CreateExecution(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::notebooks::v1::Execution>>
NotebookServiceClient::CreateExecution(
    google::cloud::notebooks::v1::CreateExecutionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateExecution(request);
}

StatusOr<google::longrunning::Operation> NotebookServiceClient::CreateExecution(
    NoAwaitTag,
    google::cloud::notebooks::v1::CreateExecutionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateExecution(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::notebooks::v1::Execution>>
NotebookServiceClient::CreateExecution(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateExecution(operation);
}

StreamRange<google::cloud::location::Location>
NotebookServiceClient::ListLocations(
    google::cloud::location::ListLocationsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListLocations(std::move(request));
}

StatusOr<google::cloud::location::Location> NotebookServiceClient::GetLocation(
    google::cloud::location::GetLocationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetLocation(request);
}

StatusOr<google::iam::v1::Policy> NotebookServiceClient::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetIamPolicy(request);
}

StatusOr<google::iam::v1::Policy> NotebookServiceClient::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetIamPolicy(request);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
NotebookServiceClient::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->TestIamPermissions(request);
}

StreamRange<google::longrunning::Operation>
NotebookServiceClient::ListOperations(std::string const& name,
                                      std::string const& filter, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::ListOperationsRequest request;
  request.set_name(name);
  request.set_filter(filter);
  return connection_->ListOperations(request);
}

StreamRange<google::longrunning::Operation>
NotebookServiceClient::ListOperations(
    google::longrunning::ListOperationsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListOperations(std::move(request));
}

StatusOr<google::longrunning::Operation> NotebookServiceClient::GetOperation(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::GetOperationRequest request;
  request.set_name(name);
  return connection_->GetOperation(request);
}

StatusOr<google::longrunning::Operation> NotebookServiceClient::GetOperation(
    google::longrunning::GetOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetOperation(request);
}

Status NotebookServiceClient::DeleteOperation(std::string const& name,
                                              Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::DeleteOperationRequest request;
  request.set_name(name);
  return connection_->DeleteOperation(request);
}

Status NotebookServiceClient::DeleteOperation(
    google::longrunning::DeleteOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteOperation(request);
}

Status NotebookServiceClient::CancelOperation(std::string const& name,
                                              Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::CancelOperationRequest request;
  request.set_name(name);
  return connection_->CancelOperation(request);
}

Status NotebookServiceClient::CancelOperation(
    google::longrunning::CancelOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CancelOperation(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace notebooks_v1
}  // namespace cloud
}  // namespace google
