// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/notebooks/v1/service.proto

#include "google/cloud/notebooks/v1/internal/notebook_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace notebooks_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

NotebookServiceTracingStub::NotebookServiceTracingStub(
    std::shared_ptr<NotebookServiceStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::cloud::notebooks::v1::ListInstancesResponse>
NotebookServiceTracingStub::ListInstances(
    grpc::ClientContext& context, Options const& options,
    google::cloud::notebooks::v1::ListInstancesRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "ListInstances");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListInstances(context, options, request));
}

StatusOr<google::cloud::notebooks::v1::Instance>
NotebookServiceTracingStub::GetInstance(
    grpc::ClientContext& context, Options const& options,
    google::cloud::notebooks::v1::GetInstanceRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "GetInstance");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetInstance(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
NotebookServiceTracingStub::AsyncCreateInstance(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::notebooks::v1::CreateInstanceRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "CreateInstance");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCreateInstance(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
NotebookServiceTracingStub::CreateInstance(
    grpc::ClientContext& context, Options options,
    google::cloud::notebooks::v1::CreateInstanceRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "CreateInstance");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateInstance(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
NotebookServiceTracingStub::AsyncRegisterInstance(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::notebooks::v1::RegisterInstanceRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "RegisterInstance");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncRegisterInstance(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
NotebookServiceTracingStub::RegisterInstance(
    grpc::ClientContext& context, Options options,
    google::cloud::notebooks::v1::RegisterInstanceRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "RegisterInstance");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->RegisterInstance(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
NotebookServiceTracingStub::AsyncSetInstanceAccelerator(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::notebooks::v1::SetInstanceAcceleratorRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "SetInstanceAccelerator");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncSetInstanceAccelerator(cq, context, std::move(options),
                                               request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
NotebookServiceTracingStub::SetInstanceAccelerator(
    grpc::ClientContext& context, Options options,
    google::cloud::notebooks::v1::SetInstanceAcceleratorRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "SetInstanceAccelerator");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->SetInstanceAccelerator(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
NotebookServiceTracingStub::AsyncSetInstanceMachineType(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::notebooks::v1::SetInstanceMachineTypeRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "SetInstanceMachineType");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncSetInstanceMachineType(cq, context, std::move(options),
                                               request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
NotebookServiceTracingStub::SetInstanceMachineType(
    grpc::ClientContext& context, Options options,
    google::cloud::notebooks::v1::SetInstanceMachineTypeRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "SetInstanceMachineType");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->SetInstanceMachineType(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
NotebookServiceTracingStub::AsyncUpdateInstanceConfig(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::notebooks::v1::UpdateInstanceConfigRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "UpdateInstanceConfig");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncUpdateInstanceConfig(cq, context, std::move(options),
                                             request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
NotebookServiceTracingStub::UpdateInstanceConfig(
    grpc::ClientContext& context, Options options,
    google::cloud::notebooks::v1::UpdateInstanceConfigRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "UpdateInstanceConfig");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->UpdateInstanceConfig(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
NotebookServiceTracingStub::AsyncUpdateShieldedInstanceConfig(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::notebooks::v1::UpdateShieldedInstanceConfigRequest const&
        request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.notebooks.v1.NotebookService",
                             "UpdateShieldedInstanceConfig");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncUpdateShieldedInstanceConfig(
      cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
NotebookServiceTracingStub::UpdateShieldedInstanceConfig(
    grpc::ClientContext& context, Options options,
    google::cloud::notebooks::v1::UpdateShieldedInstanceConfigRequest const&
        request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.notebooks.v1.NotebookService",
                             "UpdateShieldedInstanceConfig");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->UpdateShieldedInstanceConfig(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
NotebookServiceTracingStub::AsyncSetInstanceLabels(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::notebooks::v1::SetInstanceLabelsRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "SetInstanceLabels");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncSetInstanceLabels(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
NotebookServiceTracingStub::SetInstanceLabels(
    grpc::ClientContext& context, Options options,
    google::cloud::notebooks::v1::SetInstanceLabelsRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "SetInstanceLabels");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->SetInstanceLabels(context, options, request));
}

StatusOr<google::cloud::notebooks::v1::UpdateInstanceMetadataItemsResponse>
NotebookServiceTracingStub::UpdateInstanceMetadataItems(
    grpc::ClientContext& context, Options const& options,
    google::cloud::notebooks::v1::UpdateInstanceMetadataItemsRequest const&
        request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.notebooks.v1.NotebookService",
                             "UpdateInstanceMetadataItems");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->UpdateInstanceMetadataItems(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
NotebookServiceTracingStub::AsyncDeleteInstance(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::notebooks::v1::DeleteInstanceRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "DeleteInstance");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncDeleteInstance(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
NotebookServiceTracingStub::DeleteInstance(
    grpc::ClientContext& context, Options options,
    google::cloud::notebooks::v1::DeleteInstanceRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "DeleteInstance");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteInstance(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
NotebookServiceTracingStub::AsyncStartInstance(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::notebooks::v1::StartInstanceRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "StartInstance");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncStartInstance(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
NotebookServiceTracingStub::StartInstance(
    grpc::ClientContext& context, Options options,
    google::cloud::notebooks::v1::StartInstanceRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "StartInstance");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->StartInstance(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
NotebookServiceTracingStub::AsyncStopInstance(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::notebooks::v1::StopInstanceRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "StopInstance");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncStopInstance(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
NotebookServiceTracingStub::StopInstance(
    grpc::ClientContext& context, Options options,
    google::cloud::notebooks::v1::StopInstanceRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "StopInstance");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->StopInstance(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
NotebookServiceTracingStub::AsyncResetInstance(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::notebooks::v1::ResetInstanceRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "ResetInstance");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncResetInstance(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
NotebookServiceTracingStub::ResetInstance(
    grpc::ClientContext& context, Options options,
    google::cloud::notebooks::v1::ResetInstanceRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "ResetInstance");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ResetInstance(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
NotebookServiceTracingStub::AsyncReportInstanceInfo(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::notebooks::v1::ReportInstanceInfoRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "ReportInstanceInfo");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncReportInstanceInfo(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
NotebookServiceTracingStub::ReportInstanceInfo(
    grpc::ClientContext& context, Options options,
    google::cloud::notebooks::v1::ReportInstanceInfoRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "ReportInstanceInfo");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->ReportInstanceInfo(context, options, request));
}

StatusOr<google::cloud::notebooks::v1::IsInstanceUpgradeableResponse>
NotebookServiceTracingStub::IsInstanceUpgradeable(
    grpc::ClientContext& context, Options const& options,
    google::cloud::notebooks::v1::IsInstanceUpgradeableRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "IsInstanceUpgradeable");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->IsInstanceUpgradeable(context, options, request));
}

StatusOr<google::cloud::notebooks::v1::GetInstanceHealthResponse>
NotebookServiceTracingStub::GetInstanceHealth(
    grpc::ClientContext& context, Options const& options,
    google::cloud::notebooks::v1::GetInstanceHealthRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "GetInstanceHealth");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->GetInstanceHealth(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
NotebookServiceTracingStub::AsyncUpgradeInstance(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::notebooks::v1::UpgradeInstanceRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "UpgradeInstance");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncUpgradeInstance(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
NotebookServiceTracingStub::UpgradeInstance(
    grpc::ClientContext& context, Options options,
    google::cloud::notebooks::v1::UpgradeInstanceRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "UpgradeInstance");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpgradeInstance(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
NotebookServiceTracingStub::AsyncRollbackInstance(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::notebooks::v1::RollbackInstanceRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "RollbackInstance");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncRollbackInstance(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
NotebookServiceTracingStub::RollbackInstance(
    grpc::ClientContext& context, Options options,
    google::cloud::notebooks::v1::RollbackInstanceRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "RollbackInstance");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->RollbackInstance(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
NotebookServiceTracingStub::AsyncDiagnoseInstance(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::notebooks::v1::DiagnoseInstanceRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "DiagnoseInstance");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncDiagnoseInstance(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
NotebookServiceTracingStub::DiagnoseInstance(
    grpc::ClientContext& context, Options options,
    google::cloud::notebooks::v1::DiagnoseInstanceRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "DiagnoseInstance");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DiagnoseInstance(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
NotebookServiceTracingStub::AsyncUpgradeInstanceInternal(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::notebooks::v1::UpgradeInstanceInternalRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "UpgradeInstanceInternal");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncUpgradeInstanceInternal(cq, context, std::move(options),
                                                request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
NotebookServiceTracingStub::UpgradeInstanceInternal(
    grpc::ClientContext& context, Options options,
    google::cloud::notebooks::v1::UpgradeInstanceInternalRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "UpgradeInstanceInternal");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->UpgradeInstanceInternal(context, options, request));
}

StatusOr<google::cloud::notebooks::v1::ListEnvironmentsResponse>
NotebookServiceTracingStub::ListEnvironments(
    grpc::ClientContext& context, Options const& options,
    google::cloud::notebooks::v1::ListEnvironmentsRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "ListEnvironments");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListEnvironments(context, options, request));
}

StatusOr<google::cloud::notebooks::v1::Environment>
NotebookServiceTracingStub::GetEnvironment(
    grpc::ClientContext& context, Options const& options,
    google::cloud::notebooks::v1::GetEnvironmentRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "GetEnvironment");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetEnvironment(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
NotebookServiceTracingStub::AsyncCreateEnvironment(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::notebooks::v1::CreateEnvironmentRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "CreateEnvironment");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCreateEnvironment(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
NotebookServiceTracingStub::CreateEnvironment(
    grpc::ClientContext& context, Options options,
    google::cloud::notebooks::v1::CreateEnvironmentRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "CreateEnvironment");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->CreateEnvironment(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
NotebookServiceTracingStub::AsyncDeleteEnvironment(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::notebooks::v1::DeleteEnvironmentRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "DeleteEnvironment");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncDeleteEnvironment(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
NotebookServiceTracingStub::DeleteEnvironment(
    grpc::ClientContext& context, Options options,
    google::cloud::notebooks::v1::DeleteEnvironmentRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "DeleteEnvironment");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->DeleteEnvironment(context, options, request));
}

StatusOr<google::cloud::notebooks::v1::ListSchedulesResponse>
NotebookServiceTracingStub::ListSchedules(
    grpc::ClientContext& context, Options const& options,
    google::cloud::notebooks::v1::ListSchedulesRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "ListSchedules");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListSchedules(context, options, request));
}

StatusOr<google::cloud::notebooks::v1::Schedule>
NotebookServiceTracingStub::GetSchedule(
    grpc::ClientContext& context, Options const& options,
    google::cloud::notebooks::v1::GetScheduleRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "GetSchedule");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetSchedule(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
NotebookServiceTracingStub::AsyncDeleteSchedule(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::notebooks::v1::DeleteScheduleRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "DeleteSchedule");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncDeleteSchedule(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
NotebookServiceTracingStub::DeleteSchedule(
    grpc::ClientContext& context, Options options,
    google::cloud::notebooks::v1::DeleteScheduleRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "DeleteSchedule");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteSchedule(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
NotebookServiceTracingStub::AsyncCreateSchedule(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::notebooks::v1::CreateScheduleRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "CreateSchedule");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCreateSchedule(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
NotebookServiceTracingStub::CreateSchedule(
    grpc::ClientContext& context, Options options,
    google::cloud::notebooks::v1::CreateScheduleRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "CreateSchedule");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateSchedule(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
NotebookServiceTracingStub::AsyncTriggerSchedule(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::notebooks::v1::TriggerScheduleRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "TriggerSchedule");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncTriggerSchedule(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
NotebookServiceTracingStub::TriggerSchedule(
    grpc::ClientContext& context, Options options,
    google::cloud::notebooks::v1::TriggerScheduleRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "TriggerSchedule");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->TriggerSchedule(context, options, request));
}

StatusOr<google::cloud::notebooks::v1::ListExecutionsResponse>
NotebookServiceTracingStub::ListExecutions(
    grpc::ClientContext& context, Options const& options,
    google::cloud::notebooks::v1::ListExecutionsRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "ListExecutions");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListExecutions(context, options, request));
}

StatusOr<google::cloud::notebooks::v1::Execution>
NotebookServiceTracingStub::GetExecution(
    grpc::ClientContext& context, Options const& options,
    google::cloud::notebooks::v1::GetExecutionRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "GetExecution");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetExecution(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
NotebookServiceTracingStub::AsyncDeleteExecution(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::notebooks::v1::DeleteExecutionRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "DeleteExecution");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncDeleteExecution(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
NotebookServiceTracingStub::DeleteExecution(
    grpc::ClientContext& context, Options options,
    google::cloud::notebooks::v1::DeleteExecutionRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "DeleteExecution");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteExecution(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
NotebookServiceTracingStub::AsyncCreateExecution(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::notebooks::v1::CreateExecutionRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "CreateExecution");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCreateExecution(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
NotebookServiceTracingStub::CreateExecution(
    grpc::ClientContext& context, Options options,
    google::cloud::notebooks::v1::CreateExecutionRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "CreateExecution");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateExecution(context, options, request));
}

StatusOr<google::cloud::location::ListLocationsResponse>
NotebookServiceTracingStub::ListLocations(
    grpc::ClientContext& context, Options const& options,
    google::cloud::location::ListLocationsRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "ListLocations");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListLocations(context, options, request));
}

StatusOr<google::cloud::location::Location>
NotebookServiceTracingStub::GetLocation(
    grpc::ClientContext& context, Options const& options,
    google::cloud::location::GetLocationRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "GetLocation");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetLocation(context, options, request));
}

StatusOr<google::iam::v1::Policy> NotebookServiceTracingStub::SetIamPolicy(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::SetIamPolicyRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "SetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->SetIamPolicy(context, options, request));
}

StatusOr<google::iam::v1::Policy> NotebookServiceTracingStub::GetIamPolicy(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::GetIamPolicyRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "GetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetIamPolicy(context, options, request));
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
NotebookServiceTracingStub::TestIamPermissions(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::TestIamPermissionsRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "TestIamPermissions");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->TestIamPermissions(context, options, request));
}

StatusOr<google::longrunning::ListOperationsResponse>
NotebookServiceTracingStub::ListOperations(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::ListOperationsRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "ListOperations");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListOperations(context, options, request));
}

StatusOr<google::longrunning::Operation>
NotebookServiceTracingStub::GetOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::GetOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "GetOperation");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetOperation(context, options, request));
}

Status NotebookServiceTracingStub::DeleteOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::DeleteOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "DeleteOperation");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteOperation(context, options, request));
}

Status NotebookServiceTracingStub::CancelOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.NotebookService", "CancelOperation");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CancelOperation(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
NotebookServiceTracingStub::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.longrunning.Operations", "GetOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncGetOperation(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<Status> NotebookServiceTracingStub::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.longrunning.Operations",
                                     "CancelOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCancelOperation(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<NotebookServiceStub> MakeNotebookServiceTracingStub(
    std::shared_ptr<NotebookServiceStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<NotebookServiceTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace notebooks_v1_internal
}  // namespace cloud
}  // namespace google
