// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/notebooks/v1/managed_service.proto

#include "google/cloud/notebooks/v1/internal/managed_notebook_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace notebooks_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

ManagedNotebookServiceTracingStub::ManagedNotebookServiceTracingStub(
    std::shared_ptr<ManagedNotebookServiceStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::cloud::notebooks::v1::ListRuntimesResponse>
ManagedNotebookServiceTracingStub::ListRuntimes(
    grpc::ClientContext& context, Options const& options,
    google::cloud::notebooks::v1::ListRuntimesRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.ManagedNotebookService", "ListRuntimes");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListRuntimes(context, options, request));
}

StatusOr<google::cloud::notebooks::v1::Runtime>
ManagedNotebookServiceTracingStub::GetRuntime(
    grpc::ClientContext& context, Options const& options,
    google::cloud::notebooks::v1::GetRuntimeRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.ManagedNotebookService", "GetRuntime");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetRuntime(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
ManagedNotebookServiceTracingStub::AsyncCreateRuntime(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::notebooks::v1::CreateRuntimeRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.ManagedNotebookService", "CreateRuntime");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncCreateRuntime(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
ManagedNotebookServiceTracingStub::CreateRuntime(
    grpc::ClientContext& context, Options options,
    google::cloud::notebooks::v1::CreateRuntimeRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.ManagedNotebookService", "CreateRuntime");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateRuntime(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
ManagedNotebookServiceTracingStub::AsyncUpdateRuntime(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::notebooks::v1::UpdateRuntimeRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.ManagedNotebookService", "UpdateRuntime");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncUpdateRuntime(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
ManagedNotebookServiceTracingStub::UpdateRuntime(
    grpc::ClientContext& context, Options options,
    google::cloud::notebooks::v1::UpdateRuntimeRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.ManagedNotebookService", "UpdateRuntime");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateRuntime(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
ManagedNotebookServiceTracingStub::AsyncDeleteRuntime(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::notebooks::v1::DeleteRuntimeRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.ManagedNotebookService", "DeleteRuntime");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncDeleteRuntime(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
ManagedNotebookServiceTracingStub::DeleteRuntime(
    grpc::ClientContext& context, Options options,
    google::cloud::notebooks::v1::DeleteRuntimeRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.ManagedNotebookService", "DeleteRuntime");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteRuntime(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
ManagedNotebookServiceTracingStub::AsyncStartRuntime(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::notebooks::v1::StartRuntimeRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.ManagedNotebookService", "StartRuntime");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncStartRuntime(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
ManagedNotebookServiceTracingStub::StartRuntime(
    grpc::ClientContext& context, Options options,
    google::cloud::notebooks::v1::StartRuntimeRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.ManagedNotebookService", "StartRuntime");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->StartRuntime(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
ManagedNotebookServiceTracingStub::AsyncStopRuntime(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::notebooks::v1::StopRuntimeRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.ManagedNotebookService", "StopRuntime");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncStopRuntime(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
ManagedNotebookServiceTracingStub::StopRuntime(
    grpc::ClientContext& context, Options options,
    google::cloud::notebooks::v1::StopRuntimeRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.ManagedNotebookService", "StopRuntime");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->StopRuntime(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
ManagedNotebookServiceTracingStub::AsyncSwitchRuntime(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::notebooks::v1::SwitchRuntimeRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.ManagedNotebookService", "SwitchRuntime");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncSwitchRuntime(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
ManagedNotebookServiceTracingStub::SwitchRuntime(
    grpc::ClientContext& context, Options options,
    google::cloud::notebooks::v1::SwitchRuntimeRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.ManagedNotebookService", "SwitchRuntime");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->SwitchRuntime(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
ManagedNotebookServiceTracingStub::AsyncResetRuntime(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::notebooks::v1::ResetRuntimeRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.ManagedNotebookService", "ResetRuntime");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncResetRuntime(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
ManagedNotebookServiceTracingStub::ResetRuntime(
    grpc::ClientContext& context, Options options,
    google::cloud::notebooks::v1::ResetRuntimeRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.ManagedNotebookService", "ResetRuntime");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ResetRuntime(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
ManagedNotebookServiceTracingStub::AsyncUpgradeRuntime(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::notebooks::v1::UpgradeRuntimeRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.ManagedNotebookService", "UpgradeRuntime");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncUpgradeRuntime(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
ManagedNotebookServiceTracingStub::UpgradeRuntime(
    grpc::ClientContext& context, Options options,
    google::cloud::notebooks::v1::UpgradeRuntimeRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.ManagedNotebookService", "UpgradeRuntime");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpgradeRuntime(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
ManagedNotebookServiceTracingStub::AsyncReportRuntimeEvent(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::notebooks::v1::ReportRuntimeEventRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.ManagedNotebookService", "ReportRuntimeEvent");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncReportRuntimeEvent(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
ManagedNotebookServiceTracingStub::ReportRuntimeEvent(
    grpc::ClientContext& context, Options options,
    google::cloud::notebooks::v1::ReportRuntimeEventRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.ManagedNotebookService", "ReportRuntimeEvent");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->ReportRuntimeEvent(context, options, request));
}

StatusOr<google::cloud::notebooks::v1::RefreshRuntimeTokenInternalResponse>
ManagedNotebookServiceTracingStub::RefreshRuntimeTokenInternal(
    grpc::ClientContext& context, Options const& options,
    google::cloud::notebooks::v1::RefreshRuntimeTokenInternalRequest const&
        request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.notebooks.v1.ManagedNotebookService",
                             "RefreshRuntimeTokenInternal");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->RefreshRuntimeTokenInternal(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
ManagedNotebookServiceTracingStub::AsyncDiagnoseRuntime(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::notebooks::v1::DiagnoseRuntimeRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.ManagedNotebookService", "DiagnoseRuntime");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncDiagnoseRuntime(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
ManagedNotebookServiceTracingStub::DiagnoseRuntime(
    grpc::ClientContext& context, Options options,
    google::cloud::notebooks::v1::DiagnoseRuntimeRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.ManagedNotebookService", "DiagnoseRuntime");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DiagnoseRuntime(context, options, request));
}

StatusOr<google::cloud::location::ListLocationsResponse>
ManagedNotebookServiceTracingStub::ListLocations(
    grpc::ClientContext& context, Options const& options,
    google::cloud::location::ListLocationsRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.ManagedNotebookService", "ListLocations");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListLocations(context, options, request));
}

StatusOr<google::cloud::location::Location>
ManagedNotebookServiceTracingStub::GetLocation(
    grpc::ClientContext& context, Options const& options,
    google::cloud::location::GetLocationRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.ManagedNotebookService", "GetLocation");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetLocation(context, options, request));
}

StatusOr<google::iam::v1::Policy>
ManagedNotebookServiceTracingStub::SetIamPolicy(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::SetIamPolicyRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.ManagedNotebookService", "SetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->SetIamPolicy(context, options, request));
}

StatusOr<google::iam::v1::Policy>
ManagedNotebookServiceTracingStub::GetIamPolicy(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::GetIamPolicyRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.ManagedNotebookService", "GetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetIamPolicy(context, options, request));
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
ManagedNotebookServiceTracingStub::TestIamPermissions(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::TestIamPermissionsRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.ManagedNotebookService", "TestIamPermissions");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->TestIamPermissions(context, options, request));
}

StatusOr<google::longrunning::ListOperationsResponse>
ManagedNotebookServiceTracingStub::ListOperations(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::ListOperationsRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.ManagedNotebookService", "ListOperations");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListOperations(context, options, request));
}

StatusOr<google::longrunning::Operation>
ManagedNotebookServiceTracingStub::GetOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::GetOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.ManagedNotebookService", "GetOperation");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetOperation(context, options, request));
}

Status ManagedNotebookServiceTracingStub::DeleteOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::DeleteOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.ManagedNotebookService", "DeleteOperation");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteOperation(context, options, request));
}

Status ManagedNotebookServiceTracingStub::CancelOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.notebooks.v1.ManagedNotebookService", "CancelOperation");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CancelOperation(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
ManagedNotebookServiceTracingStub::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.longrunning.Operations", "GetOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncGetOperation(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<Status> ManagedNotebookServiceTracingStub::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.longrunning.Operations",
                                     "CancelOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCancelOperation(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<ManagedNotebookServiceStub>
MakeManagedNotebookServiceTracingStub(
    std::shared_ptr<ManagedNotebookServiceStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<ManagedNotebookServiceTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace notebooks_v1_internal
}  // namespace cloud
}  // namespace google
