// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/networkservices/v1/network_services.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETWORKSERVICES_V1_MOCKS_MOCK_NETWORK_SERVICES_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETWORKSERVICES_V1_MOCKS_MOCK_NETWORK_SERVICES_CONNECTION_H

#include "google/cloud/networkservices/v1/network_services_connection.h"
#include <gmock/gmock.h>

namespace google {
namespace cloud {
namespace networkservices_v1_mocks {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/**
 * A class to mock `NetworkServicesConnection`.
 *
 * Application developers may want to test their code with simulated responses,
 * including errors, from an object of type `NetworkServicesClient`. To do so,
 * construct an object of type `NetworkServicesClient` with an instance of this
 * class. Then use the Google Test framework functions to program the behavior
 * of this mock.
 *
 * @see [This example][bq-mock] for how to test your application with GoogleTest.
 * While the example showcases types from the BigQuery library, the underlying
 * principles apply for any pair of `*Client` and `*Connection`.
 *
 * [bq-mock]: @cloud_cpp_docs_link{bigquery,bigquery-read-mock}
 */
class MockNetworkServicesConnection
    : public networkservices_v1::NetworkServicesConnection {
 public:
  MOCK_METHOD(Options, options, (), (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::networkservices::v1::EndpointPolicy>),
      ListEndpointPolicies,
      (google::cloud::networkservices::v1::ListEndpointPoliciesRequest request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::networkservices::v1::EndpointPolicy>,
      GetEndpointPolicy,
      (google::cloud::networkservices::v1::GetEndpointPolicyRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateEndpointPolicy(Matcher<google::cloud::networkservices::v1::CreateEndpointPolicyRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::networkservices::v1::EndpointPolicy>>,
      CreateEndpointPolicy,
      (google::cloud::networkservices::v1::CreateEndpointPolicyRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, CreateEndpointPolicy(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, CreateEndpointPolicy,
      (NoAwaitTag,
       google::cloud::networkservices::v1::CreateEndpointPolicyRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateEndpointPolicy(Matcher<google::longrunning::Operation const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::networkservices::v1::EndpointPolicy>>,
      CreateEndpointPolicy, (google::longrunning::Operation const& operation),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateEndpointPolicy(Matcher<google::cloud::networkservices::v1::UpdateEndpointPolicyRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::networkservices::v1::EndpointPolicy>>,
      UpdateEndpointPolicy,
      (google::cloud::networkservices::v1::UpdateEndpointPolicyRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, UpdateEndpointPolicy(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, UpdateEndpointPolicy,
      (NoAwaitTag,
       google::cloud::networkservices::v1::UpdateEndpointPolicyRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateEndpointPolicy(Matcher<google::longrunning::Operation const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::networkservices::v1::EndpointPolicy>>,
      UpdateEndpointPolicy, (google::longrunning::Operation const& operation),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteEndpointPolicy(Matcher<google::cloud::networkservices::v1::DeleteEndpointPolicyRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>,
      DeleteEndpointPolicy,
      (google::cloud::networkservices::v1::DeleteEndpointPolicyRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, DeleteEndpointPolicy(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, DeleteEndpointPolicy,
      (NoAwaitTag,
       google::cloud::networkservices::v1::DeleteEndpointPolicyRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteEndpointPolicy(Matcher<google::longrunning::Operation const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>,
      DeleteEndpointPolicy, (google::longrunning::Operation const& operation),
      (override));

  MOCK_METHOD((StreamRange<google::cloud::networkservices::v1::Gateway>),
              ListGateways,
              (google::cloud::networkservices::v1::ListGatewaysRequest request),
              (override));

  MOCK_METHOD(
      StatusOr<google::cloud::networkservices::v1::Gateway>, GetGateway,
      (google::cloud::networkservices::v1::GetGatewayRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateGateway(Matcher<google::cloud::networkservices::v1::CreateGatewayRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::networkservices::v1::Gateway>>,
      CreateGateway,
      (google::cloud::networkservices::v1::CreateGatewayRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, CreateGateway(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, CreateGateway,
      (NoAwaitTag,
       google::cloud::networkservices::v1::CreateGatewayRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, CreateGateway(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::networkservices::v1::Gateway>>,
              CreateGateway, (google::longrunning::Operation const& operation),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateGateway(Matcher<google::cloud::networkservices::v1::UpdateGatewayRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::networkservices::v1::Gateway>>,
      UpdateGateway,
      (google::cloud::networkservices::v1::UpdateGatewayRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, UpdateGateway(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, UpdateGateway,
      (NoAwaitTag,
       google::cloud::networkservices::v1::UpdateGatewayRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, UpdateGateway(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::networkservices::v1::Gateway>>,
              UpdateGateway, (google::longrunning::Operation const& operation),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteGateway(Matcher<google::cloud::networkservices::v1::DeleteGatewayRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>,
      DeleteGateway,
      (google::cloud::networkservices::v1::DeleteGatewayRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, DeleteGateway(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, DeleteGateway,
      (NoAwaitTag,
       google::cloud::networkservices::v1::DeleteGatewayRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, DeleteGateway(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>,
      DeleteGateway, (google::longrunning::Operation const& operation),
      (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::networkservices::v1::GrpcRoute>),
      ListGrpcRoutes,
      (google::cloud::networkservices::v1::ListGrpcRoutesRequest request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::networkservices::v1::GrpcRoute>, GetGrpcRoute,
      (google::cloud::networkservices::v1::GetGrpcRouteRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateGrpcRoute(Matcher<google::cloud::networkservices::v1::CreateGrpcRouteRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::networkservices::v1::GrpcRoute>>,
              CreateGrpcRoute,
              (google::cloud::networkservices::v1::CreateGrpcRouteRequest const&
                   request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, CreateGrpcRoute(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>, CreateGrpcRoute,
              (NoAwaitTag,
               google::cloud::networkservices::v1::CreateGrpcRouteRequest const&
                   request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, CreateGrpcRoute(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::networkservices::v1::GrpcRoute>>,
              CreateGrpcRoute,
              (google::longrunning::Operation const& operation), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateGrpcRoute(Matcher<google::cloud::networkservices::v1::UpdateGrpcRouteRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::networkservices::v1::GrpcRoute>>,
              UpdateGrpcRoute,
              (google::cloud::networkservices::v1::UpdateGrpcRouteRequest const&
                   request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, UpdateGrpcRoute(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>, UpdateGrpcRoute,
              (NoAwaitTag,
               google::cloud::networkservices::v1::UpdateGrpcRouteRequest const&
                   request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, UpdateGrpcRoute(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::networkservices::v1::GrpcRoute>>,
              UpdateGrpcRoute,
              (google::longrunning::Operation const& operation), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteGrpcRoute(Matcher<google::cloud::networkservices::v1::DeleteGrpcRouteRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>,
      DeleteGrpcRoute,
      (google::cloud::networkservices::v1::DeleteGrpcRouteRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, DeleteGrpcRoute(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>, DeleteGrpcRoute,
              (NoAwaitTag,
               google::cloud::networkservices::v1::DeleteGrpcRouteRequest const&
                   request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, DeleteGrpcRoute(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>,
      DeleteGrpcRoute, (google::longrunning::Operation const& operation),
      (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::networkservices::v1::HttpRoute>),
      ListHttpRoutes,
      (google::cloud::networkservices::v1::ListHttpRoutesRequest request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::networkservices::v1::HttpRoute>, GetHttpRoute,
      (google::cloud::networkservices::v1::GetHttpRouteRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateHttpRoute(Matcher<google::cloud::networkservices::v1::CreateHttpRouteRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::networkservices::v1::HttpRoute>>,
              CreateHttpRoute,
              (google::cloud::networkservices::v1::CreateHttpRouteRequest const&
                   request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, CreateHttpRoute(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>, CreateHttpRoute,
              (NoAwaitTag,
               google::cloud::networkservices::v1::CreateHttpRouteRequest const&
                   request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, CreateHttpRoute(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::networkservices::v1::HttpRoute>>,
              CreateHttpRoute,
              (google::longrunning::Operation const& operation), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateHttpRoute(Matcher<google::cloud::networkservices::v1::UpdateHttpRouteRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::networkservices::v1::HttpRoute>>,
              UpdateHttpRoute,
              (google::cloud::networkservices::v1::UpdateHttpRouteRequest const&
                   request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, UpdateHttpRoute(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>, UpdateHttpRoute,
              (NoAwaitTag,
               google::cloud::networkservices::v1::UpdateHttpRouteRequest const&
                   request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, UpdateHttpRoute(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::networkservices::v1::HttpRoute>>,
              UpdateHttpRoute,
              (google::longrunning::Operation const& operation), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteHttpRoute(Matcher<google::cloud::networkservices::v1::DeleteHttpRouteRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>,
      DeleteHttpRoute,
      (google::cloud::networkservices::v1::DeleteHttpRouteRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, DeleteHttpRoute(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>, DeleteHttpRoute,
              (NoAwaitTag,
               google::cloud::networkservices::v1::DeleteHttpRouteRequest const&
                   request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, DeleteHttpRoute(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>,
      DeleteHttpRoute, (google::longrunning::Operation const& operation),
      (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::networkservices::v1::TcpRoute>),
      ListTcpRoutes,
      (google::cloud::networkservices::v1::ListTcpRoutesRequest request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::networkservices::v1::TcpRoute>, GetTcpRoute,
      (google::cloud::networkservices::v1::GetTcpRouteRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateTcpRoute(Matcher<google::cloud::networkservices::v1::CreateTcpRouteRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::networkservices::v1::TcpRoute>>,
              CreateTcpRoute,
              (google::cloud::networkservices::v1::CreateTcpRouteRequest const&
                   request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, CreateTcpRoute(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>, CreateTcpRoute,
              (NoAwaitTag,
               google::cloud::networkservices::v1::CreateTcpRouteRequest const&
                   request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, CreateTcpRoute(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::networkservices::v1::TcpRoute>>,
              CreateTcpRoute, (google::longrunning::Operation const& operation),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateTcpRoute(Matcher<google::cloud::networkservices::v1::UpdateTcpRouteRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::networkservices::v1::TcpRoute>>,
              UpdateTcpRoute,
              (google::cloud::networkservices::v1::UpdateTcpRouteRequest const&
                   request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, UpdateTcpRoute(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>, UpdateTcpRoute,
              (NoAwaitTag,
               google::cloud::networkservices::v1::UpdateTcpRouteRequest const&
                   request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, UpdateTcpRoute(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::networkservices::v1::TcpRoute>>,
              UpdateTcpRoute, (google::longrunning::Operation const& operation),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteTcpRoute(Matcher<google::cloud::networkservices::v1::DeleteTcpRouteRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>,
      DeleteTcpRoute,
      (google::cloud::networkservices::v1::DeleteTcpRouteRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, DeleteTcpRoute(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>, DeleteTcpRoute,
              (NoAwaitTag,
               google::cloud::networkservices::v1::DeleteTcpRouteRequest const&
                   request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, DeleteTcpRoute(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>,
      DeleteTcpRoute, (google::longrunning::Operation const& operation),
      (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::networkservices::v1::TlsRoute>),
      ListTlsRoutes,
      (google::cloud::networkservices::v1::ListTlsRoutesRequest request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::networkservices::v1::TlsRoute>, GetTlsRoute,
      (google::cloud::networkservices::v1::GetTlsRouteRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateTlsRoute(Matcher<google::cloud::networkservices::v1::CreateTlsRouteRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::networkservices::v1::TlsRoute>>,
              CreateTlsRoute,
              (google::cloud::networkservices::v1::CreateTlsRouteRequest const&
                   request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, CreateTlsRoute(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>, CreateTlsRoute,
              (NoAwaitTag,
               google::cloud::networkservices::v1::CreateTlsRouteRequest const&
                   request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, CreateTlsRoute(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::networkservices::v1::TlsRoute>>,
              CreateTlsRoute, (google::longrunning::Operation const& operation),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateTlsRoute(Matcher<google::cloud::networkservices::v1::UpdateTlsRouteRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::networkservices::v1::TlsRoute>>,
              UpdateTlsRoute,
              (google::cloud::networkservices::v1::UpdateTlsRouteRequest const&
                   request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, UpdateTlsRoute(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>, UpdateTlsRoute,
              (NoAwaitTag,
               google::cloud::networkservices::v1::UpdateTlsRouteRequest const&
                   request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, UpdateTlsRoute(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::networkservices::v1::TlsRoute>>,
              UpdateTlsRoute, (google::longrunning::Operation const& operation),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteTlsRoute(Matcher<google::cloud::networkservices::v1::DeleteTlsRouteRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>,
      DeleteTlsRoute,
      (google::cloud::networkservices::v1::DeleteTlsRouteRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, DeleteTlsRoute(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>, DeleteTlsRoute,
              (NoAwaitTag,
               google::cloud::networkservices::v1::DeleteTlsRouteRequest const&
                   request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, DeleteTlsRoute(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>,
      DeleteTlsRoute, (google::longrunning::Operation const& operation),
      (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::networkservices::v1::ServiceBinding>),
      ListServiceBindings,
      (google::cloud::networkservices::v1::ListServiceBindingsRequest request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::networkservices::v1::ServiceBinding>,
      GetServiceBinding,
      (google::cloud::networkservices::v1::GetServiceBindingRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateServiceBinding(Matcher<google::cloud::networkservices::v1::CreateServiceBindingRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::networkservices::v1::ServiceBinding>>,
      CreateServiceBinding,
      (google::cloud::networkservices::v1::CreateServiceBindingRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, CreateServiceBinding(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, CreateServiceBinding,
      (NoAwaitTag,
       google::cloud::networkservices::v1::CreateServiceBindingRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateServiceBinding(Matcher<google::longrunning::Operation const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::networkservices::v1::ServiceBinding>>,
      CreateServiceBinding, (google::longrunning::Operation const& operation),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteServiceBinding(Matcher<google::cloud::networkservices::v1::DeleteServiceBindingRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>,
      DeleteServiceBinding,
      (google::cloud::networkservices::v1::DeleteServiceBindingRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, DeleteServiceBinding(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, DeleteServiceBinding,
      (NoAwaitTag,
       google::cloud::networkservices::v1::DeleteServiceBindingRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteServiceBinding(Matcher<google::longrunning::Operation const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>,
      DeleteServiceBinding, (google::longrunning::Operation const& operation),
      (override));

  MOCK_METHOD((StreamRange<google::cloud::networkservices::v1::Mesh>),
              ListMeshes,
              (google::cloud::networkservices::v1::ListMeshesRequest request),
              (override));

  MOCK_METHOD(
      StatusOr<google::cloud::networkservices::v1::Mesh>, GetMesh,
      (google::cloud::networkservices::v1::GetMeshRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateMesh(Matcher<google::cloud::networkservices::v1::CreateMeshRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::networkservices::v1::Mesh>>, CreateMesh,
      (google::cloud::networkservices::v1::CreateMeshRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, CreateMesh(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, CreateMesh,
      (NoAwaitTag,
       google::cloud::networkservices::v1::CreateMeshRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, CreateMesh(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::networkservices::v1::Mesh>>,
              CreateMesh, (google::longrunning::Operation const& operation),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateMesh(Matcher<google::cloud::networkservices::v1::UpdateMeshRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::networkservices::v1::Mesh>>, UpdateMesh,
      (google::cloud::networkservices::v1::UpdateMeshRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, UpdateMesh(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, UpdateMesh,
      (NoAwaitTag,
       google::cloud::networkservices::v1::UpdateMeshRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, UpdateMesh(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::networkservices::v1::Mesh>>,
              UpdateMesh, (google::longrunning::Operation const& operation),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteMesh(Matcher<google::cloud::networkservices::v1::DeleteMeshRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>,
      DeleteMesh,
      (google::cloud::networkservices::v1::DeleteMeshRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, DeleteMesh(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, DeleteMesh,
      (NoAwaitTag,
       google::cloud::networkservices::v1::DeleteMeshRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, DeleteMesh(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>,
      DeleteMesh, (google::longrunning::Operation const& operation),
      (override));

  MOCK_METHOD((StreamRange<google::cloud::location::Location>), ListLocations,
              (google::cloud::location::ListLocationsRequest request),
              (override));

  MOCK_METHOD(StatusOr<google::cloud::location::Location>, GetLocation,
              (google::cloud::location::GetLocationRequest const& request),
              (override));

  MOCK_METHOD(StatusOr<google::iam::v1::Policy>, SetIamPolicy,
              (google::iam::v1::SetIamPolicyRequest const& request),
              (override));

  MOCK_METHOD(StatusOr<google::iam::v1::Policy>, GetIamPolicy,
              (google::iam::v1::GetIamPolicyRequest const& request),
              (override));

  MOCK_METHOD(StatusOr<google::iam::v1::TestIamPermissionsResponse>,
              TestIamPermissions,
              (google::iam::v1::TestIamPermissionsRequest const& request),
              (override));

  MOCK_METHOD((StreamRange<google::longrunning::Operation>), ListOperations,
              (google::longrunning::ListOperationsRequest request), (override));

  MOCK_METHOD(StatusOr<google::longrunning::Operation>, GetOperation,
              (google::longrunning::GetOperationRequest const& request),
              (override));

  MOCK_METHOD(Status, DeleteOperation,
              (google::longrunning::DeleteOperationRequest const& request),
              (override));

  MOCK_METHOD(Status, CancelOperation,
              (google::longrunning::CancelOperationRequest const& request),
              (override));
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace networkservices_v1_mocks
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETWORKSERVICES_V1_MOCKS_MOCK_NETWORK_SERVICES_CONNECTION_H
