// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/networkservices/v1/network_services.proto

#include "google/cloud/networkservices/v1/internal/network_services_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace networkservices_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

NetworkServicesTracingStub::NetworkServicesTracingStub(
    std::shared_ptr<NetworkServicesStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::cloud::networkservices::v1::ListEndpointPoliciesResponse>
NetworkServicesTracingStub::ListEndpointPolicies(
    grpc::ClientContext& context, Options const& options,
    google::cloud::networkservices::v1::ListEndpointPoliciesRequest const&
        request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.networkservices.v1.NetworkServices",
                             "ListEndpointPolicies");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->ListEndpointPolicies(context, options, request));
}

StatusOr<google::cloud::networkservices::v1::EndpointPolicy>
NetworkServicesTracingStub::GetEndpointPolicy(
    grpc::ClientContext& context, Options const& options,
    google::cloud::networkservices::v1::GetEndpointPolicyRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "GetEndpointPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->GetEndpointPolicy(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
NetworkServicesTracingStub::AsyncCreateEndpointPolicy(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::networkservices::v1::CreateEndpointPolicyRequest const&
        request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.networkservices.v1.NetworkServices",
                             "CreateEndpointPolicy");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncCreateEndpointPolicy(cq, context, std::move(options),
                                             request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
NetworkServicesTracingStub::CreateEndpointPolicy(
    grpc::ClientContext& context, Options options,
    google::cloud::networkservices::v1::CreateEndpointPolicyRequest const&
        request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.networkservices.v1.NetworkServices",
                             "CreateEndpointPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->CreateEndpointPolicy(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
NetworkServicesTracingStub::AsyncUpdateEndpointPolicy(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::networkservices::v1::UpdateEndpointPolicyRequest const&
        request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.networkservices.v1.NetworkServices",
                             "UpdateEndpointPolicy");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncUpdateEndpointPolicy(cq, context, std::move(options),
                                             request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
NetworkServicesTracingStub::UpdateEndpointPolicy(
    grpc::ClientContext& context, Options options,
    google::cloud::networkservices::v1::UpdateEndpointPolicyRequest const&
        request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.networkservices.v1.NetworkServices",
                             "UpdateEndpointPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->UpdateEndpointPolicy(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
NetworkServicesTracingStub::AsyncDeleteEndpointPolicy(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::networkservices::v1::DeleteEndpointPolicyRequest const&
        request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.networkservices.v1.NetworkServices",
                             "DeleteEndpointPolicy");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncDeleteEndpointPolicy(cq, context, std::move(options),
                                             request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
NetworkServicesTracingStub::DeleteEndpointPolicy(
    grpc::ClientContext& context, Options options,
    google::cloud::networkservices::v1::DeleteEndpointPolicyRequest const&
        request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.networkservices.v1.NetworkServices",
                             "DeleteEndpointPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->DeleteEndpointPolicy(context, options, request));
}

StatusOr<google::cloud::networkservices::v1::ListGatewaysResponse>
NetworkServicesTracingStub::ListGateways(
    grpc::ClientContext& context, Options const& options,
    google::cloud::networkservices::v1::ListGatewaysRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "ListGateways");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListGateways(context, options, request));
}

StatusOr<google::cloud::networkservices::v1::Gateway>
NetworkServicesTracingStub::GetGateway(
    grpc::ClientContext& context, Options const& options,
    google::cloud::networkservices::v1::GetGatewayRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "GetGateway");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetGateway(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
NetworkServicesTracingStub::AsyncCreateGateway(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::networkservices::v1::CreateGatewayRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "CreateGateway");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncCreateGateway(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
NetworkServicesTracingStub::CreateGateway(
    grpc::ClientContext& context, Options options,
    google::cloud::networkservices::v1::CreateGatewayRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "CreateGateway");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateGateway(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
NetworkServicesTracingStub::AsyncUpdateGateway(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::networkservices::v1::UpdateGatewayRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "UpdateGateway");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncUpdateGateway(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
NetworkServicesTracingStub::UpdateGateway(
    grpc::ClientContext& context, Options options,
    google::cloud::networkservices::v1::UpdateGatewayRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "UpdateGateway");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateGateway(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
NetworkServicesTracingStub::AsyncDeleteGateway(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::networkservices::v1::DeleteGatewayRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "DeleteGateway");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncDeleteGateway(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
NetworkServicesTracingStub::DeleteGateway(
    grpc::ClientContext& context, Options options,
    google::cloud::networkservices::v1::DeleteGatewayRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "DeleteGateway");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteGateway(context, options, request));
}

StatusOr<google::cloud::networkservices::v1::ListGrpcRoutesResponse>
NetworkServicesTracingStub::ListGrpcRoutes(
    grpc::ClientContext& context, Options const& options,
    google::cloud::networkservices::v1::ListGrpcRoutesRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "ListGrpcRoutes");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListGrpcRoutes(context, options, request));
}

StatusOr<google::cloud::networkservices::v1::GrpcRoute>
NetworkServicesTracingStub::GetGrpcRoute(
    grpc::ClientContext& context, Options const& options,
    google::cloud::networkservices::v1::GetGrpcRouteRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "GetGrpcRoute");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetGrpcRoute(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
NetworkServicesTracingStub::AsyncCreateGrpcRoute(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::networkservices::v1::CreateGrpcRouteRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "CreateGrpcRoute");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCreateGrpcRoute(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
NetworkServicesTracingStub::CreateGrpcRoute(
    grpc::ClientContext& context, Options options,
    google::cloud::networkservices::v1::CreateGrpcRouteRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "CreateGrpcRoute");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateGrpcRoute(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
NetworkServicesTracingStub::AsyncUpdateGrpcRoute(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::networkservices::v1::UpdateGrpcRouteRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "UpdateGrpcRoute");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncUpdateGrpcRoute(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
NetworkServicesTracingStub::UpdateGrpcRoute(
    grpc::ClientContext& context, Options options,
    google::cloud::networkservices::v1::UpdateGrpcRouteRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "UpdateGrpcRoute");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateGrpcRoute(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
NetworkServicesTracingStub::AsyncDeleteGrpcRoute(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::networkservices::v1::DeleteGrpcRouteRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "DeleteGrpcRoute");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncDeleteGrpcRoute(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
NetworkServicesTracingStub::DeleteGrpcRoute(
    grpc::ClientContext& context, Options options,
    google::cloud::networkservices::v1::DeleteGrpcRouteRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "DeleteGrpcRoute");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteGrpcRoute(context, options, request));
}

StatusOr<google::cloud::networkservices::v1::ListHttpRoutesResponse>
NetworkServicesTracingStub::ListHttpRoutes(
    grpc::ClientContext& context, Options const& options,
    google::cloud::networkservices::v1::ListHttpRoutesRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "ListHttpRoutes");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListHttpRoutes(context, options, request));
}

StatusOr<google::cloud::networkservices::v1::HttpRoute>
NetworkServicesTracingStub::GetHttpRoute(
    grpc::ClientContext& context, Options const& options,
    google::cloud::networkservices::v1::GetHttpRouteRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "GetHttpRoute");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetHttpRoute(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
NetworkServicesTracingStub::AsyncCreateHttpRoute(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::networkservices::v1::CreateHttpRouteRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "CreateHttpRoute");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCreateHttpRoute(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
NetworkServicesTracingStub::CreateHttpRoute(
    grpc::ClientContext& context, Options options,
    google::cloud::networkservices::v1::CreateHttpRouteRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "CreateHttpRoute");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateHttpRoute(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
NetworkServicesTracingStub::AsyncUpdateHttpRoute(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::networkservices::v1::UpdateHttpRouteRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "UpdateHttpRoute");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncUpdateHttpRoute(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
NetworkServicesTracingStub::UpdateHttpRoute(
    grpc::ClientContext& context, Options options,
    google::cloud::networkservices::v1::UpdateHttpRouteRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "UpdateHttpRoute");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateHttpRoute(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
NetworkServicesTracingStub::AsyncDeleteHttpRoute(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::networkservices::v1::DeleteHttpRouteRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "DeleteHttpRoute");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncDeleteHttpRoute(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
NetworkServicesTracingStub::DeleteHttpRoute(
    grpc::ClientContext& context, Options options,
    google::cloud::networkservices::v1::DeleteHttpRouteRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "DeleteHttpRoute");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteHttpRoute(context, options, request));
}

StatusOr<google::cloud::networkservices::v1::ListTcpRoutesResponse>
NetworkServicesTracingStub::ListTcpRoutes(
    grpc::ClientContext& context, Options const& options,
    google::cloud::networkservices::v1::ListTcpRoutesRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "ListTcpRoutes");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListTcpRoutes(context, options, request));
}

StatusOr<google::cloud::networkservices::v1::TcpRoute>
NetworkServicesTracingStub::GetTcpRoute(
    grpc::ClientContext& context, Options const& options,
    google::cloud::networkservices::v1::GetTcpRouteRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "GetTcpRoute");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetTcpRoute(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
NetworkServicesTracingStub::AsyncCreateTcpRoute(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::networkservices::v1::CreateTcpRouteRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "CreateTcpRoute");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCreateTcpRoute(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
NetworkServicesTracingStub::CreateTcpRoute(
    grpc::ClientContext& context, Options options,
    google::cloud::networkservices::v1::CreateTcpRouteRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "CreateTcpRoute");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateTcpRoute(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
NetworkServicesTracingStub::AsyncUpdateTcpRoute(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::networkservices::v1::UpdateTcpRouteRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "UpdateTcpRoute");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncUpdateTcpRoute(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
NetworkServicesTracingStub::UpdateTcpRoute(
    grpc::ClientContext& context, Options options,
    google::cloud::networkservices::v1::UpdateTcpRouteRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "UpdateTcpRoute");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateTcpRoute(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
NetworkServicesTracingStub::AsyncDeleteTcpRoute(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::networkservices::v1::DeleteTcpRouteRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "DeleteTcpRoute");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncDeleteTcpRoute(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
NetworkServicesTracingStub::DeleteTcpRoute(
    grpc::ClientContext& context, Options options,
    google::cloud::networkservices::v1::DeleteTcpRouteRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "DeleteTcpRoute");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteTcpRoute(context, options, request));
}

StatusOr<google::cloud::networkservices::v1::ListTlsRoutesResponse>
NetworkServicesTracingStub::ListTlsRoutes(
    grpc::ClientContext& context, Options const& options,
    google::cloud::networkservices::v1::ListTlsRoutesRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "ListTlsRoutes");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListTlsRoutes(context, options, request));
}

StatusOr<google::cloud::networkservices::v1::TlsRoute>
NetworkServicesTracingStub::GetTlsRoute(
    grpc::ClientContext& context, Options const& options,
    google::cloud::networkservices::v1::GetTlsRouteRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "GetTlsRoute");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetTlsRoute(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
NetworkServicesTracingStub::AsyncCreateTlsRoute(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::networkservices::v1::CreateTlsRouteRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "CreateTlsRoute");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCreateTlsRoute(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
NetworkServicesTracingStub::CreateTlsRoute(
    grpc::ClientContext& context, Options options,
    google::cloud::networkservices::v1::CreateTlsRouteRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "CreateTlsRoute");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateTlsRoute(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
NetworkServicesTracingStub::AsyncUpdateTlsRoute(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::networkservices::v1::UpdateTlsRouteRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "UpdateTlsRoute");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncUpdateTlsRoute(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
NetworkServicesTracingStub::UpdateTlsRoute(
    grpc::ClientContext& context, Options options,
    google::cloud::networkservices::v1::UpdateTlsRouteRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "UpdateTlsRoute");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateTlsRoute(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
NetworkServicesTracingStub::AsyncDeleteTlsRoute(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::networkservices::v1::DeleteTlsRouteRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "DeleteTlsRoute");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncDeleteTlsRoute(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
NetworkServicesTracingStub::DeleteTlsRoute(
    grpc::ClientContext& context, Options options,
    google::cloud::networkservices::v1::DeleteTlsRouteRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "DeleteTlsRoute");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteTlsRoute(context, options, request));
}

StatusOr<google::cloud::networkservices::v1::ListServiceBindingsResponse>
NetworkServicesTracingStub::ListServiceBindings(
    grpc::ClientContext& context, Options const& options,
    google::cloud::networkservices::v1::ListServiceBindingsRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "ListServiceBindings");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->ListServiceBindings(context, options, request));
}

StatusOr<google::cloud::networkservices::v1::ServiceBinding>
NetworkServicesTracingStub::GetServiceBinding(
    grpc::ClientContext& context, Options const& options,
    google::cloud::networkservices::v1::GetServiceBindingRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "GetServiceBinding");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->GetServiceBinding(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
NetworkServicesTracingStub::AsyncCreateServiceBinding(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::networkservices::v1::CreateServiceBindingRequest const&
        request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.networkservices.v1.NetworkServices",
                             "CreateServiceBinding");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncCreateServiceBinding(cq, context, std::move(options),
                                             request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
NetworkServicesTracingStub::CreateServiceBinding(
    grpc::ClientContext& context, Options options,
    google::cloud::networkservices::v1::CreateServiceBindingRequest const&
        request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.networkservices.v1.NetworkServices",
                             "CreateServiceBinding");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->CreateServiceBinding(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
NetworkServicesTracingStub::AsyncDeleteServiceBinding(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::networkservices::v1::DeleteServiceBindingRequest const&
        request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.networkservices.v1.NetworkServices",
                             "DeleteServiceBinding");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncDeleteServiceBinding(cq, context, std::move(options),
                                             request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
NetworkServicesTracingStub::DeleteServiceBinding(
    grpc::ClientContext& context, Options options,
    google::cloud::networkservices::v1::DeleteServiceBindingRequest const&
        request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.networkservices.v1.NetworkServices",
                             "DeleteServiceBinding");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->DeleteServiceBinding(context, options, request));
}

StatusOr<google::cloud::networkservices::v1::ListMeshesResponse>
NetworkServicesTracingStub::ListMeshes(
    grpc::ClientContext& context, Options const& options,
    google::cloud::networkservices::v1::ListMeshesRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "ListMeshes");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListMeshes(context, options, request));
}

StatusOr<google::cloud::networkservices::v1::Mesh>
NetworkServicesTracingStub::GetMesh(
    grpc::ClientContext& context, Options const& options,
    google::cloud::networkservices::v1::GetMeshRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "GetMesh");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetMesh(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
NetworkServicesTracingStub::AsyncCreateMesh(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::networkservices::v1::CreateMeshRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "CreateMesh");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncCreateMesh(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> NetworkServicesTracingStub::CreateMesh(
    grpc::ClientContext& context, Options options,
    google::cloud::networkservices::v1::CreateMeshRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "CreateMesh");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateMesh(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
NetworkServicesTracingStub::AsyncUpdateMesh(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::networkservices::v1::UpdateMeshRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "UpdateMesh");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncUpdateMesh(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> NetworkServicesTracingStub::UpdateMesh(
    grpc::ClientContext& context, Options options,
    google::cloud::networkservices::v1::UpdateMeshRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "UpdateMesh");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateMesh(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
NetworkServicesTracingStub::AsyncDeleteMesh(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::networkservices::v1::DeleteMeshRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "DeleteMesh");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncDeleteMesh(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> NetworkServicesTracingStub::DeleteMesh(
    grpc::ClientContext& context, Options options,
    google::cloud::networkservices::v1::DeleteMeshRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "DeleteMesh");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteMesh(context, options, request));
}

StatusOr<google::cloud::location::ListLocationsResponse>
NetworkServicesTracingStub::ListLocations(
    grpc::ClientContext& context, Options const& options,
    google::cloud::location::ListLocationsRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "ListLocations");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListLocations(context, options, request));
}

StatusOr<google::cloud::location::Location>
NetworkServicesTracingStub::GetLocation(
    grpc::ClientContext& context, Options const& options,
    google::cloud::location::GetLocationRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "GetLocation");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetLocation(context, options, request));
}

StatusOr<google::iam::v1::Policy> NetworkServicesTracingStub::SetIamPolicy(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::SetIamPolicyRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "SetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->SetIamPolicy(context, options, request));
}

StatusOr<google::iam::v1::Policy> NetworkServicesTracingStub::GetIamPolicy(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::GetIamPolicyRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "GetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetIamPolicy(context, options, request));
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
NetworkServicesTracingStub::TestIamPermissions(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::TestIamPermissionsRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "TestIamPermissions");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->TestIamPermissions(context, options, request));
}

StatusOr<google::longrunning::ListOperationsResponse>
NetworkServicesTracingStub::ListOperations(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::ListOperationsRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "ListOperations");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListOperations(context, options, request));
}

StatusOr<google::longrunning::Operation>
NetworkServicesTracingStub::GetOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::GetOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "GetOperation");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetOperation(context, options, request));
}

Status NetworkServicesTracingStub::DeleteOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::DeleteOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "DeleteOperation");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteOperation(context, options, request));
}

Status NetworkServicesTracingStub::CancelOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.networkservices.v1.NetworkServices", "CancelOperation");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CancelOperation(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
NetworkServicesTracingStub::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.longrunning.Operations", "GetOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncGetOperation(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<Status> NetworkServicesTracingStub::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.longrunning.Operations",
                                     "CancelOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCancelOperation(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<NetworkServicesStub> MakeNetworkServicesTracingStub(
    std::shared_ptr<NetworkServicesStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<NetworkServicesTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace networkservices_v1_internal
}  // namespace cloud
}  // namespace google
