// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/networkservices/v1/dep.proto

#include "google/cloud/networkservices/v1/internal/dep_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace networkservices_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

DepServiceTracingConnection::DepServiceTracingConnection(
    std::shared_ptr<networkservices_v1::DepServiceConnection> child)
    : child_(std::move(child)) {}

StreamRange<google::cloud::networkservices::v1::LbTrafficExtension>
DepServiceTracingConnection::ListLbTrafficExtensions(
    google::cloud::networkservices::v1::ListLbTrafficExtensionsRequest
        request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::DepServiceConnection::ListLbTrafficExtensions");
  internal::OTelScope scope(span);
  auto sr = child_->ListLbTrafficExtensions(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::networkservices::v1::LbTrafficExtension>(std::move(span),
                                                              std::move(sr));
}

StatusOr<google::cloud::networkservices::v1::LbTrafficExtension>
DepServiceTracingConnection::GetLbTrafficExtension(
    google::cloud::networkservices::v1::GetLbTrafficExtensionRequest const&
        request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::DepServiceConnection::GetLbTrafficExtension");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetLbTrafficExtension(request));
}

future<StatusOr<google::cloud::networkservices::v1::LbTrafficExtension>>
DepServiceTracingConnection::CreateLbTrafficExtension(
    google::cloud::networkservices::v1::CreateLbTrafficExtensionRequest const&
        request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::DepServiceConnection::CreateLbTrafficExtension");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateLbTrafficExtension(request));
}

StatusOr<google::longrunning::Operation>
DepServiceTracingConnection::CreateLbTrafficExtension(
    NoAwaitTag,
    google::cloud::networkservices::v1::CreateLbTrafficExtensionRequest const&
        request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::DepServiceConnection::CreateLbTrafficExtension");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->CreateLbTrafficExtension(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::networkservices::v1::LbTrafficExtension>>
DepServiceTracingConnection::CreateLbTrafficExtension(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "networkservices_v1::DepServiceConnection::CreateLbTrafficExtension");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateLbTrafficExtension(operation));
}

future<StatusOr<google::cloud::networkservices::v1::LbTrafficExtension>>
DepServiceTracingConnection::UpdateLbTrafficExtension(
    google::cloud::networkservices::v1::UpdateLbTrafficExtensionRequest const&
        request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::DepServiceConnection::UpdateLbTrafficExtension");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UpdateLbTrafficExtension(request));
}

StatusOr<google::longrunning::Operation>
DepServiceTracingConnection::UpdateLbTrafficExtension(
    NoAwaitTag,
    google::cloud::networkservices::v1::UpdateLbTrafficExtensionRequest const&
        request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::DepServiceConnection::UpdateLbTrafficExtension");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->UpdateLbTrafficExtension(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::networkservices::v1::LbTrafficExtension>>
DepServiceTracingConnection::UpdateLbTrafficExtension(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "networkservices_v1::DepServiceConnection::UpdateLbTrafficExtension");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UpdateLbTrafficExtension(operation));
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
DepServiceTracingConnection::DeleteLbTrafficExtension(
    google::cloud::networkservices::v1::DeleteLbTrafficExtensionRequest const&
        request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::DepServiceConnection::DeleteLbTrafficExtension");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteLbTrafficExtension(request));
}

StatusOr<google::longrunning::Operation>
DepServiceTracingConnection::DeleteLbTrafficExtension(
    NoAwaitTag,
    google::cloud::networkservices::v1::DeleteLbTrafficExtensionRequest const&
        request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::DepServiceConnection::DeleteLbTrafficExtension");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->DeleteLbTrafficExtension(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
DepServiceTracingConnection::DeleteLbTrafficExtension(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "networkservices_v1::DepServiceConnection::DeleteLbTrafficExtension");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteLbTrafficExtension(operation));
}

StreamRange<google::cloud::networkservices::v1::LbRouteExtension>
DepServiceTracingConnection::ListLbRouteExtensions(
    google::cloud::networkservices::v1::ListLbRouteExtensionsRequest request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::DepServiceConnection::ListLbRouteExtensions");
  internal::OTelScope scope(span);
  auto sr = child_->ListLbRouteExtensions(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::networkservices::v1::LbRouteExtension>(std::move(span),
                                                            std::move(sr));
}

StatusOr<google::cloud::networkservices::v1::LbRouteExtension>
DepServiceTracingConnection::GetLbRouteExtension(
    google::cloud::networkservices::v1::GetLbRouteExtensionRequest const&
        request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::DepServiceConnection::GetLbRouteExtension");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetLbRouteExtension(request));
}

future<StatusOr<google::cloud::networkservices::v1::LbRouteExtension>>
DepServiceTracingConnection::CreateLbRouteExtension(
    google::cloud::networkservices::v1::CreateLbRouteExtensionRequest const&
        request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::DepServiceConnection::CreateLbRouteExtension");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateLbRouteExtension(request));
}

StatusOr<google::longrunning::Operation>
DepServiceTracingConnection::CreateLbRouteExtension(
    NoAwaitTag,
    google::cloud::networkservices::v1::CreateLbRouteExtensionRequest const&
        request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::DepServiceConnection::CreateLbRouteExtension");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->CreateLbRouteExtension(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::networkservices::v1::LbRouteExtension>>
DepServiceTracingConnection::CreateLbRouteExtension(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "networkservices_v1::DepServiceConnection::CreateLbRouteExtension");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateLbRouteExtension(operation));
}

future<StatusOr<google::cloud::networkservices::v1::LbRouteExtension>>
DepServiceTracingConnection::UpdateLbRouteExtension(
    google::cloud::networkservices::v1::UpdateLbRouteExtensionRequest const&
        request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::DepServiceConnection::UpdateLbRouteExtension");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UpdateLbRouteExtension(request));
}

StatusOr<google::longrunning::Operation>
DepServiceTracingConnection::UpdateLbRouteExtension(
    NoAwaitTag,
    google::cloud::networkservices::v1::UpdateLbRouteExtensionRequest const&
        request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::DepServiceConnection::UpdateLbRouteExtension");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->UpdateLbRouteExtension(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::networkservices::v1::LbRouteExtension>>
DepServiceTracingConnection::UpdateLbRouteExtension(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "networkservices_v1::DepServiceConnection::UpdateLbRouteExtension");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UpdateLbRouteExtension(operation));
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
DepServiceTracingConnection::DeleteLbRouteExtension(
    google::cloud::networkservices::v1::DeleteLbRouteExtensionRequest const&
        request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::DepServiceConnection::DeleteLbRouteExtension");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteLbRouteExtension(request));
}

StatusOr<google::longrunning::Operation>
DepServiceTracingConnection::DeleteLbRouteExtension(
    NoAwaitTag,
    google::cloud::networkservices::v1::DeleteLbRouteExtensionRequest const&
        request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::DepServiceConnection::DeleteLbRouteExtension");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->DeleteLbRouteExtension(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
DepServiceTracingConnection::DeleteLbRouteExtension(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "networkservices_v1::DepServiceConnection::DeleteLbRouteExtension");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteLbRouteExtension(operation));
}

StreamRange<google::cloud::location::Location>
DepServiceTracingConnection::ListLocations(
    google::cloud::location::ListLocationsRequest request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::DepServiceConnection::ListLocations");
  internal::OTelScope scope(span);
  auto sr = child_->ListLocations(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::location::Location>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::location::Location>
DepServiceTracingConnection::GetLocation(
    google::cloud::location::GetLocationRequest const& request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::DepServiceConnection::GetLocation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetLocation(request));
}

StatusOr<google::iam::v1::Policy> DepServiceTracingConnection::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::DepServiceConnection::SetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->SetIamPolicy(request));
}

StatusOr<google::iam::v1::Policy> DepServiceTracingConnection::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const& request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::DepServiceConnection::GetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetIamPolicy(request));
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
DepServiceTracingConnection::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const& request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::DepServiceConnection::TestIamPermissions");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->TestIamPermissions(request));
}

StreamRange<google::longrunning::Operation>
DepServiceTracingConnection::ListOperations(
    google::longrunning::ListOperationsRequest request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::DepServiceConnection::ListOperations");
  internal::OTelScope scope(span);
  auto sr = child_->ListOperations(std::move(request));
  return internal::MakeTracedStreamRange<google::longrunning::Operation>(
      std::move(span), std::move(sr));
}

StatusOr<google::longrunning::Operation>
DepServiceTracingConnection::GetOperation(
    google::longrunning::GetOperationRequest const& request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::DepServiceConnection::GetOperation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetOperation(request));
}

Status DepServiceTracingConnection::DeleteOperation(
    google::longrunning::DeleteOperationRequest const& request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::DepServiceConnection::DeleteOperation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteOperation(request));
}

Status DepServiceTracingConnection::CancelOperation(
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::DepServiceConnection::CancelOperation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CancelOperation(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<networkservices_v1::DepServiceConnection>
MakeDepServiceTracingConnection(
    std::shared_ptr<networkservices_v1::DepServiceConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<DepServiceTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace networkservices_v1_internal
}  // namespace cloud
}  // namespace google
