// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/networkservices/v1/dep.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETWORKSERVICES_V1_INTERNAL_DEP_AUTH_DECORATOR_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETWORKSERVICES_V1_INTERNAL_DEP_AUTH_DECORATOR_H

#include "google/cloud/networkservices/v1/internal/dep_stub.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>
#include <set>
#include <string>

namespace google {
namespace cloud {
namespace networkservices_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class DepServiceAuth : public DepServiceStub {
 public:
  ~DepServiceAuth() override = default;
  DepServiceAuth(
      std::shared_ptr<google::cloud::internal::GrpcAuthenticationStrategy> auth,
      std::shared_ptr<DepServiceStub> child);

  StatusOr<google::cloud::networkservices::v1::ListLbTrafficExtensionsResponse>
  ListLbTrafficExtensions(
      grpc::ClientContext& context, Options const& options,
      google::cloud::networkservices::v1::ListLbTrafficExtensionsRequest const&
          request) override;

  StatusOr<google::cloud::networkservices::v1::LbTrafficExtension>
  GetLbTrafficExtension(
      grpc::ClientContext& context, Options const& options,
      google::cloud::networkservices::v1::GetLbTrafficExtensionRequest const&
          request) override;

  future<StatusOr<google::longrunning::Operation>>
  AsyncCreateLbTrafficExtension(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::networkservices::v1::CreateLbTrafficExtensionRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> CreateLbTrafficExtension(
      grpc::ClientContext& context, Options options,
      google::cloud::networkservices::v1::CreateLbTrafficExtensionRequest const&
          request) override;

  future<StatusOr<google::longrunning::Operation>>
  AsyncUpdateLbTrafficExtension(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::networkservices::v1::UpdateLbTrafficExtensionRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> UpdateLbTrafficExtension(
      grpc::ClientContext& context, Options options,
      google::cloud::networkservices::v1::UpdateLbTrafficExtensionRequest const&
          request) override;

  future<StatusOr<google::longrunning::Operation>>
  AsyncDeleteLbTrafficExtension(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::networkservices::v1::DeleteLbTrafficExtensionRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> DeleteLbTrafficExtension(
      grpc::ClientContext& context, Options options,
      google::cloud::networkservices::v1::DeleteLbTrafficExtensionRequest const&
          request) override;

  StatusOr<google::cloud::networkservices::v1::ListLbRouteExtensionsResponse>
  ListLbRouteExtensions(
      grpc::ClientContext& context, Options const& options,
      google::cloud::networkservices::v1::ListLbRouteExtensionsRequest const&
          request) override;

  StatusOr<google::cloud::networkservices::v1::LbRouteExtension>
  GetLbRouteExtension(
      grpc::ClientContext& context, Options const& options,
      google::cloud::networkservices::v1::GetLbRouteExtensionRequest const&
          request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncCreateLbRouteExtension(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::networkservices::v1::CreateLbRouteExtensionRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> CreateLbRouteExtension(
      grpc::ClientContext& context, Options options,
      google::cloud::networkservices::v1::CreateLbRouteExtensionRequest const&
          request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncUpdateLbRouteExtension(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::networkservices::v1::UpdateLbRouteExtensionRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> UpdateLbRouteExtension(
      grpc::ClientContext& context, Options options,
      google::cloud::networkservices::v1::UpdateLbRouteExtensionRequest const&
          request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncDeleteLbRouteExtension(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::networkservices::v1::DeleteLbRouteExtensionRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> DeleteLbRouteExtension(
      grpc::ClientContext& context, Options options,
      google::cloud::networkservices::v1::DeleteLbRouteExtensionRequest const&
          request) override;

  StatusOr<google::cloud::location::ListLocationsResponse> ListLocations(
      grpc::ClientContext& context, Options const& options,
      google::cloud::location::ListLocationsRequest const& request) override;

  StatusOr<google::cloud::location::Location> GetLocation(
      grpc::ClientContext& context, Options const& options,
      google::cloud::location::GetLocationRequest const& request) override;

  StatusOr<google::iam::v1::Policy> SetIamPolicy(
      grpc::ClientContext& context, Options const& options,
      google::iam::v1::SetIamPolicyRequest const& request) override;

  StatusOr<google::iam::v1::Policy> GetIamPolicy(
      grpc::ClientContext& context, Options const& options,
      google::iam::v1::GetIamPolicyRequest const& request) override;

  StatusOr<google::iam::v1::TestIamPermissionsResponse> TestIamPermissions(
      grpc::ClientContext& context, Options const& options,
      google::iam::v1::TestIamPermissionsRequest const& request) override;

  StatusOr<google::longrunning::ListOperationsResponse> ListOperations(
      grpc::ClientContext& context, Options const& options,
      google::longrunning::ListOperationsRequest const& request) override;

  StatusOr<google::longrunning::Operation> GetOperation(
      grpc::ClientContext& context, Options const& options,
      google::longrunning::GetOperationRequest const& request) override;

  Status DeleteOperation(
      grpc::ClientContext& context, Options const& options,
      google::longrunning::DeleteOperationRequest const& request) override;

  Status CancelOperation(
      grpc::ClientContext& context, Options const& options,
      google::longrunning::CancelOperationRequest const& request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncGetOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::longrunning::GetOperationRequest const& request) override;

  future<Status> AsyncCancelOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::longrunning::CancelOperationRequest const& request) override;

 private:
  std::shared_ptr<google::cloud::internal::GrpcAuthenticationStrategy> auth_;
  std::shared_ptr<DepServiceStub> child_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace networkservices_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETWORKSERVICES_V1_INTERNAL_DEP_AUTH_DECORATOR_H
