// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/networkservices/v1/dep.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETWORKSERVICES_V1_DEP_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETWORKSERVICES_V1_DEP_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <google/cloud/location/locations.grpc.pb.h>
#include <google/cloud/networkservices/v1/dep.grpc.pb.h>
#include <google/iam/v1/iam_policy.grpc.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace networkservices_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class DepServiceConnectionIdempotencyPolicy {
 public:
  virtual ~DepServiceConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<DepServiceConnectionIdempotencyPolicy> clone() const;

  virtual google::cloud::Idempotency ListLbTrafficExtensions(
      google::cloud::networkservices::v1::ListLbTrafficExtensionsRequest
          request);

  virtual google::cloud::Idempotency GetLbTrafficExtension(
      google::cloud::networkservices::v1::GetLbTrafficExtensionRequest const&
          request);

  virtual google::cloud::Idempotency CreateLbTrafficExtension(
      google::cloud::networkservices::v1::CreateLbTrafficExtensionRequest const&
          request);

  virtual google::cloud::Idempotency UpdateLbTrafficExtension(
      google::cloud::networkservices::v1::UpdateLbTrafficExtensionRequest const&
          request);

  virtual google::cloud::Idempotency DeleteLbTrafficExtension(
      google::cloud::networkservices::v1::DeleteLbTrafficExtensionRequest const&
          request);

  virtual google::cloud::Idempotency ListLbRouteExtensions(
      google::cloud::networkservices::v1::ListLbRouteExtensionsRequest request);

  virtual google::cloud::Idempotency GetLbRouteExtension(
      google::cloud::networkservices::v1::GetLbRouteExtensionRequest const&
          request);

  virtual google::cloud::Idempotency CreateLbRouteExtension(
      google::cloud::networkservices::v1::CreateLbRouteExtensionRequest const&
          request);

  virtual google::cloud::Idempotency UpdateLbRouteExtension(
      google::cloud::networkservices::v1::UpdateLbRouteExtensionRequest const&
          request);

  virtual google::cloud::Idempotency DeleteLbRouteExtension(
      google::cloud::networkservices::v1::DeleteLbRouteExtensionRequest const&
          request);

  virtual google::cloud::Idempotency ListLocations(
      google::cloud::location::ListLocationsRequest request);

  virtual google::cloud::Idempotency GetLocation(
      google::cloud::location::GetLocationRequest const& request);

  virtual google::cloud::Idempotency SetIamPolicy(
      google::iam::v1::SetIamPolicyRequest const& request);

  virtual google::cloud::Idempotency GetIamPolicy(
      google::iam::v1::GetIamPolicyRequest const& request);

  virtual google::cloud::Idempotency TestIamPermissions(
      google::iam::v1::TestIamPermissionsRequest const& request);

  virtual google::cloud::Idempotency ListOperations(
      google::longrunning::ListOperationsRequest request);

  virtual google::cloud::Idempotency GetOperation(
      google::longrunning::GetOperationRequest const& request);

  virtual google::cloud::Idempotency DeleteOperation(
      google::longrunning::DeleteOperationRequest const& request);

  virtual google::cloud::Idempotency CancelOperation(
      google::longrunning::CancelOperationRequest const& request);
};

std::unique_ptr<DepServiceConnectionIdempotencyPolicy>
MakeDefaultDepServiceConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace networkservices_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETWORKSERVICES_V1_DEP_CONNECTION_IDEMPOTENCY_POLICY_H
