// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/networkservices/v1/dep.proto

#include "google/cloud/networkservices/v1/dep_connection.h"
#include "google/cloud/networkservices/v1/dep_options.h"
#include "google/cloud/networkservices/v1/internal/dep_connection_impl.h"
#include "google/cloud/networkservices/v1/internal/dep_option_defaults.h"
#include "google/cloud/networkservices/v1/internal/dep_stub_factory.h"
#include "google/cloud/networkservices/v1/internal/dep_tracing_connection.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace networkservices_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DepServiceConnection::~DepServiceConnection() = default;

StreamRange<google::cloud::networkservices::v1::LbTrafficExtension>
DepServiceConnection::ListLbTrafficExtensions(
    google::cloud::networkservices::v1::
        ListLbTrafficExtensionsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::networkservices::v1::LbTrafficExtension>>();
}

StatusOr<google::cloud::networkservices::v1::LbTrafficExtension>
DepServiceConnection::GetLbTrafficExtension(
    google::cloud::networkservices::v1::GetLbTrafficExtensionRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::networkservices::v1::LbTrafficExtension>>
DepServiceConnection::CreateLbTrafficExtension(
    google::cloud::networkservices::v1::
        CreateLbTrafficExtensionRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkservices::v1::LbTrafficExtension>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
DepServiceConnection::CreateLbTrafficExtension(
    NoAwaitTag, google::cloud::networkservices::v1::
                    CreateLbTrafficExtensionRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkservices::v1::LbTrafficExtension>>
DepServiceConnection::CreateLbTrafficExtension(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkservices::v1::LbTrafficExtension>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkservices::v1::LbTrafficExtension>>
DepServiceConnection::UpdateLbTrafficExtension(
    google::cloud::networkservices::v1::
        UpdateLbTrafficExtensionRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkservices::v1::LbTrafficExtension>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
DepServiceConnection::UpdateLbTrafficExtension(
    NoAwaitTag, google::cloud::networkservices::v1::
                    UpdateLbTrafficExtensionRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkservices::v1::LbTrafficExtension>>
DepServiceConnection::UpdateLbTrafficExtension(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkservices::v1::LbTrafficExtension>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
DepServiceConnection::DeleteLbTrafficExtension(
    google::cloud::networkservices::v1::
        DeleteLbTrafficExtensionRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkservices::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
DepServiceConnection::DeleteLbTrafficExtension(
    NoAwaitTag, google::cloud::networkservices::v1::
                    DeleteLbTrafficExtensionRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
DepServiceConnection::DeleteLbTrafficExtension(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkservices::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::networkservices::v1::LbRouteExtension>
DepServiceConnection::ListLbRouteExtensions(
    google::cloud::networkservices::v1::
        ListLbRouteExtensionsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::networkservices::v1::LbRouteExtension>>();
}

StatusOr<google::cloud::networkservices::v1::LbRouteExtension>
DepServiceConnection::GetLbRouteExtension(
    google::cloud::networkservices::v1::GetLbRouteExtensionRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::networkservices::v1::LbRouteExtension>>
DepServiceConnection::CreateLbRouteExtension(
    google::cloud::networkservices::v1::CreateLbRouteExtensionRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkservices::v1::LbRouteExtension>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
DepServiceConnection::CreateLbRouteExtension(
    NoAwaitTag,
    google::cloud::networkservices::v1::CreateLbRouteExtensionRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkservices::v1::LbRouteExtension>>
DepServiceConnection::CreateLbRouteExtension(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkservices::v1::LbRouteExtension>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkservices::v1::LbRouteExtension>>
DepServiceConnection::UpdateLbRouteExtension(
    google::cloud::networkservices::v1::UpdateLbRouteExtensionRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkservices::v1::LbRouteExtension>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
DepServiceConnection::UpdateLbRouteExtension(
    NoAwaitTag,
    google::cloud::networkservices::v1::UpdateLbRouteExtensionRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkservices::v1::LbRouteExtension>>
DepServiceConnection::UpdateLbRouteExtension(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkservices::v1::LbRouteExtension>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
DepServiceConnection::DeleteLbRouteExtension(
    google::cloud::networkservices::v1::DeleteLbRouteExtensionRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkservices::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
DepServiceConnection::DeleteLbRouteExtension(
    NoAwaitTag,
    google::cloud::networkservices::v1::DeleteLbRouteExtensionRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
DepServiceConnection::DeleteLbRouteExtension(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkservices::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::location::Location>
DepServiceConnection::ListLocations(
    google::cloud::location::
        ListLocationsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::location::Location>>();
}

StatusOr<google::cloud::location::Location> DepServiceConnection::GetLocation(
    google::cloud::location::GetLocationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::Policy> DepServiceConnection::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::Policy> DepServiceConnection::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
DepServiceConnection::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::longrunning::Operation>
DepServiceConnection::ListOperations(
    google::longrunning::
        ListOperationsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::longrunning::Operation>>();
}

StatusOr<google::longrunning::Operation> DepServiceConnection::GetOperation(
    google::longrunning::GetOperationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status DepServiceConnection::DeleteOperation(
    google::longrunning::DeleteOperationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status DepServiceConnection::CancelOperation(
    google::longrunning::CancelOperationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<DepServiceConnection> MakeDepServiceConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 DepServicePolicyOptionList>(options, __func__);
  options =
      networkservices_v1_internal::DepServiceDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = networkservices_v1_internal::CreateDefaultDepServiceStub(
      std::move(auth), options);
  return networkservices_v1_internal::MakeDepServiceTracingConnection(
      std::make_shared<networkservices_v1_internal::DepServiceConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace networkservices_v1
}  // namespace cloud
}  // namespace google
