// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/networkservices/v1/dep.proto

#include "google/cloud/networkservices/v1/dep_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace networkservices_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DepServiceClient::DepServiceClient(
    std::shared_ptr<DepServiceConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
DepServiceClient::~DepServiceClient() = default;

StreamRange<google::cloud::networkservices::v1::LbTrafficExtension>
DepServiceClient::ListLbTrafficExtensions(std::string const& parent,
                                          Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkservices::v1::ListLbTrafficExtensionsRequest request;
  request.set_parent(parent);
  return connection_->ListLbTrafficExtensions(request);
}

StreamRange<google::cloud::networkservices::v1::LbTrafficExtension>
DepServiceClient::ListLbTrafficExtensions(
    google::cloud::networkservices::v1::ListLbTrafficExtensionsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListLbTrafficExtensions(std::move(request));
}

StatusOr<google::cloud::networkservices::v1::LbTrafficExtension>
DepServiceClient::GetLbTrafficExtension(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkservices::v1::GetLbTrafficExtensionRequest request;
  request.set_name(name);
  return connection_->GetLbTrafficExtension(request);
}

StatusOr<google::cloud::networkservices::v1::LbTrafficExtension>
DepServiceClient::GetLbTrafficExtension(
    google::cloud::networkservices::v1::GetLbTrafficExtensionRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetLbTrafficExtension(request);
}

future<StatusOr<google::cloud::networkservices::v1::LbTrafficExtension>>
DepServiceClient::CreateLbTrafficExtension(
    std::string const& parent,
    google::cloud::networkservices::v1::LbTrafficExtension const&
        lb_traffic_extension,
    std::string const& lb_traffic_extension_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkservices::v1::CreateLbTrafficExtensionRequest request;
  request.set_parent(parent);
  *request.mutable_lb_traffic_extension() = lb_traffic_extension;
  request.set_lb_traffic_extension_id(lb_traffic_extension_id);
  return connection_->CreateLbTrafficExtension(request);
}

StatusOr<google::longrunning::Operation>
DepServiceClient::CreateLbTrafficExtension(
    NoAwaitTag, std::string const& parent,
    google::cloud::networkservices::v1::LbTrafficExtension const&
        lb_traffic_extension,
    std::string const& lb_traffic_extension_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkservices::v1::CreateLbTrafficExtensionRequest request;
  request.set_parent(parent);
  *request.mutable_lb_traffic_extension() = lb_traffic_extension;
  request.set_lb_traffic_extension_id(lb_traffic_extension_id);
  return connection_->CreateLbTrafficExtension(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::networkservices::v1::LbTrafficExtension>>
DepServiceClient::CreateLbTrafficExtension(
    google::cloud::networkservices::v1::CreateLbTrafficExtensionRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateLbTrafficExtension(request);
}

StatusOr<google::longrunning::Operation>
DepServiceClient::CreateLbTrafficExtension(
    NoAwaitTag,
    google::cloud::networkservices::v1::CreateLbTrafficExtensionRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateLbTrafficExtension(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::networkservices::v1::LbTrafficExtension>>
DepServiceClient::CreateLbTrafficExtension(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateLbTrafficExtension(operation);
}

future<StatusOr<google::cloud::networkservices::v1::LbTrafficExtension>>
DepServiceClient::UpdateLbTrafficExtension(
    google::cloud::networkservices::v1::LbTrafficExtension const&
        lb_traffic_extension,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkservices::v1::UpdateLbTrafficExtensionRequest request;
  *request.mutable_lb_traffic_extension() = lb_traffic_extension;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateLbTrafficExtension(request);
}

StatusOr<google::longrunning::Operation>
DepServiceClient::UpdateLbTrafficExtension(
    NoAwaitTag,
    google::cloud::networkservices::v1::LbTrafficExtension const&
        lb_traffic_extension,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkservices::v1::UpdateLbTrafficExtensionRequest request;
  *request.mutable_lb_traffic_extension() = lb_traffic_extension;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateLbTrafficExtension(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::networkservices::v1::LbTrafficExtension>>
DepServiceClient::UpdateLbTrafficExtension(
    google::cloud::networkservices::v1::UpdateLbTrafficExtensionRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateLbTrafficExtension(request);
}

StatusOr<google::longrunning::Operation>
DepServiceClient::UpdateLbTrafficExtension(
    NoAwaitTag,
    google::cloud::networkservices::v1::UpdateLbTrafficExtensionRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateLbTrafficExtension(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::networkservices::v1::LbTrafficExtension>>
DepServiceClient::UpdateLbTrafficExtension(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateLbTrafficExtension(operation);
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
DepServiceClient::DeleteLbTrafficExtension(std::string const& name,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkservices::v1::DeleteLbTrafficExtensionRequest request;
  request.set_name(name);
  return connection_->DeleteLbTrafficExtension(request);
}

StatusOr<google::longrunning::Operation>
DepServiceClient::DeleteLbTrafficExtension(NoAwaitTag, std::string const& name,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkservices::v1::DeleteLbTrafficExtensionRequest request;
  request.set_name(name);
  return connection_->DeleteLbTrafficExtension(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
DepServiceClient::DeleteLbTrafficExtension(
    google::cloud::networkservices::v1::DeleteLbTrafficExtensionRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteLbTrafficExtension(request);
}

StatusOr<google::longrunning::Operation>
DepServiceClient::DeleteLbTrafficExtension(
    NoAwaitTag,
    google::cloud::networkservices::v1::DeleteLbTrafficExtensionRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteLbTrafficExtension(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
DepServiceClient::DeleteLbTrafficExtension(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteLbTrafficExtension(operation);
}

StreamRange<google::cloud::networkservices::v1::LbRouteExtension>
DepServiceClient::ListLbRouteExtensions(std::string const& parent,
                                        Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkservices::v1::ListLbRouteExtensionsRequest request;
  request.set_parent(parent);
  return connection_->ListLbRouteExtensions(request);
}

StreamRange<google::cloud::networkservices::v1::LbRouteExtension>
DepServiceClient::ListLbRouteExtensions(
    google::cloud::networkservices::v1::ListLbRouteExtensionsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListLbRouteExtensions(std::move(request));
}

StatusOr<google::cloud::networkservices::v1::LbRouteExtension>
DepServiceClient::GetLbRouteExtension(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkservices::v1::GetLbRouteExtensionRequest request;
  request.set_name(name);
  return connection_->GetLbRouteExtension(request);
}

StatusOr<google::cloud::networkservices::v1::LbRouteExtension>
DepServiceClient::GetLbRouteExtension(
    google::cloud::networkservices::v1::GetLbRouteExtensionRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetLbRouteExtension(request);
}

future<StatusOr<google::cloud::networkservices::v1::LbRouteExtension>>
DepServiceClient::CreateLbRouteExtension(
    std::string const& parent,
    google::cloud::networkservices::v1::LbRouteExtension const&
        lb_route_extension,
    std::string const& lb_route_extension_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkservices::v1::CreateLbRouteExtensionRequest request;
  request.set_parent(parent);
  *request.mutable_lb_route_extension() = lb_route_extension;
  request.set_lb_route_extension_id(lb_route_extension_id);
  return connection_->CreateLbRouteExtension(request);
}

StatusOr<google::longrunning::Operation>
DepServiceClient::CreateLbRouteExtension(
    NoAwaitTag, std::string const& parent,
    google::cloud::networkservices::v1::LbRouteExtension const&
        lb_route_extension,
    std::string const& lb_route_extension_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkservices::v1::CreateLbRouteExtensionRequest request;
  request.set_parent(parent);
  *request.mutable_lb_route_extension() = lb_route_extension;
  request.set_lb_route_extension_id(lb_route_extension_id);
  return connection_->CreateLbRouteExtension(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::networkservices::v1::LbRouteExtension>>
DepServiceClient::CreateLbRouteExtension(
    google::cloud::networkservices::v1::CreateLbRouteExtensionRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateLbRouteExtension(request);
}

StatusOr<google::longrunning::Operation>
DepServiceClient::CreateLbRouteExtension(
    NoAwaitTag,
    google::cloud::networkservices::v1::CreateLbRouteExtensionRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateLbRouteExtension(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::networkservices::v1::LbRouteExtension>>
DepServiceClient::CreateLbRouteExtension(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateLbRouteExtension(operation);
}

future<StatusOr<google::cloud::networkservices::v1::LbRouteExtension>>
DepServiceClient::UpdateLbRouteExtension(
    google::cloud::networkservices::v1::LbRouteExtension const&
        lb_route_extension,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkservices::v1::UpdateLbRouteExtensionRequest request;
  *request.mutable_lb_route_extension() = lb_route_extension;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateLbRouteExtension(request);
}

StatusOr<google::longrunning::Operation>
DepServiceClient::UpdateLbRouteExtension(
    NoAwaitTag,
    google::cloud::networkservices::v1::LbRouteExtension const&
        lb_route_extension,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkservices::v1::UpdateLbRouteExtensionRequest request;
  *request.mutable_lb_route_extension() = lb_route_extension;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateLbRouteExtension(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::networkservices::v1::LbRouteExtension>>
DepServiceClient::UpdateLbRouteExtension(
    google::cloud::networkservices::v1::UpdateLbRouteExtensionRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateLbRouteExtension(request);
}

StatusOr<google::longrunning::Operation>
DepServiceClient::UpdateLbRouteExtension(
    NoAwaitTag,
    google::cloud::networkservices::v1::UpdateLbRouteExtensionRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateLbRouteExtension(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::networkservices::v1::LbRouteExtension>>
DepServiceClient::UpdateLbRouteExtension(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateLbRouteExtension(operation);
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
DepServiceClient::DeleteLbRouteExtension(std::string const& name,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkservices::v1::DeleteLbRouteExtensionRequest request;
  request.set_name(name);
  return connection_->DeleteLbRouteExtension(request);
}

StatusOr<google::longrunning::Operation>
DepServiceClient::DeleteLbRouteExtension(NoAwaitTag, std::string const& name,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkservices::v1::DeleteLbRouteExtensionRequest request;
  request.set_name(name);
  return connection_->DeleteLbRouteExtension(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
DepServiceClient::DeleteLbRouteExtension(
    google::cloud::networkservices::v1::DeleteLbRouteExtensionRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteLbRouteExtension(request);
}

StatusOr<google::longrunning::Operation>
DepServiceClient::DeleteLbRouteExtension(
    NoAwaitTag,
    google::cloud::networkservices::v1::DeleteLbRouteExtensionRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteLbRouteExtension(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
DepServiceClient::DeleteLbRouteExtension(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteLbRouteExtension(operation);
}

StreamRange<google::cloud::location::Location> DepServiceClient::ListLocations(
    google::cloud::location::ListLocationsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListLocations(std::move(request));
}

StatusOr<google::cloud::location::Location> DepServiceClient::GetLocation(
    google::cloud::location::GetLocationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetLocation(request);
}

StatusOr<google::iam::v1::Policy> DepServiceClient::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetIamPolicy(request);
}

StatusOr<google::iam::v1::Policy> DepServiceClient::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetIamPolicy(request);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
DepServiceClient::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->TestIamPermissions(request);
}

StreamRange<google::longrunning::Operation> DepServiceClient::ListOperations(
    std::string const& name, std::string const& filter, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::ListOperationsRequest request;
  request.set_name(name);
  request.set_filter(filter);
  return connection_->ListOperations(request);
}

StreamRange<google::longrunning::Operation> DepServiceClient::ListOperations(
    google::longrunning::ListOperationsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListOperations(std::move(request));
}

StatusOr<google::longrunning::Operation> DepServiceClient::GetOperation(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::GetOperationRequest request;
  request.set_name(name);
  return connection_->GetOperation(request);
}

StatusOr<google::longrunning::Operation> DepServiceClient::GetOperation(
    google::longrunning::GetOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetOperation(request);
}

Status DepServiceClient::DeleteOperation(std::string const& name,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::DeleteOperationRequest request;
  request.set_name(name);
  return connection_->DeleteOperation(request);
}

Status DepServiceClient::DeleteOperation(
    google::longrunning::DeleteOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteOperation(request);
}

Status DepServiceClient::CancelOperation(std::string const& name,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::CancelOperationRequest request;
  request.set_name(name);
  return connection_->CancelOperation(request);
}

Status DepServiceClient::CancelOperation(
    google::longrunning::CancelOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CancelOperation(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace networkservices_v1
}  // namespace cloud
}  // namespace google
