// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/networksecurity/v1/network_security.proto

#include "google/cloud/networksecurity/v1/internal/network_security_connection_impl.h"
#include "google/cloud/networksecurity/v1/internal/network_security_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace networksecurity_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<networksecurity_v1::NetworkSecurityRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<networksecurity_v1::NetworkSecurityRetryPolicyOption>()
      ->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options.get<networksecurity_v1::NetworkSecurityBackoffPolicyOption>()
      ->clone();
}

std::unique_ptr<networksecurity_v1::NetworkSecurityConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<networksecurity_v1::
               NetworkSecurityConnectionIdempotencyPolicyOption>()
      ->clone();
}

std::unique_ptr<PollingPolicy> polling_policy(Options const& options) {
  return options.get<networksecurity_v1::NetworkSecurityPollingPolicyOption>()
      ->clone();
}

}  // namespace

NetworkSecurityConnectionImpl::NetworkSecurityConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<networksecurity_v1_internal::NetworkSecurityStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(std::move(options),
                                      NetworkSecurityConnection::options())) {}

StreamRange<google::cloud::networksecurity::v1::AuthorizationPolicy>
NetworkSecurityConnectionImpl::ListAuthorizationPolicies(
    google::cloud::networksecurity::v1::ListAuthorizationPoliciesRequest
        request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListAuthorizationPolicies(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::networksecurity::v1::AuthorizationPolicy>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<networksecurity_v1::NetworkSecurityRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::networksecurity::v1::
              ListAuthorizationPoliciesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::networksecurity::v1::
                       ListAuthorizationPoliciesRequest const& request) {
              return stub->ListAuthorizationPolicies(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::networksecurity::v1::ListAuthorizationPoliciesResponse
             r) {
        std::vector<google::cloud::networksecurity::v1::AuthorizationPolicy>
            result(r.authorization_policies().size());
        auto& messages = *r.mutable_authorization_policies();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::networksecurity::v1::AuthorizationPolicy>
NetworkSecurityConnectionImpl::GetAuthorizationPolicy(
    google::cloud::networksecurity::v1::GetAuthorizationPolicyRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetAuthorizationPolicy(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::networksecurity::v1::
                 GetAuthorizationPolicyRequest const& request) {
        return stub_->GetAuthorizationPolicy(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::networksecurity::v1::AuthorizationPolicy>>
NetworkSecurityConnectionImpl::CreateAuthorizationPolicy(
    google::cloud::networksecurity::v1::CreateAuthorizationPolicyRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->CreateAuthorizationPolicy(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::networksecurity::v1::AuthorizationPolicy>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::cloud::networksecurity::v1::
                         CreateAuthorizationPolicyRequest const& request) {
        return stub->AsyncCreateAuthorizationPolicy(
            cq, std::move(context), std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::networksecurity::v1::AuthorizationPolicy>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
NetworkSecurityConnectionImpl::CreateAuthorizationPolicy(
    NoAwaitTag,
    google::cloud::networksecurity::v1::CreateAuthorizationPolicyRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateAuthorizationPolicy(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::networksecurity::v1::
                 CreateAuthorizationPolicyRequest const& request) {
        return stub_->CreateAuthorizationPolicy(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::networksecurity::v1::AuthorizationPolicy>>
NetworkSecurityConnectionImpl::CreateAuthorizationPolicy(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::networksecurity::v1::
                   OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::networksecurity::v1::AuthorizationPolicy>>(
        internal::InvalidArgumentError(
            "operation does not correspond to CreateAuthorizationPolicy",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::networksecurity::v1::AuthorizationPolicy>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::networksecurity::v1::AuthorizationPolicy>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::networksecurity::v1::AuthorizationPolicy>>
NetworkSecurityConnectionImpl::UpdateAuthorizationPolicy(
    google::cloud::networksecurity::v1::UpdateAuthorizationPolicyRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->UpdateAuthorizationPolicy(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::networksecurity::v1::AuthorizationPolicy>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::cloud::networksecurity::v1::
                         UpdateAuthorizationPolicyRequest const& request) {
        return stub->AsyncUpdateAuthorizationPolicy(
            cq, std::move(context), std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::networksecurity::v1::AuthorizationPolicy>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
NetworkSecurityConnectionImpl::UpdateAuthorizationPolicy(
    NoAwaitTag,
    google::cloud::networksecurity::v1::UpdateAuthorizationPolicyRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateAuthorizationPolicy(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::networksecurity::v1::
                 UpdateAuthorizationPolicyRequest const& request) {
        return stub_->UpdateAuthorizationPolicy(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::networksecurity::v1::AuthorizationPolicy>>
NetworkSecurityConnectionImpl::UpdateAuthorizationPolicy(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::networksecurity::v1::
                   OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::networksecurity::v1::AuthorizationPolicy>>(
        internal::InvalidArgumentError(
            "operation does not correspond to UpdateAuthorizationPolicy",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::networksecurity::v1::AuthorizationPolicy>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::networksecurity::v1::AuthorizationPolicy>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::networksecurity::v1::OperationMetadata>>
NetworkSecurityConnectionImpl::DeleteAuthorizationPolicy(
    google::cloud::networksecurity::v1::DeleteAuthorizationPolicyRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->DeleteAuthorizationPolicy(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::networksecurity::v1::OperationMetadata>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::cloud::networksecurity::v1::
                         DeleteAuthorizationPolicyRequest const& request) {
        return stub->AsyncDeleteAuthorizationPolicy(
            cq, std::move(context), std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::networksecurity::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
NetworkSecurityConnectionImpl::DeleteAuthorizationPolicy(
    NoAwaitTag,
    google::cloud::networksecurity::v1::DeleteAuthorizationPolicyRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteAuthorizationPolicy(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::networksecurity::v1::
                 DeleteAuthorizationPolicyRequest const& request) {
        return stub_->DeleteAuthorizationPolicy(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::networksecurity::v1::OperationMetadata>>
NetworkSecurityConnectionImpl::DeleteAuthorizationPolicy(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::networksecurity::v1::
                   OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::networksecurity::v1::OperationMetadata>>(
        internal::InvalidArgumentError(
            "operation does not correspond to DeleteAuthorizationPolicy",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::networksecurity::v1::OperationMetadata>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::networksecurity::v1::OperationMetadata>,
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::networksecurity::v1::ServerTlsPolicy>
NetworkSecurityConnectionImpl::ListServerTlsPolicies(
    google::cloud::networksecurity::v1::ListServerTlsPoliciesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListServerTlsPolicies(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::networksecurity::v1::ServerTlsPolicy>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<networksecurity_v1::NetworkSecurityRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options, google::cloud::networksecurity::v1::
                                      ListServerTlsPoliciesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::networksecurity::v1::
                       ListServerTlsPoliciesRequest const& request) {
              return stub->ListServerTlsPolicies(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::networksecurity::v1::ListServerTlsPoliciesResponse r) {
        std::vector<google::cloud::networksecurity::v1::ServerTlsPolicy> result(
            r.server_tls_policies().size());
        auto& messages = *r.mutable_server_tls_policies();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::networksecurity::v1::ServerTlsPolicy>
NetworkSecurityConnectionImpl::GetServerTlsPolicy(
    google::cloud::networksecurity::v1::GetServerTlsPolicyRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetServerTlsPolicy(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::networksecurity::v1::GetServerTlsPolicyRequest const&
              request) {
        return stub_->GetServerTlsPolicy(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::networksecurity::v1::ServerTlsPolicy>>
NetworkSecurityConnectionImpl::CreateServerTlsPolicy(
    google::cloud::networksecurity::v1::CreateServerTlsPolicyRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->CreateServerTlsPolicy(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::networksecurity::v1::ServerTlsPolicy>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::cloud::networksecurity::v1::
                         CreateServerTlsPolicyRequest const& request) {
        return stub->AsyncCreateServerTlsPolicy(cq, std::move(context),
                                                std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::networksecurity::v1::ServerTlsPolicy>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
NetworkSecurityConnectionImpl::CreateServerTlsPolicy(
    NoAwaitTag,
    google::cloud::networksecurity::v1::CreateServerTlsPolicyRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateServerTlsPolicy(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::networksecurity::v1::
                 CreateServerTlsPolicyRequest const& request) {
        return stub_->CreateServerTlsPolicy(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::networksecurity::v1::ServerTlsPolicy>>
NetworkSecurityConnectionImpl::CreateServerTlsPolicy(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::networksecurity::v1::
                   OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::networksecurity::v1::ServerTlsPolicy>>(
        internal::InvalidArgumentError(
            "operation does not correspond to CreateServerTlsPolicy",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::networksecurity::v1::ServerTlsPolicy>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::networksecurity::v1::ServerTlsPolicy>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::networksecurity::v1::ServerTlsPolicy>>
NetworkSecurityConnectionImpl::UpdateServerTlsPolicy(
    google::cloud::networksecurity::v1::UpdateServerTlsPolicyRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->UpdateServerTlsPolicy(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::networksecurity::v1::ServerTlsPolicy>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::cloud::networksecurity::v1::
                         UpdateServerTlsPolicyRequest const& request) {
        return stub->AsyncUpdateServerTlsPolicy(cq, std::move(context),
                                                std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::networksecurity::v1::ServerTlsPolicy>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
NetworkSecurityConnectionImpl::UpdateServerTlsPolicy(
    NoAwaitTag,
    google::cloud::networksecurity::v1::UpdateServerTlsPolicyRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateServerTlsPolicy(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::networksecurity::v1::
                 UpdateServerTlsPolicyRequest const& request) {
        return stub_->UpdateServerTlsPolicy(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::networksecurity::v1::ServerTlsPolicy>>
NetworkSecurityConnectionImpl::UpdateServerTlsPolicy(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::networksecurity::v1::
                   OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::networksecurity::v1::ServerTlsPolicy>>(
        internal::InvalidArgumentError(
            "operation does not correspond to UpdateServerTlsPolicy",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::networksecurity::v1::ServerTlsPolicy>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::networksecurity::v1::ServerTlsPolicy>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::networksecurity::v1::OperationMetadata>>
NetworkSecurityConnectionImpl::DeleteServerTlsPolicy(
    google::cloud::networksecurity::v1::DeleteServerTlsPolicyRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->DeleteServerTlsPolicy(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::networksecurity::v1::OperationMetadata>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::cloud::networksecurity::v1::
                         DeleteServerTlsPolicyRequest const& request) {
        return stub->AsyncDeleteServerTlsPolicy(cq, std::move(context),
                                                std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::networksecurity::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
NetworkSecurityConnectionImpl::DeleteServerTlsPolicy(
    NoAwaitTag,
    google::cloud::networksecurity::v1::DeleteServerTlsPolicyRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteServerTlsPolicy(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::networksecurity::v1::
                 DeleteServerTlsPolicyRequest const& request) {
        return stub_->DeleteServerTlsPolicy(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::networksecurity::v1::OperationMetadata>>
NetworkSecurityConnectionImpl::DeleteServerTlsPolicy(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::networksecurity::v1::
                   OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::networksecurity::v1::OperationMetadata>>(
        internal::InvalidArgumentError(
            "operation does not correspond to DeleteServerTlsPolicy",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::networksecurity::v1::OperationMetadata>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::networksecurity::v1::OperationMetadata>,
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::networksecurity::v1::ClientTlsPolicy>
NetworkSecurityConnectionImpl::ListClientTlsPolicies(
    google::cloud::networksecurity::v1::ListClientTlsPoliciesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListClientTlsPolicies(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::networksecurity::v1::ClientTlsPolicy>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<networksecurity_v1::NetworkSecurityRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options, google::cloud::networksecurity::v1::
                                      ListClientTlsPoliciesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::networksecurity::v1::
                       ListClientTlsPoliciesRequest const& request) {
              return stub->ListClientTlsPolicies(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::networksecurity::v1::ListClientTlsPoliciesResponse r) {
        std::vector<google::cloud::networksecurity::v1::ClientTlsPolicy> result(
            r.client_tls_policies().size());
        auto& messages = *r.mutable_client_tls_policies();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::networksecurity::v1::ClientTlsPolicy>
NetworkSecurityConnectionImpl::GetClientTlsPolicy(
    google::cloud::networksecurity::v1::GetClientTlsPolicyRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetClientTlsPolicy(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::networksecurity::v1::GetClientTlsPolicyRequest const&
              request) {
        return stub_->GetClientTlsPolicy(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::networksecurity::v1::ClientTlsPolicy>>
NetworkSecurityConnectionImpl::CreateClientTlsPolicy(
    google::cloud::networksecurity::v1::CreateClientTlsPolicyRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->CreateClientTlsPolicy(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::networksecurity::v1::ClientTlsPolicy>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::cloud::networksecurity::v1::
                         CreateClientTlsPolicyRequest const& request) {
        return stub->AsyncCreateClientTlsPolicy(cq, std::move(context),
                                                std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::networksecurity::v1::ClientTlsPolicy>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
NetworkSecurityConnectionImpl::CreateClientTlsPolicy(
    NoAwaitTag,
    google::cloud::networksecurity::v1::CreateClientTlsPolicyRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateClientTlsPolicy(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::networksecurity::v1::
                 CreateClientTlsPolicyRequest const& request) {
        return stub_->CreateClientTlsPolicy(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::networksecurity::v1::ClientTlsPolicy>>
NetworkSecurityConnectionImpl::CreateClientTlsPolicy(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::networksecurity::v1::
                   OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::networksecurity::v1::ClientTlsPolicy>>(
        internal::InvalidArgumentError(
            "operation does not correspond to CreateClientTlsPolicy",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::networksecurity::v1::ClientTlsPolicy>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::networksecurity::v1::ClientTlsPolicy>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::networksecurity::v1::ClientTlsPolicy>>
NetworkSecurityConnectionImpl::UpdateClientTlsPolicy(
    google::cloud::networksecurity::v1::UpdateClientTlsPolicyRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->UpdateClientTlsPolicy(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::networksecurity::v1::ClientTlsPolicy>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::cloud::networksecurity::v1::
                         UpdateClientTlsPolicyRequest const& request) {
        return stub->AsyncUpdateClientTlsPolicy(cq, std::move(context),
                                                std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::networksecurity::v1::ClientTlsPolicy>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
NetworkSecurityConnectionImpl::UpdateClientTlsPolicy(
    NoAwaitTag,
    google::cloud::networksecurity::v1::UpdateClientTlsPolicyRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateClientTlsPolicy(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::networksecurity::v1::
                 UpdateClientTlsPolicyRequest const& request) {
        return stub_->UpdateClientTlsPolicy(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::networksecurity::v1::ClientTlsPolicy>>
NetworkSecurityConnectionImpl::UpdateClientTlsPolicy(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::networksecurity::v1::
                   OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::networksecurity::v1::ClientTlsPolicy>>(
        internal::InvalidArgumentError(
            "operation does not correspond to UpdateClientTlsPolicy",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::networksecurity::v1::ClientTlsPolicy>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::networksecurity::v1::ClientTlsPolicy>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::networksecurity::v1::OperationMetadata>>
NetworkSecurityConnectionImpl::DeleteClientTlsPolicy(
    google::cloud::networksecurity::v1::DeleteClientTlsPolicyRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->DeleteClientTlsPolicy(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::networksecurity::v1::OperationMetadata>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::cloud::networksecurity::v1::
                         DeleteClientTlsPolicyRequest const& request) {
        return stub->AsyncDeleteClientTlsPolicy(cq, std::move(context),
                                                std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::networksecurity::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
NetworkSecurityConnectionImpl::DeleteClientTlsPolicy(
    NoAwaitTag,
    google::cloud::networksecurity::v1::DeleteClientTlsPolicyRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteClientTlsPolicy(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::networksecurity::v1::
                 DeleteClientTlsPolicyRequest const& request) {
        return stub_->DeleteClientTlsPolicy(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::networksecurity::v1::OperationMetadata>>
NetworkSecurityConnectionImpl::DeleteClientTlsPolicy(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::networksecurity::v1::
                   OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::networksecurity::v1::OperationMetadata>>(
        internal::InvalidArgumentError(
            "operation does not correspond to DeleteClientTlsPolicy",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::networksecurity::v1::OperationMetadata>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::networksecurity::v1::OperationMetadata>,
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::location::Location>
NetworkSecurityConnectionImpl::ListLocations(
    google::cloud::location::ListLocationsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListLocations(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::location::Location>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<networksecurity_v1::NetworkSecurityRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::location::ListLocationsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context, Options const& options,
                google::cloud::location::ListLocationsRequest const& request) {
              return stub->ListLocations(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::location::ListLocationsResponse r) {
        std::vector<google::cloud::location::Location> result(
            r.locations().size());
        auto& messages = *r.mutable_locations();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::location::Location>
NetworkSecurityConnectionImpl::GetLocation(
    google::cloud::location::GetLocationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetLocation(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::location::GetLocationRequest const& request) {
        return stub_->GetLocation(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::iam::v1::Policy> NetworkSecurityConnectionImpl::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->SetIamPolicy(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::iam::v1::SetIamPolicyRequest const& request) {
        return stub_->SetIamPolicy(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::iam::v1::Policy> NetworkSecurityConnectionImpl::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetIamPolicy(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::iam::v1::GetIamPolicyRequest const& request) {
        return stub_->GetIamPolicy(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
NetworkSecurityConnectionImpl::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->TestIamPermissions(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::iam::v1::TestIamPermissionsRequest const& request) {
        return stub_->TestIamPermissions(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::longrunning::Operation>
NetworkSecurityConnectionImpl::ListOperations(
    google::longrunning::ListOperationsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListOperations(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::longrunning::Operation>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<networksecurity_v1::NetworkSecurityRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::longrunning::ListOperationsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::longrunning::ListOperationsRequest const& request) {
              return stub->ListOperations(context, options, request);
            },
            options, r, function_name);
      },
      [](google::longrunning::ListOperationsResponse r) {
        std::vector<google::longrunning::Operation> result(
            r.operations().size());
        auto& messages = *r.mutable_operations();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::longrunning::Operation>
NetworkSecurityConnectionImpl::GetOperation(
    google::longrunning::GetOperationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetOperation(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::longrunning::GetOperationRequest const& request) {
        return stub_->GetOperation(context, options, request);
      },
      *current, request, __func__);
}

Status NetworkSecurityConnectionImpl::DeleteOperation(
    google::longrunning::DeleteOperationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteOperation(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::longrunning::DeleteOperationRequest const& request) {
        return stub_->DeleteOperation(context, options, request);
      },
      *current, request, __func__);
}

Status NetworkSecurityConnectionImpl::CancelOperation(
    google::longrunning::CancelOperationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CancelOperation(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::longrunning::CancelOperationRequest const& request) {
        return stub_->CancelOperation(context, options, request);
      },
      *current, request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace networksecurity_v1_internal
}  // namespace cloud
}  // namespace google
