// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/networkmanagement/v1/reachability.proto

#include "google/cloud/networkmanagement/v1/reachability_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace networkmanagement_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ReachabilityServiceClient::ReachabilityServiceClient(
    std::shared_ptr<ReachabilityServiceConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
ReachabilityServiceClient::~ReachabilityServiceClient() = default;

StreamRange<google::cloud::networkmanagement::v1::ConnectivityTest>
ReachabilityServiceClient::ListConnectivityTests(std::string const& parent,
                                                 Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkmanagement::v1::ListConnectivityTestsRequest request;
  request.set_parent(parent);
  return connection_->ListConnectivityTests(request);
}

StreamRange<google::cloud::networkmanagement::v1::ConnectivityTest>
ReachabilityServiceClient::ListConnectivityTests(
    google::cloud::networkmanagement::v1::ListConnectivityTestsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListConnectivityTests(std::move(request));
}

StatusOr<google::cloud::networkmanagement::v1::ConnectivityTest>
ReachabilityServiceClient::GetConnectivityTest(std::string const& name,
                                               Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkmanagement::v1::GetConnectivityTestRequest request;
  request.set_name(name);
  return connection_->GetConnectivityTest(request);
}

StatusOr<google::cloud::networkmanagement::v1::ConnectivityTest>
ReachabilityServiceClient::GetConnectivityTest(
    google::cloud::networkmanagement::v1::GetConnectivityTestRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetConnectivityTest(request);
}

future<StatusOr<google::cloud::networkmanagement::v1::ConnectivityTest>>
ReachabilityServiceClient::CreateConnectivityTest(
    std::string const& parent, std::string const& test_id,
    google::cloud::networkmanagement::v1::ConnectivityTest const& resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkmanagement::v1::CreateConnectivityTestRequest request;
  request.set_parent(parent);
  request.set_test_id(test_id);
  *request.mutable_resource() = resource;
  return connection_->CreateConnectivityTest(request);
}

StatusOr<google::longrunning::Operation>
ReachabilityServiceClient::CreateConnectivityTest(
    NoAwaitTag, std::string const& parent, std::string const& test_id,
    google::cloud::networkmanagement::v1::ConnectivityTest const& resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkmanagement::v1::CreateConnectivityTestRequest request;
  request.set_parent(parent);
  request.set_test_id(test_id);
  *request.mutable_resource() = resource;
  return connection_->CreateConnectivityTest(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::networkmanagement::v1::ConnectivityTest>>
ReachabilityServiceClient::CreateConnectivityTest(
    google::cloud::networkmanagement::v1::CreateConnectivityTestRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateConnectivityTest(request);
}

StatusOr<google::longrunning::Operation>
ReachabilityServiceClient::CreateConnectivityTest(
    NoAwaitTag,
    google::cloud::networkmanagement::v1::CreateConnectivityTestRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateConnectivityTest(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::networkmanagement::v1::ConnectivityTest>>
ReachabilityServiceClient::CreateConnectivityTest(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateConnectivityTest(operation);
}

future<StatusOr<google::cloud::networkmanagement::v1::ConnectivityTest>>
ReachabilityServiceClient::UpdateConnectivityTest(
    google::protobuf::FieldMask const& update_mask,
    google::cloud::networkmanagement::v1::ConnectivityTest const& resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkmanagement::v1::UpdateConnectivityTestRequest request;
  *request.mutable_update_mask() = update_mask;
  *request.mutable_resource() = resource;
  return connection_->UpdateConnectivityTest(request);
}

StatusOr<google::longrunning::Operation>
ReachabilityServiceClient::UpdateConnectivityTest(
    NoAwaitTag, google::protobuf::FieldMask const& update_mask,
    google::cloud::networkmanagement::v1::ConnectivityTest const& resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkmanagement::v1::UpdateConnectivityTestRequest request;
  *request.mutable_update_mask() = update_mask;
  *request.mutable_resource() = resource;
  return connection_->UpdateConnectivityTest(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::networkmanagement::v1::ConnectivityTest>>
ReachabilityServiceClient::UpdateConnectivityTest(
    google::cloud::networkmanagement::v1::UpdateConnectivityTestRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateConnectivityTest(request);
}

StatusOr<google::longrunning::Operation>
ReachabilityServiceClient::UpdateConnectivityTest(
    NoAwaitTag,
    google::cloud::networkmanagement::v1::UpdateConnectivityTestRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateConnectivityTest(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::networkmanagement::v1::ConnectivityTest>>
ReachabilityServiceClient::UpdateConnectivityTest(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateConnectivityTest(operation);
}

future<StatusOr<google::cloud::networkmanagement::v1::ConnectivityTest>>
ReachabilityServiceClient::RerunConnectivityTest(
    google::cloud::networkmanagement::v1::RerunConnectivityTestRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RerunConnectivityTest(request);
}

StatusOr<google::longrunning::Operation>
ReachabilityServiceClient::RerunConnectivityTest(
    NoAwaitTag,
    google::cloud::networkmanagement::v1::RerunConnectivityTestRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RerunConnectivityTest(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::networkmanagement::v1::ConnectivityTest>>
ReachabilityServiceClient::RerunConnectivityTest(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RerunConnectivityTest(operation);
}

future<StatusOr<google::cloud::networkmanagement::v1::OperationMetadata>>
ReachabilityServiceClient::DeleteConnectivityTest(std::string const& name,
                                                  Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkmanagement::v1::DeleteConnectivityTestRequest request;
  request.set_name(name);
  return connection_->DeleteConnectivityTest(request);
}

StatusOr<google::longrunning::Operation>
ReachabilityServiceClient::DeleteConnectivityTest(NoAwaitTag,
                                                  std::string const& name,
                                                  Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkmanagement::v1::DeleteConnectivityTestRequest request;
  request.set_name(name);
  return connection_->DeleteConnectivityTest(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::networkmanagement::v1::OperationMetadata>>
ReachabilityServiceClient::DeleteConnectivityTest(
    google::cloud::networkmanagement::v1::DeleteConnectivityTestRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteConnectivityTest(request);
}

StatusOr<google::longrunning::Operation>
ReachabilityServiceClient::DeleteConnectivityTest(
    NoAwaitTag,
    google::cloud::networkmanagement::v1::DeleteConnectivityTestRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteConnectivityTest(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::networkmanagement::v1::OperationMetadata>>
ReachabilityServiceClient::DeleteConnectivityTest(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteConnectivityTest(operation);
}

StreamRange<google::cloud::location::Location>
ReachabilityServiceClient::ListLocations(
    google::cloud::location::ListLocationsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListLocations(std::move(request));
}

StatusOr<google::cloud::location::Location>
ReachabilityServiceClient::GetLocation(
    google::cloud::location::GetLocationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetLocation(request);
}

StatusOr<google::iam::v1::Policy> ReachabilityServiceClient::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetIamPolicy(request);
}

StatusOr<google::iam::v1::Policy> ReachabilityServiceClient::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetIamPolicy(request);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
ReachabilityServiceClient::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->TestIamPermissions(request);
}

StreamRange<google::longrunning::Operation>
ReachabilityServiceClient::ListOperations(std::string const& name,
                                          std::string const& filter,
                                          Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::ListOperationsRequest request;
  request.set_name(name);
  request.set_filter(filter);
  return connection_->ListOperations(request);
}

StreamRange<google::longrunning::Operation>
ReachabilityServiceClient::ListOperations(
    google::longrunning::ListOperationsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListOperations(std::move(request));
}

StatusOr<google::longrunning::Operation>
ReachabilityServiceClient::GetOperation(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::GetOperationRequest request;
  request.set_name(name);
  return connection_->GetOperation(request);
}

StatusOr<google::longrunning::Operation>
ReachabilityServiceClient::GetOperation(
    google::longrunning::GetOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetOperation(request);
}

Status ReachabilityServiceClient::DeleteOperation(std::string const& name,
                                                  Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::DeleteOperationRequest request;
  request.set_name(name);
  return connection_->DeleteOperation(request);
}

Status ReachabilityServiceClient::DeleteOperation(
    google::longrunning::DeleteOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteOperation(request);
}

Status ReachabilityServiceClient::CancelOperation(std::string const& name,
                                                  Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::CancelOperationRequest request;
  request.set_name(name);
  return connection_->CancelOperation(request);
}

Status ReachabilityServiceClient::CancelOperation(
    google::longrunning::CancelOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CancelOperation(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace networkmanagement_v1
}  // namespace cloud
}  // namespace google
