// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/networkconnectivity/v1/policy_based_routing.proto

#include "google/cloud/networkconnectivity/v1/policy_based_routing_connection.h"
#include "google/cloud/networkconnectivity/v1/internal/policy_based_routing_connection_impl.h"
#include "google/cloud/networkconnectivity/v1/internal/policy_based_routing_option_defaults.h"
#include "google/cloud/networkconnectivity/v1/internal/policy_based_routing_stub_factory.h"
#include "google/cloud/networkconnectivity/v1/internal/policy_based_routing_tracing_connection.h"
#include "google/cloud/networkconnectivity/v1/policy_based_routing_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace networkconnectivity_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

PolicyBasedRoutingServiceConnection::~PolicyBasedRoutingServiceConnection() =
    default;

StreamRange<google::cloud::networkconnectivity::v1::PolicyBasedRoute>
PolicyBasedRoutingServiceConnection::ListPolicyBasedRoutes(
    google::cloud::networkconnectivity::v1::
        ListPolicyBasedRoutesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::networkconnectivity::v1::PolicyBasedRoute>>();
}

StatusOr<google::cloud::networkconnectivity::v1::PolicyBasedRoute>
PolicyBasedRoutingServiceConnection::GetPolicyBasedRoute(
    google::cloud::networkconnectivity::v1::GetPolicyBasedRouteRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::networkconnectivity::v1::PolicyBasedRoute>>
PolicyBasedRoutingServiceConnection::CreatePolicyBasedRoute(
    google::cloud::networkconnectivity::v1::
        CreatePolicyBasedRouteRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkconnectivity::v1::PolicyBasedRoute>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
PolicyBasedRoutingServiceConnection::CreatePolicyBasedRoute(
    NoAwaitTag, google::cloud::networkconnectivity::v1::
                    CreatePolicyBasedRouteRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkconnectivity::v1::PolicyBasedRoute>>
PolicyBasedRoutingServiceConnection::CreatePolicyBasedRoute(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkconnectivity::v1::PolicyBasedRoute>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkconnectivity::v1::OperationMetadata>>
PolicyBasedRoutingServiceConnection::DeletePolicyBasedRoute(
    google::cloud::networkconnectivity::v1::
        DeletePolicyBasedRouteRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkconnectivity::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
PolicyBasedRoutingServiceConnection::DeletePolicyBasedRoute(
    NoAwaitTag, google::cloud::networkconnectivity::v1::
                    DeletePolicyBasedRouteRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::networkconnectivity::v1::OperationMetadata>>
PolicyBasedRoutingServiceConnection::DeletePolicyBasedRoute(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::networkconnectivity::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::location::Location>
PolicyBasedRoutingServiceConnection::ListLocations(
    google::cloud::location::
        ListLocationsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::location::Location>>();
}

StatusOr<google::cloud::location::Location>
PolicyBasedRoutingServiceConnection::GetLocation(
    google::cloud::location::GetLocationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::Policy>
PolicyBasedRoutingServiceConnection::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::Policy>
PolicyBasedRoutingServiceConnection::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
PolicyBasedRoutingServiceConnection::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::longrunning::Operation>
PolicyBasedRoutingServiceConnection::ListOperations(
    google::longrunning::
        ListOperationsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::longrunning::Operation>>();
}

StatusOr<google::longrunning::Operation>
PolicyBasedRoutingServiceConnection::GetOperation(
    google::longrunning::GetOperationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status PolicyBasedRoutingServiceConnection::DeleteOperation(
    google::longrunning::DeleteOperationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status PolicyBasedRoutingServiceConnection::CancelOperation(
    google::longrunning::CancelOperationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<PolicyBasedRoutingServiceConnection>
MakePolicyBasedRoutingServiceConnection(Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 PolicyBasedRoutingServicePolicyOptionList>(
      options, __func__);
  options =
      networkconnectivity_v1_internal::PolicyBasedRoutingServiceDefaultOptions(
          std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = networkconnectivity_v1_internal::
      CreateDefaultPolicyBasedRoutingServiceStub(std::move(auth), options);
  return networkconnectivity_v1_internal::
      MakePolicyBasedRoutingServiceTracingConnection(
          std::make_shared<networkconnectivity_v1_internal::
                               PolicyBasedRoutingServiceConnectionImpl>(
              std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace networkconnectivity_v1
}  // namespace cloud
}  // namespace google
