// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/networkconnectivity/v1/policy_based_routing.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETWORKCONNECTIVITY_V1_INTERNAL_POLICY_BASED_ROUTING_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETWORKCONNECTIVITY_V1_INTERNAL_POLICY_BASED_ROUTING_TRACING_CONNECTION_H

#include "google/cloud/networkconnectivity/v1/policy_based_routing_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace networkconnectivity_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class PolicyBasedRoutingServiceTracingConnection
    : public networkconnectivity_v1::PolicyBasedRoutingServiceConnection {
 public:
  ~PolicyBasedRoutingServiceTracingConnection() override = default;

  explicit PolicyBasedRoutingServiceTracingConnection(
      std::shared_ptr<
          networkconnectivity_v1::PolicyBasedRoutingServiceConnection>
          child);

  Options options() override { return child_->options(); }

  StreamRange<google::cloud::networkconnectivity::v1::PolicyBasedRoute>
  ListPolicyBasedRoutes(
      google::cloud::networkconnectivity::v1::ListPolicyBasedRoutesRequest
          request) override;

  StatusOr<google::cloud::networkconnectivity::v1::PolicyBasedRoute>
  GetPolicyBasedRoute(
      google::cloud::networkconnectivity::v1::GetPolicyBasedRouteRequest const&
          request) override;

  future<StatusOr<google::cloud::networkconnectivity::v1::PolicyBasedRoute>>
  CreatePolicyBasedRoute(
      google::cloud::networkconnectivity::v1::
          CreatePolicyBasedRouteRequest const& request) override;

  StatusOr<google::longrunning::Operation> CreatePolicyBasedRoute(
      NoAwaitTag, google::cloud::networkconnectivity::v1::
                      CreatePolicyBasedRouteRequest const& request) override;

  future<StatusOr<google::cloud::networkconnectivity::v1::PolicyBasedRoute>>
  CreatePolicyBasedRoute(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::networkconnectivity::v1::OperationMetadata>>
  DeletePolicyBasedRoute(
      google::cloud::networkconnectivity::v1::
          DeletePolicyBasedRouteRequest const& request) override;

  StatusOr<google::longrunning::Operation> DeletePolicyBasedRoute(
      NoAwaitTag, google::cloud::networkconnectivity::v1::
                      DeletePolicyBasedRouteRequest const& request) override;

  future<StatusOr<google::cloud::networkconnectivity::v1::OperationMetadata>>
  DeletePolicyBasedRoute(
      google::longrunning::Operation const& operation) override;

  StreamRange<google::cloud::location::Location> ListLocations(
      google::cloud::location::ListLocationsRequest request) override;

  StatusOr<google::cloud::location::Location> GetLocation(
      google::cloud::location::GetLocationRequest const& request) override;

  StatusOr<google::iam::v1::Policy> SetIamPolicy(
      google::iam::v1::SetIamPolicyRequest const& request) override;

  StatusOr<google::iam::v1::Policy> GetIamPolicy(
      google::iam::v1::GetIamPolicyRequest const& request) override;

  StatusOr<google::iam::v1::TestIamPermissionsResponse> TestIamPermissions(
      google::iam::v1::TestIamPermissionsRequest const& request) override;

  StreamRange<google::longrunning::Operation> ListOperations(
      google::longrunning::ListOperationsRequest request) override;

  StatusOr<google::longrunning::Operation> GetOperation(
      google::longrunning::GetOperationRequest const& request) override;

  Status DeleteOperation(
      google::longrunning::DeleteOperationRequest const& request) override;

  Status CancelOperation(
      google::longrunning::CancelOperationRequest const& request) override;

 private:
  std::shared_ptr<networkconnectivity_v1::PolicyBasedRoutingServiceConnection>
      child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<networkconnectivity_v1::PolicyBasedRoutingServiceConnection>
MakePolicyBasedRoutingServiceTracingConnection(
    std::shared_ptr<networkconnectivity_v1::PolicyBasedRoutingServiceConnection>
        conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace networkconnectivity_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETWORKCONNECTIVITY_V1_INTERNAL_POLICY_BASED_ROUTING_TRACING_CONNECTION_H
