// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/networkconnectivity/v1/hub.proto

#include "google/cloud/networkconnectivity/v1/internal/hub_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace networkconnectivity_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

HubServiceTracingConnection::HubServiceTracingConnection(
    std::shared_ptr<networkconnectivity_v1::HubServiceConnection> child)
    : child_(std::move(child)) {}

StreamRange<google::cloud::networkconnectivity::v1::Hub>
HubServiceTracingConnection::ListHubs(
    google::cloud::networkconnectivity::v1::ListHubsRequest request) {
  auto span = internal::MakeSpan(
      "networkconnectivity_v1::HubServiceConnection::ListHubs");
  internal::OTelScope scope(span);
  auto sr = child_->ListHubs(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::networkconnectivity::v1::Hub>(std::move(span),
                                                   std::move(sr));
}

StatusOr<google::cloud::networkconnectivity::v1::Hub>
HubServiceTracingConnection::GetHub(
    google::cloud::networkconnectivity::v1::GetHubRequest const& request) {
  auto span = internal::MakeSpan(
      "networkconnectivity_v1::HubServiceConnection::GetHub");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetHub(request));
}

future<StatusOr<google::cloud::networkconnectivity::v1::Hub>>
HubServiceTracingConnection::CreateHub(
    google::cloud::networkconnectivity::v1::CreateHubRequest const& request) {
  auto span = internal::MakeSpan(
      "networkconnectivity_v1::HubServiceConnection::CreateHub");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateHub(request));
}

StatusOr<google::longrunning::Operation> HubServiceTracingConnection::CreateHub(
    NoAwaitTag,
    google::cloud::networkconnectivity::v1::CreateHubRequest const& request) {
  auto span = internal::MakeSpan(
      "networkconnectivity_v1::HubServiceConnection::CreateHub");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->CreateHub(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::networkconnectivity::v1::Hub>>
HubServiceTracingConnection::CreateHub(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "networkconnectivity_v1::HubServiceConnection::CreateHub");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateHub(operation));
}

future<StatusOr<google::cloud::networkconnectivity::v1::Hub>>
HubServiceTracingConnection::UpdateHub(
    google::cloud::networkconnectivity::v1::UpdateHubRequest const& request) {
  auto span = internal::MakeSpan(
      "networkconnectivity_v1::HubServiceConnection::UpdateHub");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateHub(request));
}

StatusOr<google::longrunning::Operation> HubServiceTracingConnection::UpdateHub(
    NoAwaitTag,
    google::cloud::networkconnectivity::v1::UpdateHubRequest const& request) {
  auto span = internal::MakeSpan(
      "networkconnectivity_v1::HubServiceConnection::UpdateHub");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->UpdateHub(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::networkconnectivity::v1::Hub>>
HubServiceTracingConnection::UpdateHub(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "networkconnectivity_v1::HubServiceConnection::UpdateHub");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateHub(operation));
}

future<StatusOr<google::cloud::networkconnectivity::v1::OperationMetadata>>
HubServiceTracingConnection::DeleteHub(
    google::cloud::networkconnectivity::v1::DeleteHubRequest const& request) {
  auto span = internal::MakeSpan(
      "networkconnectivity_v1::HubServiceConnection::DeleteHub");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteHub(request));
}

StatusOr<google::longrunning::Operation> HubServiceTracingConnection::DeleteHub(
    NoAwaitTag,
    google::cloud::networkconnectivity::v1::DeleteHubRequest const& request) {
  auto span = internal::MakeSpan(
      "networkconnectivity_v1::HubServiceConnection::DeleteHub");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->DeleteHub(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::networkconnectivity::v1::OperationMetadata>>
HubServiceTracingConnection::DeleteHub(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "networkconnectivity_v1::HubServiceConnection::DeleteHub");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteHub(operation));
}

StreamRange<google::cloud::networkconnectivity::v1::Spoke>
HubServiceTracingConnection::ListHubSpokes(
    google::cloud::networkconnectivity::v1::ListHubSpokesRequest request) {
  auto span = internal::MakeSpan(
      "networkconnectivity_v1::HubServiceConnection::ListHubSpokes");
  internal::OTelScope scope(span);
  auto sr = child_->ListHubSpokes(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::networkconnectivity::v1::Spoke>(std::move(span),
                                                     std::move(sr));
}

StreamRange<google::cloud::networkconnectivity::v1::Spoke>
HubServiceTracingConnection::ListSpokes(
    google::cloud::networkconnectivity::v1::ListSpokesRequest request) {
  auto span = internal::MakeSpan(
      "networkconnectivity_v1::HubServiceConnection::ListSpokes");
  internal::OTelScope scope(span);
  auto sr = child_->ListSpokes(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::networkconnectivity::v1::Spoke>(std::move(span),
                                                     std::move(sr));
}

StatusOr<google::cloud::networkconnectivity::v1::Spoke>
HubServiceTracingConnection::GetSpoke(
    google::cloud::networkconnectivity::v1::GetSpokeRequest const& request) {
  auto span = internal::MakeSpan(
      "networkconnectivity_v1::HubServiceConnection::GetSpoke");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetSpoke(request));
}

future<StatusOr<google::cloud::networkconnectivity::v1::Spoke>>
HubServiceTracingConnection::CreateSpoke(
    google::cloud::networkconnectivity::v1::CreateSpokeRequest const& request) {
  auto span = internal::MakeSpan(
      "networkconnectivity_v1::HubServiceConnection::CreateSpoke");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateSpoke(request));
}

StatusOr<google::longrunning::Operation>
HubServiceTracingConnection::CreateSpoke(
    NoAwaitTag,
    google::cloud::networkconnectivity::v1::CreateSpokeRequest const& request) {
  auto span = internal::MakeSpan(
      "networkconnectivity_v1::HubServiceConnection::CreateSpoke");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->CreateSpoke(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::networkconnectivity::v1::Spoke>>
HubServiceTracingConnection::CreateSpoke(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "networkconnectivity_v1::HubServiceConnection::CreateSpoke");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateSpoke(operation));
}

future<StatusOr<google::cloud::networkconnectivity::v1::Spoke>>
HubServiceTracingConnection::UpdateSpoke(
    google::cloud::networkconnectivity::v1::UpdateSpokeRequest const& request) {
  auto span = internal::MakeSpan(
      "networkconnectivity_v1::HubServiceConnection::UpdateSpoke");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateSpoke(request));
}

StatusOr<google::longrunning::Operation>
HubServiceTracingConnection::UpdateSpoke(
    NoAwaitTag,
    google::cloud::networkconnectivity::v1::UpdateSpokeRequest const& request) {
  auto span = internal::MakeSpan(
      "networkconnectivity_v1::HubServiceConnection::UpdateSpoke");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->UpdateSpoke(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::networkconnectivity::v1::Spoke>>
HubServiceTracingConnection::UpdateSpoke(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "networkconnectivity_v1::HubServiceConnection::UpdateSpoke");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateSpoke(operation));
}

future<StatusOr<google::cloud::networkconnectivity::v1::RejectHubSpokeResponse>>
HubServiceTracingConnection::RejectHubSpoke(
    google::cloud::networkconnectivity::v1::RejectHubSpokeRequest const&
        request) {
  auto span = internal::MakeSpan(
      "networkconnectivity_v1::HubServiceConnection::RejectHubSpoke");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->RejectHubSpoke(request));
}

StatusOr<google::longrunning::Operation>
HubServiceTracingConnection::RejectHubSpoke(
    NoAwaitTag,
    google::cloud::networkconnectivity::v1::RejectHubSpokeRequest const&
        request) {
  auto span = internal::MakeSpan(
      "networkconnectivity_v1::HubServiceConnection::RejectHubSpoke");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->RejectHubSpoke(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::networkconnectivity::v1::RejectHubSpokeResponse>>
HubServiceTracingConnection::RejectHubSpoke(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "networkconnectivity_v1::HubServiceConnection::RejectHubSpoke");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->RejectHubSpoke(operation));
}

future<StatusOr<google::cloud::networkconnectivity::v1::AcceptHubSpokeResponse>>
HubServiceTracingConnection::AcceptHubSpoke(
    google::cloud::networkconnectivity::v1::AcceptHubSpokeRequest const&
        request) {
  auto span = internal::MakeSpan(
      "networkconnectivity_v1::HubServiceConnection::AcceptHubSpoke");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->AcceptHubSpoke(request));
}

StatusOr<google::longrunning::Operation>
HubServiceTracingConnection::AcceptHubSpoke(
    NoAwaitTag,
    google::cloud::networkconnectivity::v1::AcceptHubSpokeRequest const&
        request) {
  auto span = internal::MakeSpan(
      "networkconnectivity_v1::HubServiceConnection::AcceptHubSpoke");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->AcceptHubSpoke(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::networkconnectivity::v1::AcceptHubSpokeResponse>>
HubServiceTracingConnection::AcceptHubSpoke(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "networkconnectivity_v1::HubServiceConnection::AcceptHubSpoke");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->AcceptHubSpoke(operation));
}

future<StatusOr<google::cloud::networkconnectivity::v1::OperationMetadata>>
HubServiceTracingConnection::DeleteSpoke(
    google::cloud::networkconnectivity::v1::DeleteSpokeRequest const& request) {
  auto span = internal::MakeSpan(
      "networkconnectivity_v1::HubServiceConnection::DeleteSpoke");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteSpoke(request));
}

StatusOr<google::longrunning::Operation>
HubServiceTracingConnection::DeleteSpoke(
    NoAwaitTag,
    google::cloud::networkconnectivity::v1::DeleteSpokeRequest const& request) {
  auto span = internal::MakeSpan(
      "networkconnectivity_v1::HubServiceConnection::DeleteSpoke");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->DeleteSpoke(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::networkconnectivity::v1::OperationMetadata>>
HubServiceTracingConnection::DeleteSpoke(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "networkconnectivity_v1::HubServiceConnection::DeleteSpoke");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteSpoke(operation));
}

StatusOr<google::cloud::networkconnectivity::v1::RouteTable>
HubServiceTracingConnection::GetRouteTable(
    google::cloud::networkconnectivity::v1::GetRouteTableRequest const&
        request) {
  auto span = internal::MakeSpan(
      "networkconnectivity_v1::HubServiceConnection::GetRouteTable");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetRouteTable(request));
}

StatusOr<google::cloud::networkconnectivity::v1::Route>
HubServiceTracingConnection::GetRoute(
    google::cloud::networkconnectivity::v1::GetRouteRequest const& request) {
  auto span = internal::MakeSpan(
      "networkconnectivity_v1::HubServiceConnection::GetRoute");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetRoute(request));
}

StreamRange<google::cloud::networkconnectivity::v1::Route>
HubServiceTracingConnection::ListRoutes(
    google::cloud::networkconnectivity::v1::ListRoutesRequest request) {
  auto span = internal::MakeSpan(
      "networkconnectivity_v1::HubServiceConnection::ListRoutes");
  internal::OTelScope scope(span);
  auto sr = child_->ListRoutes(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::networkconnectivity::v1::Route>(std::move(span),
                                                     std::move(sr));
}

StreamRange<google::cloud::networkconnectivity::v1::RouteTable>
HubServiceTracingConnection::ListRouteTables(
    google::cloud::networkconnectivity::v1::ListRouteTablesRequest request) {
  auto span = internal::MakeSpan(
      "networkconnectivity_v1::HubServiceConnection::ListRouteTables");
  internal::OTelScope scope(span);
  auto sr = child_->ListRouteTables(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::networkconnectivity::v1::RouteTable>(std::move(span),
                                                          std::move(sr));
}

StatusOr<google::cloud::networkconnectivity::v1::Group>
HubServiceTracingConnection::GetGroup(
    google::cloud::networkconnectivity::v1::GetGroupRequest const& request) {
  auto span = internal::MakeSpan(
      "networkconnectivity_v1::HubServiceConnection::GetGroup");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetGroup(request));
}

StreamRange<google::cloud::networkconnectivity::v1::Group>
HubServiceTracingConnection::ListGroups(
    google::cloud::networkconnectivity::v1::ListGroupsRequest request) {
  auto span = internal::MakeSpan(
      "networkconnectivity_v1::HubServiceConnection::ListGroups");
  internal::OTelScope scope(span);
  auto sr = child_->ListGroups(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::networkconnectivity::v1::Group>(std::move(span),
                                                     std::move(sr));
}

StreamRange<google::cloud::location::Location>
HubServiceTracingConnection::ListLocations(
    google::cloud::location::ListLocationsRequest request) {
  auto span = internal::MakeSpan(
      "networkconnectivity_v1::HubServiceConnection::ListLocations");
  internal::OTelScope scope(span);
  auto sr = child_->ListLocations(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::location::Location>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::location::Location>
HubServiceTracingConnection::GetLocation(
    google::cloud::location::GetLocationRequest const& request) {
  auto span = internal::MakeSpan(
      "networkconnectivity_v1::HubServiceConnection::GetLocation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetLocation(request));
}

StatusOr<google::iam::v1::Policy> HubServiceTracingConnection::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  auto span = internal::MakeSpan(
      "networkconnectivity_v1::HubServiceConnection::SetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->SetIamPolicy(request));
}

StatusOr<google::iam::v1::Policy> HubServiceTracingConnection::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const& request) {
  auto span = internal::MakeSpan(
      "networkconnectivity_v1::HubServiceConnection::GetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetIamPolicy(request));
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
HubServiceTracingConnection::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const& request) {
  auto span = internal::MakeSpan(
      "networkconnectivity_v1::HubServiceConnection::TestIamPermissions");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->TestIamPermissions(request));
}

StreamRange<google::longrunning::Operation>
HubServiceTracingConnection::ListOperations(
    google::longrunning::ListOperationsRequest request) {
  auto span = internal::MakeSpan(
      "networkconnectivity_v1::HubServiceConnection::ListOperations");
  internal::OTelScope scope(span);
  auto sr = child_->ListOperations(std::move(request));
  return internal::MakeTracedStreamRange<google::longrunning::Operation>(
      std::move(span), std::move(sr));
}

StatusOr<google::longrunning::Operation>
HubServiceTracingConnection::GetOperation(
    google::longrunning::GetOperationRequest const& request) {
  auto span = internal::MakeSpan(
      "networkconnectivity_v1::HubServiceConnection::GetOperation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetOperation(request));
}

Status HubServiceTracingConnection::DeleteOperation(
    google::longrunning::DeleteOperationRequest const& request) {
  auto span = internal::MakeSpan(
      "networkconnectivity_v1::HubServiceConnection::DeleteOperation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteOperation(request));
}

Status HubServiceTracingConnection::CancelOperation(
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpan(
      "networkconnectivity_v1::HubServiceConnection::CancelOperation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CancelOperation(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<networkconnectivity_v1::HubServiceConnection>
MakeHubServiceTracingConnection(
    std::shared_ptr<networkconnectivity_v1::HubServiceConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<HubServiceTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace networkconnectivity_v1_internal
}  // namespace cloud
}  // namespace google
