// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/netapp/v1/cloud_netapp_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETAPP_V1_INTERNAL_NET_APP_STUB_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETAPP_V1_INTERNAL_NET_APP_STUB_H

#include "google/cloud/completion_queue.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/cloud/location/locations.grpc.pb.h>
#include <google/cloud/netapp/v1/cloud_netapp_service.grpc.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace netapp_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class NetAppStub {
 public:
  virtual ~NetAppStub() = 0;

  virtual StatusOr<google::cloud::netapp::v1::ListStoragePoolsResponse>
  ListStoragePools(
      grpc::ClientContext& context, Options const& options,
      google::cloud::netapp::v1::ListStoragePoolsRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>>
  AsyncCreateStoragePool(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::CreateStoragePoolRequest const& request) = 0;

  virtual StatusOr<google::longrunning::Operation> CreateStoragePool(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::CreateStoragePoolRequest const& request) = 0;

  virtual StatusOr<google::cloud::netapp::v1::StoragePool> GetStoragePool(
      grpc::ClientContext& context, Options const& options,
      google::cloud::netapp::v1::GetStoragePoolRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>>
  AsyncUpdateStoragePool(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::UpdateStoragePoolRequest const& request) = 0;

  virtual StatusOr<google::longrunning::Operation> UpdateStoragePool(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::UpdateStoragePoolRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>>
  AsyncDeleteStoragePool(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::DeleteStoragePoolRequest const& request) = 0;

  virtual StatusOr<google::longrunning::Operation> DeleteStoragePool(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::DeleteStoragePoolRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>>
  AsyncSwitchActiveReplicaZone(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::SwitchActiveReplicaZoneRequest const&
          request) = 0;

  virtual StatusOr<google::longrunning::Operation> SwitchActiveReplicaZone(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::SwitchActiveReplicaZoneRequest const&
          request) = 0;

  virtual StatusOr<google::cloud::netapp::v1::ListVolumesResponse> ListVolumes(
      grpc::ClientContext& context, Options const& options,
      google::cloud::netapp::v1::ListVolumesRequest const& request) = 0;

  virtual StatusOr<google::cloud::netapp::v1::Volume> GetVolume(
      grpc::ClientContext& context, Options const& options,
      google::cloud::netapp::v1::GetVolumeRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>> AsyncCreateVolume(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::CreateVolumeRequest const& request) = 0;

  virtual StatusOr<google::longrunning::Operation> CreateVolume(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::CreateVolumeRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>> AsyncUpdateVolume(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::UpdateVolumeRequest const& request) = 0;

  virtual StatusOr<google::longrunning::Operation> UpdateVolume(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::UpdateVolumeRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>> AsyncDeleteVolume(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::DeleteVolumeRequest const& request) = 0;

  virtual StatusOr<google::longrunning::Operation> DeleteVolume(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::DeleteVolumeRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>> AsyncRevertVolume(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::RevertVolumeRequest const& request) = 0;

  virtual StatusOr<google::longrunning::Operation> RevertVolume(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::RevertVolumeRequest const& request) = 0;

  virtual StatusOr<google::cloud::netapp::v1::ListSnapshotsResponse>
  ListSnapshots(
      grpc::ClientContext& context, Options const& options,
      google::cloud::netapp::v1::ListSnapshotsRequest const& request) = 0;

  virtual StatusOr<google::cloud::netapp::v1::Snapshot> GetSnapshot(
      grpc::ClientContext& context, Options const& options,
      google::cloud::netapp::v1::GetSnapshotRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>> AsyncCreateSnapshot(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::CreateSnapshotRequest const& request) = 0;

  virtual StatusOr<google::longrunning::Operation> CreateSnapshot(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::CreateSnapshotRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>> AsyncDeleteSnapshot(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::DeleteSnapshotRequest const& request) = 0;

  virtual StatusOr<google::longrunning::Operation> DeleteSnapshot(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::DeleteSnapshotRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>> AsyncUpdateSnapshot(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::UpdateSnapshotRequest const& request) = 0;

  virtual StatusOr<google::longrunning::Operation> UpdateSnapshot(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::UpdateSnapshotRequest const& request) = 0;

  virtual StatusOr<google::cloud::netapp::v1::ListActiveDirectoriesResponse>
  ListActiveDirectories(
      grpc::ClientContext& context, Options const& options,
      google::cloud::netapp::v1::ListActiveDirectoriesRequest const&
          request) = 0;

  virtual StatusOr<google::cloud::netapp::v1::ActiveDirectory>
  GetActiveDirectory(
      grpc::ClientContext& context, Options const& options,
      google::cloud::netapp::v1::GetActiveDirectoryRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>>
  AsyncCreateActiveDirectory(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::CreateActiveDirectoryRequest const&
          request) = 0;

  virtual StatusOr<google::longrunning::Operation> CreateActiveDirectory(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::CreateActiveDirectoryRequest const&
          request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>>
  AsyncUpdateActiveDirectory(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::UpdateActiveDirectoryRequest const&
          request) = 0;

  virtual StatusOr<google::longrunning::Operation> UpdateActiveDirectory(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::UpdateActiveDirectoryRequest const&
          request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>>
  AsyncDeleteActiveDirectory(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::DeleteActiveDirectoryRequest const&
          request) = 0;

  virtual StatusOr<google::longrunning::Operation> DeleteActiveDirectory(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::DeleteActiveDirectoryRequest const&
          request) = 0;

  virtual StatusOr<google::cloud::netapp::v1::ListKmsConfigsResponse>
  ListKmsConfigs(
      grpc::ClientContext& context, Options const& options,
      google::cloud::netapp::v1::ListKmsConfigsRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>> AsyncCreateKmsConfig(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::CreateKmsConfigRequest const& request) = 0;

  virtual StatusOr<google::longrunning::Operation> CreateKmsConfig(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::CreateKmsConfigRequest const& request) = 0;

  virtual StatusOr<google::cloud::netapp::v1::KmsConfig> GetKmsConfig(
      grpc::ClientContext& context, Options const& options,
      google::cloud::netapp::v1::GetKmsConfigRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>> AsyncUpdateKmsConfig(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::UpdateKmsConfigRequest const& request) = 0;

  virtual StatusOr<google::longrunning::Operation> UpdateKmsConfig(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::UpdateKmsConfigRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>> AsyncEncryptVolumes(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::EncryptVolumesRequest const& request) = 0;

  virtual StatusOr<google::longrunning::Operation> EncryptVolumes(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::EncryptVolumesRequest const& request) = 0;

  virtual StatusOr<google::cloud::netapp::v1::VerifyKmsConfigResponse>
  VerifyKmsConfig(
      grpc::ClientContext& context, Options const& options,
      google::cloud::netapp::v1::VerifyKmsConfigRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>> AsyncDeleteKmsConfig(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::DeleteKmsConfigRequest const& request) = 0;

  virtual StatusOr<google::longrunning::Operation> DeleteKmsConfig(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::DeleteKmsConfigRequest const& request) = 0;

  virtual StatusOr<google::cloud::netapp::v1::ListReplicationsResponse>
  ListReplications(
      grpc::ClientContext& context, Options const& options,
      google::cloud::netapp::v1::ListReplicationsRequest const& request) = 0;

  virtual StatusOr<google::cloud::netapp::v1::Replication> GetReplication(
      grpc::ClientContext& context, Options const& options,
      google::cloud::netapp::v1::GetReplicationRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>>
  AsyncCreateReplication(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::CreateReplicationRequest const& request) = 0;

  virtual StatusOr<google::longrunning::Operation> CreateReplication(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::CreateReplicationRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>>
  AsyncDeleteReplication(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::DeleteReplicationRequest const& request) = 0;

  virtual StatusOr<google::longrunning::Operation> DeleteReplication(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::DeleteReplicationRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>>
  AsyncUpdateReplication(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::UpdateReplicationRequest const& request) = 0;

  virtual StatusOr<google::longrunning::Operation> UpdateReplication(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::UpdateReplicationRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>> AsyncStopReplication(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::StopReplicationRequest const& request) = 0;

  virtual StatusOr<google::longrunning::Operation> StopReplication(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::StopReplicationRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>>
  AsyncResumeReplication(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::ResumeReplicationRequest const& request) = 0;

  virtual StatusOr<google::longrunning::Operation> ResumeReplication(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::ResumeReplicationRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>>
  AsyncReverseReplicationDirection(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::ReverseReplicationDirectionRequest const&
          request) = 0;

  virtual StatusOr<google::longrunning::Operation> ReverseReplicationDirection(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::ReverseReplicationDirectionRequest const&
          request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>>
  AsyncCreateBackupVault(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::CreateBackupVaultRequest const& request) = 0;

  virtual StatusOr<google::longrunning::Operation> CreateBackupVault(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::CreateBackupVaultRequest const& request) = 0;

  virtual StatusOr<google::cloud::netapp::v1::BackupVault> GetBackupVault(
      grpc::ClientContext& context, Options const& options,
      google::cloud::netapp::v1::GetBackupVaultRequest const& request) = 0;

  virtual StatusOr<google::cloud::netapp::v1::ListBackupVaultsResponse>
  ListBackupVaults(
      grpc::ClientContext& context, Options const& options,
      google::cloud::netapp::v1::ListBackupVaultsRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>>
  AsyncUpdateBackupVault(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::UpdateBackupVaultRequest const& request) = 0;

  virtual StatusOr<google::longrunning::Operation> UpdateBackupVault(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::UpdateBackupVaultRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>>
  AsyncDeleteBackupVault(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::DeleteBackupVaultRequest const& request) = 0;

  virtual StatusOr<google::longrunning::Operation> DeleteBackupVault(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::DeleteBackupVaultRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>> AsyncCreateBackup(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::CreateBackupRequest const& request) = 0;

  virtual StatusOr<google::longrunning::Operation> CreateBackup(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::CreateBackupRequest const& request) = 0;

  virtual StatusOr<google::cloud::netapp::v1::Backup> GetBackup(
      grpc::ClientContext& context, Options const& options,
      google::cloud::netapp::v1::GetBackupRequest const& request) = 0;

  virtual StatusOr<google::cloud::netapp::v1::ListBackupsResponse> ListBackups(
      grpc::ClientContext& context, Options const& options,
      google::cloud::netapp::v1::ListBackupsRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>> AsyncDeleteBackup(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::DeleteBackupRequest const& request) = 0;

  virtual StatusOr<google::longrunning::Operation> DeleteBackup(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::DeleteBackupRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>> AsyncUpdateBackup(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::UpdateBackupRequest const& request) = 0;

  virtual StatusOr<google::longrunning::Operation> UpdateBackup(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::UpdateBackupRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>>
  AsyncCreateBackupPolicy(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::CreateBackupPolicyRequest const& request) = 0;

  virtual StatusOr<google::longrunning::Operation> CreateBackupPolicy(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::CreateBackupPolicyRequest const& request) = 0;

  virtual StatusOr<google::cloud::netapp::v1::BackupPolicy> GetBackupPolicy(
      grpc::ClientContext& context, Options const& options,
      google::cloud::netapp::v1::GetBackupPolicyRequest const& request) = 0;

  virtual StatusOr<google::cloud::netapp::v1::ListBackupPoliciesResponse>
  ListBackupPolicies(
      grpc::ClientContext& context, Options const& options,
      google::cloud::netapp::v1::ListBackupPoliciesRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>>
  AsyncUpdateBackupPolicy(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::UpdateBackupPolicyRequest const& request) = 0;

  virtual StatusOr<google::longrunning::Operation> UpdateBackupPolicy(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::UpdateBackupPolicyRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>>
  AsyncDeleteBackupPolicy(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::DeleteBackupPolicyRequest const& request) = 0;

  virtual StatusOr<google::longrunning::Operation> DeleteBackupPolicy(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::DeleteBackupPolicyRequest const& request) = 0;

  virtual StatusOr<google::cloud::location::ListLocationsResponse>
  ListLocations(
      grpc::ClientContext& context, Options const& options,
      google::cloud::location::ListLocationsRequest const& request) = 0;

  virtual StatusOr<google::cloud::location::Location> GetLocation(
      grpc::ClientContext& context, Options const& options,
      google::cloud::location::GetLocationRequest const& request) = 0;

  virtual StatusOr<google::longrunning::ListOperationsResponse> ListOperations(
      grpc::ClientContext& context, Options const& options,
      google::longrunning::ListOperationsRequest const& request) = 0;

  virtual StatusOr<google::longrunning::Operation> GetOperation(
      grpc::ClientContext& context, Options const& options,
      google::longrunning::GetOperationRequest const& request) = 0;

  virtual Status DeleteOperation(
      grpc::ClientContext& context, Options const& options,
      google::longrunning::DeleteOperationRequest const& request) = 0;

  virtual Status CancelOperation(
      grpc::ClientContext& context, Options const& options,
      google::longrunning::CancelOperationRequest const& request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>> AsyncGetOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::longrunning::GetOperationRequest const& request) = 0;

  virtual future<Status> AsyncCancelOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::longrunning::CancelOperationRequest const& request) = 0;
};

class DefaultNetAppStub : public NetAppStub {
 public:
  DefaultNetAppStub(
      std::unique_ptr<google::cloud::netapp::v1::NetApp::StubInterface>
          grpc_stub,
      std::unique_ptr<google::longrunning::Operations::StubInterface>
          operations_stub,
      std::unique_ptr<google::cloud::location::Locations::StubInterface>
          locations_stub,
      std::unique_ptr<google::longrunning::Operations::StubInterface>
          operations)
      : grpc_stub_(std::move(grpc_stub)),
        operations_stub_(std::move(operations_stub)),
        locations_stub_(std::move(locations_stub)),
        operations_(std::move(operations)) {}

  StatusOr<google::cloud::netapp::v1::ListStoragePoolsResponse>
  ListStoragePools(grpc::ClientContext& context, Options const& options,
                   google::cloud::netapp::v1::ListStoragePoolsRequest const&
                       request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncCreateStoragePool(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::CreateStoragePoolRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> CreateStoragePool(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::CreateStoragePoolRequest const& request)
      override;

  StatusOr<google::cloud::netapp::v1::StoragePool> GetStoragePool(
      grpc::ClientContext& context, Options const& options,
      google::cloud::netapp::v1::GetStoragePoolRequest const& request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncUpdateStoragePool(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::UpdateStoragePoolRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> UpdateStoragePool(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::UpdateStoragePoolRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncDeleteStoragePool(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::DeleteStoragePoolRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> DeleteStoragePool(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::DeleteStoragePoolRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncSwitchActiveReplicaZone(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::SwitchActiveReplicaZoneRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> SwitchActiveReplicaZone(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::SwitchActiveReplicaZoneRequest const& request)
      override;

  StatusOr<google::cloud::netapp::v1::ListVolumesResponse> ListVolumes(
      grpc::ClientContext& context, Options const& options,
      google::cloud::netapp::v1::ListVolumesRequest const& request) override;

  StatusOr<google::cloud::netapp::v1::Volume> GetVolume(
      grpc::ClientContext& context, Options const& options,
      google::cloud::netapp::v1::GetVolumeRequest const& request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncCreateVolume(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::CreateVolumeRequest const& request) override;

  StatusOr<google::longrunning::Operation> CreateVolume(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::CreateVolumeRequest const& request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncUpdateVolume(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::UpdateVolumeRequest const& request) override;

  StatusOr<google::longrunning::Operation> UpdateVolume(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::UpdateVolumeRequest const& request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncDeleteVolume(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::DeleteVolumeRequest const& request) override;

  StatusOr<google::longrunning::Operation> DeleteVolume(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::DeleteVolumeRequest const& request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncRevertVolume(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::RevertVolumeRequest const& request) override;

  StatusOr<google::longrunning::Operation> RevertVolume(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::RevertVolumeRequest const& request) override;

  StatusOr<google::cloud::netapp::v1::ListSnapshotsResponse> ListSnapshots(
      grpc::ClientContext& context, Options const& options,
      google::cloud::netapp::v1::ListSnapshotsRequest const& request) override;

  StatusOr<google::cloud::netapp::v1::Snapshot> GetSnapshot(
      grpc::ClientContext& context, Options const& options,
      google::cloud::netapp::v1::GetSnapshotRequest const& request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncCreateSnapshot(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::CreateSnapshotRequest const& request) override;

  StatusOr<google::longrunning::Operation> CreateSnapshot(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::CreateSnapshotRequest const& request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncDeleteSnapshot(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::DeleteSnapshotRequest const& request) override;

  StatusOr<google::longrunning::Operation> DeleteSnapshot(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::DeleteSnapshotRequest const& request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncUpdateSnapshot(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::UpdateSnapshotRequest const& request) override;

  StatusOr<google::longrunning::Operation> UpdateSnapshot(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::UpdateSnapshotRequest const& request) override;

  StatusOr<google::cloud::netapp::v1::ListActiveDirectoriesResponse>
  ListActiveDirectories(
      grpc::ClientContext& context, Options const& options,
      google::cloud::netapp::v1::ListActiveDirectoriesRequest const& request)
      override;

  StatusOr<google::cloud::netapp::v1::ActiveDirectory> GetActiveDirectory(
      grpc::ClientContext& context, Options const& options,
      google::cloud::netapp::v1::GetActiveDirectoryRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncCreateActiveDirectory(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::CreateActiveDirectoryRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> CreateActiveDirectory(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::CreateActiveDirectoryRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncUpdateActiveDirectory(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::UpdateActiveDirectoryRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> UpdateActiveDirectory(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::UpdateActiveDirectoryRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncDeleteActiveDirectory(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::DeleteActiveDirectoryRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> DeleteActiveDirectory(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::DeleteActiveDirectoryRequest const& request)
      override;

  StatusOr<google::cloud::netapp::v1::ListKmsConfigsResponse> ListKmsConfigs(
      grpc::ClientContext& context, Options const& options,
      google::cloud::netapp::v1::ListKmsConfigsRequest const& request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncCreateKmsConfig(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::CreateKmsConfigRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> CreateKmsConfig(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::CreateKmsConfigRequest const& request)
      override;

  StatusOr<google::cloud::netapp::v1::KmsConfig> GetKmsConfig(
      grpc::ClientContext& context, Options const& options,
      google::cloud::netapp::v1::GetKmsConfigRequest const& request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncUpdateKmsConfig(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::UpdateKmsConfigRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> UpdateKmsConfig(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::UpdateKmsConfigRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncEncryptVolumes(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::EncryptVolumesRequest const& request) override;

  StatusOr<google::longrunning::Operation> EncryptVolumes(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::EncryptVolumesRequest const& request) override;

  StatusOr<google::cloud::netapp::v1::VerifyKmsConfigResponse> VerifyKmsConfig(
      grpc::ClientContext& context, Options const& options,
      google::cloud::netapp::v1::VerifyKmsConfigRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncDeleteKmsConfig(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::DeleteKmsConfigRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> DeleteKmsConfig(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::DeleteKmsConfigRequest const& request)
      override;

  StatusOr<google::cloud::netapp::v1::ListReplicationsResponse>
  ListReplications(grpc::ClientContext& context, Options const& options,
                   google::cloud::netapp::v1::ListReplicationsRequest const&
                       request) override;

  StatusOr<google::cloud::netapp::v1::Replication> GetReplication(
      grpc::ClientContext& context, Options const& options,
      google::cloud::netapp::v1::GetReplicationRequest const& request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncCreateReplication(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::CreateReplicationRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> CreateReplication(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::CreateReplicationRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncDeleteReplication(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::DeleteReplicationRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> DeleteReplication(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::DeleteReplicationRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncUpdateReplication(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::UpdateReplicationRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> UpdateReplication(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::UpdateReplicationRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncStopReplication(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::StopReplicationRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> StopReplication(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::StopReplicationRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncResumeReplication(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::ResumeReplicationRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> ResumeReplication(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::ResumeReplicationRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>>
  AsyncReverseReplicationDirection(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::ReverseReplicationDirectionRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> ReverseReplicationDirection(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::ReverseReplicationDirectionRequest const&
          request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncCreateBackupVault(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::CreateBackupVaultRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> CreateBackupVault(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::CreateBackupVaultRequest const& request)
      override;

  StatusOr<google::cloud::netapp::v1::BackupVault> GetBackupVault(
      grpc::ClientContext& context, Options const& options,
      google::cloud::netapp::v1::GetBackupVaultRequest const& request) override;

  StatusOr<google::cloud::netapp::v1::ListBackupVaultsResponse>
  ListBackupVaults(grpc::ClientContext& context, Options const& options,
                   google::cloud::netapp::v1::ListBackupVaultsRequest const&
                       request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncUpdateBackupVault(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::UpdateBackupVaultRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> UpdateBackupVault(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::UpdateBackupVaultRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncDeleteBackupVault(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::DeleteBackupVaultRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> DeleteBackupVault(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::DeleteBackupVaultRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncCreateBackup(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::CreateBackupRequest const& request) override;

  StatusOr<google::longrunning::Operation> CreateBackup(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::CreateBackupRequest const& request) override;

  StatusOr<google::cloud::netapp::v1::Backup> GetBackup(
      grpc::ClientContext& context, Options const& options,
      google::cloud::netapp::v1::GetBackupRequest const& request) override;

  StatusOr<google::cloud::netapp::v1::ListBackupsResponse> ListBackups(
      grpc::ClientContext& context, Options const& options,
      google::cloud::netapp::v1::ListBackupsRequest const& request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncDeleteBackup(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::DeleteBackupRequest const& request) override;

  StatusOr<google::longrunning::Operation> DeleteBackup(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::DeleteBackupRequest const& request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncUpdateBackup(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::UpdateBackupRequest const& request) override;

  StatusOr<google::longrunning::Operation> UpdateBackup(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::UpdateBackupRequest const& request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncCreateBackupPolicy(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::CreateBackupPolicyRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> CreateBackupPolicy(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::CreateBackupPolicyRequest const& request)
      override;

  StatusOr<google::cloud::netapp::v1::BackupPolicy> GetBackupPolicy(
      grpc::ClientContext& context, Options const& options,
      google::cloud::netapp::v1::GetBackupPolicyRequest const& request)
      override;

  StatusOr<google::cloud::netapp::v1::ListBackupPoliciesResponse>
  ListBackupPolicies(grpc::ClientContext& context, Options const& options,
                     google::cloud::netapp::v1::ListBackupPoliciesRequest const&
                         request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncUpdateBackupPolicy(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::UpdateBackupPolicyRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> UpdateBackupPolicy(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::UpdateBackupPolicyRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncDeleteBackupPolicy(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::netapp::v1::DeleteBackupPolicyRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> DeleteBackupPolicy(
      grpc::ClientContext& context, Options options,
      google::cloud::netapp::v1::DeleteBackupPolicyRequest const& request)
      override;

  StatusOr<google::cloud::location::ListLocationsResponse> ListLocations(
      grpc::ClientContext& context, Options const& options,
      google::cloud::location::ListLocationsRequest const& request) override;

  StatusOr<google::cloud::location::Location> GetLocation(
      grpc::ClientContext& context, Options const& options,
      google::cloud::location::GetLocationRequest const& request) override;

  StatusOr<google::longrunning::ListOperationsResponse> ListOperations(
      grpc::ClientContext& context, Options const& options,
      google::longrunning::ListOperationsRequest const& request) override;

  StatusOr<google::longrunning::Operation> GetOperation(
      grpc::ClientContext& context, Options const& options,
      google::longrunning::GetOperationRequest const& request) override;

  Status DeleteOperation(
      grpc::ClientContext& context, Options const& options,
      google::longrunning::DeleteOperationRequest const& request) override;

  Status CancelOperation(
      grpc::ClientContext& context, Options const& options,
      google::longrunning::CancelOperationRequest const& request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncGetOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::longrunning::GetOperationRequest const& request) override;

  future<Status> AsyncCancelOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::longrunning::CancelOperationRequest const& request) override;

 private:
  std::unique_ptr<google::cloud::netapp::v1::NetApp::StubInterface> grpc_stub_;
  std::unique_ptr<google::longrunning::Operations::StubInterface>
      operations_stub_;
  std::unique_ptr<google::cloud::location::Locations::StubInterface>
      locations_stub_;
  std::unique_ptr<google::longrunning::Operations::StubInterface> operations_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace netapp_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETAPP_V1_INTERNAL_NET_APP_STUB_H
