// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/v3/uptime_service.proto

#include "google/cloud/monitoring/v3/internal/uptime_check_auth_decorator.h"
#include <google/monitoring/v3/uptime_service.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace monitoring_v3_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

UptimeCheckServiceAuth::UptimeCheckServiceAuth(
    std::shared_ptr<google::cloud::internal::GrpcAuthenticationStrategy> auth,
    std::shared_ptr<UptimeCheckServiceStub> child)
    : auth_(std::move(auth)), child_(std::move(child)) {}

StatusOr<google::monitoring::v3::ListUptimeCheckConfigsResponse>
UptimeCheckServiceAuth::ListUptimeCheckConfigs(
    grpc::ClientContext& context, Options const& options,
    google::monitoring::v3::ListUptimeCheckConfigsRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListUptimeCheckConfigs(context, options, request);
}

StatusOr<google::monitoring::v3::UptimeCheckConfig>
UptimeCheckServiceAuth::GetUptimeCheckConfig(
    grpc::ClientContext& context, Options const& options,
    google::monitoring::v3::GetUptimeCheckConfigRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetUptimeCheckConfig(context, options, request);
}

StatusOr<google::monitoring::v3::UptimeCheckConfig>
UptimeCheckServiceAuth::CreateUptimeCheckConfig(
    grpc::ClientContext& context, Options const& options,
    google::monitoring::v3::CreateUptimeCheckConfigRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CreateUptimeCheckConfig(context, options, request);
}

StatusOr<google::monitoring::v3::UptimeCheckConfig>
UptimeCheckServiceAuth::UpdateUptimeCheckConfig(
    grpc::ClientContext& context, Options const& options,
    google::monitoring::v3::UpdateUptimeCheckConfigRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->UpdateUptimeCheckConfig(context, options, request);
}

Status UptimeCheckServiceAuth::DeleteUptimeCheckConfig(
    grpc::ClientContext& context, Options const& options,
    google::monitoring::v3::DeleteUptimeCheckConfigRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->DeleteUptimeCheckConfig(context, options, request);
}

StatusOr<google::monitoring::v3::ListUptimeCheckIpsResponse>
UptimeCheckServiceAuth::ListUptimeCheckIps(
    grpc::ClientContext& context, Options const& options,
    google::monitoring::v3::ListUptimeCheckIpsRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListUptimeCheckIps(context, options, request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring_v3_internal
}  // namespace cloud
}  // namespace google
