// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/metastore/v1/metastore.proto

#include "google/cloud/metastore/v1/dataproc_metastore_connection.h"
#include "google/cloud/metastore/v1/dataproc_metastore_options.h"
#include "google/cloud/metastore/v1/internal/dataproc_metastore_connection_impl.h"
#include "google/cloud/metastore/v1/internal/dataproc_metastore_option_defaults.h"
#include "google/cloud/metastore/v1/internal/dataproc_metastore_stub_factory.h"
#include "google/cloud/metastore/v1/internal/dataproc_metastore_tracing_connection.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace metastore_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DataprocMetastoreConnection::~DataprocMetastoreConnection() = default;

StreamRange<google::cloud::metastore::v1::Service>
DataprocMetastoreConnection::ListServices(
    google::cloud::metastore::v1::
        ListServicesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::metastore::v1::Service>>();
}

StatusOr<google::cloud::metastore::v1::Service>
DataprocMetastoreConnection::GetService(
    google::cloud::metastore::v1::GetServiceRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::metastore::v1::Service>>
DataprocMetastoreConnection::CreateService(
    google::cloud::metastore::v1::CreateServiceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::metastore::v1::Service>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
DataprocMetastoreConnection::CreateService(
    NoAwaitTag, google::cloud::metastore::v1::CreateServiceRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::metastore::v1::Service>>
DataprocMetastoreConnection::CreateService(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::metastore::v1::Service>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::metastore::v1::Service>>
DataprocMetastoreConnection::UpdateService(
    google::cloud::metastore::v1::UpdateServiceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::metastore::v1::Service>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
DataprocMetastoreConnection::UpdateService(
    NoAwaitTag, google::cloud::metastore::v1::UpdateServiceRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::metastore::v1::Service>>
DataprocMetastoreConnection::UpdateService(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::metastore::v1::Service>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::metastore::v1::OperationMetadata>>
DataprocMetastoreConnection::DeleteService(
    google::cloud::metastore::v1::DeleteServiceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::metastore::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
DataprocMetastoreConnection::DeleteService(
    NoAwaitTag, google::cloud::metastore::v1::DeleteServiceRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::metastore::v1::OperationMetadata>>
DataprocMetastoreConnection::DeleteService(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::metastore::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::metastore::v1::MetadataImport>
DataprocMetastoreConnection::ListMetadataImports(
    google::cloud::metastore::v1::
        ListMetadataImportsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::metastore::v1::MetadataImport>>();
}

StatusOr<google::cloud::metastore::v1::MetadataImport>
DataprocMetastoreConnection::GetMetadataImport(
    google::cloud::metastore::v1::GetMetadataImportRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::metastore::v1::MetadataImport>>
DataprocMetastoreConnection::CreateMetadataImport(
    google::cloud::metastore::v1::CreateMetadataImportRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::metastore::v1::MetadataImport>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
DataprocMetastoreConnection::CreateMetadataImport(
    NoAwaitTag,
    google::cloud::metastore::v1::CreateMetadataImportRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::metastore::v1::MetadataImport>>
DataprocMetastoreConnection::CreateMetadataImport(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::metastore::v1::MetadataImport>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::metastore::v1::MetadataImport>>
DataprocMetastoreConnection::UpdateMetadataImport(
    google::cloud::metastore::v1::UpdateMetadataImportRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::metastore::v1::MetadataImport>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
DataprocMetastoreConnection::UpdateMetadataImport(
    NoAwaitTag,
    google::cloud::metastore::v1::UpdateMetadataImportRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::metastore::v1::MetadataImport>>
DataprocMetastoreConnection::UpdateMetadataImport(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::metastore::v1::MetadataImport>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::metastore::v1::MetadataExport>>
DataprocMetastoreConnection::ExportMetadata(
    google::cloud::metastore::v1::ExportMetadataRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::metastore::v1::MetadataExport>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
DataprocMetastoreConnection::ExportMetadata(
    NoAwaitTag, google::cloud::metastore::v1::ExportMetadataRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::metastore::v1::MetadataExport>>
DataprocMetastoreConnection::ExportMetadata(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::metastore::v1::MetadataExport>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::metastore::v1::Restore>>
DataprocMetastoreConnection::RestoreService(
    google::cloud::metastore::v1::RestoreServiceRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::metastore::v1::Restore>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
DataprocMetastoreConnection::RestoreService(
    NoAwaitTag, google::cloud::metastore::v1::RestoreServiceRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::metastore::v1::Restore>>
DataprocMetastoreConnection::RestoreService(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::metastore::v1::Restore>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::metastore::v1::Backup>
DataprocMetastoreConnection::ListBackups(
    google::cloud::metastore::v1::
        ListBackupsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::metastore::v1::Backup>>();
}

StatusOr<google::cloud::metastore::v1::Backup>
DataprocMetastoreConnection::GetBackup(
    google::cloud::metastore::v1::GetBackupRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::metastore::v1::Backup>>
DataprocMetastoreConnection::CreateBackup(
    google::cloud::metastore::v1::CreateBackupRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::metastore::v1::Backup>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
DataprocMetastoreConnection::CreateBackup(
    NoAwaitTag, google::cloud::metastore::v1::CreateBackupRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::metastore::v1::Backup>>
DataprocMetastoreConnection::CreateBackup(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::metastore::v1::Backup>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::metastore::v1::OperationMetadata>>
DataprocMetastoreConnection::DeleteBackup(
    google::cloud::metastore::v1::DeleteBackupRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::metastore::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
DataprocMetastoreConnection::DeleteBackup(
    NoAwaitTag, google::cloud::metastore::v1::DeleteBackupRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::metastore::v1::OperationMetadata>>
DataprocMetastoreConnection::DeleteBackup(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::metastore::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::metastore::v1::QueryMetadataResponse>>
DataprocMetastoreConnection::QueryMetadata(
    google::cloud::metastore::v1::QueryMetadataRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::metastore::v1::QueryMetadataResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
DataprocMetastoreConnection::QueryMetadata(
    NoAwaitTag, google::cloud::metastore::v1::QueryMetadataRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::metastore::v1::QueryMetadataResponse>>
DataprocMetastoreConnection::QueryMetadata(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::metastore::v1::QueryMetadataResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::metastore::v1::MoveTableToDatabaseResponse>>
DataprocMetastoreConnection::MoveTableToDatabase(
    google::cloud::metastore::v1::MoveTableToDatabaseRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::metastore::v1::MoveTableToDatabaseResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
DataprocMetastoreConnection::MoveTableToDatabase(
    NoAwaitTag,
    google::cloud::metastore::v1::MoveTableToDatabaseRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::metastore::v1::MoveTableToDatabaseResponse>>
DataprocMetastoreConnection::MoveTableToDatabase(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::metastore::v1::MoveTableToDatabaseResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<
    google::cloud::metastore::v1::AlterMetadataResourceLocationResponse>>
DataprocMetastoreConnection::AlterMetadataResourceLocation(
    google::cloud::metastore::v1::AlterMetadataResourceLocationRequest const&) {
  return google::cloud::make_ready_future<StatusOr<
      google::cloud::metastore::v1::AlterMetadataResourceLocationResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
DataprocMetastoreConnection::AlterMetadataResourceLocation(
    NoAwaitTag,
    google::cloud::metastore::v1::AlterMetadataResourceLocationRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<
    google::cloud::metastore::v1::AlterMetadataResourceLocationResponse>>
DataprocMetastoreConnection::AlterMetadataResourceLocation(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<StatusOr<
      google::cloud::metastore::v1::AlterMetadataResourceLocationResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::location::Location>
DataprocMetastoreConnection::ListLocations(
    google::cloud::location::
        ListLocationsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::location::Location>>();
}

StatusOr<google::cloud::location::Location>
DataprocMetastoreConnection::GetLocation(
    google::cloud::location::GetLocationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::Policy> DataprocMetastoreConnection::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::Policy> DataprocMetastoreConnection::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
DataprocMetastoreConnection::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::longrunning::Operation>
DataprocMetastoreConnection::ListOperations(
    google::longrunning::
        ListOperationsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::longrunning::Operation>>();
}

StatusOr<google::longrunning::Operation>
DataprocMetastoreConnection::GetOperation(
    google::longrunning::GetOperationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status DataprocMetastoreConnection::DeleteOperation(
    google::longrunning::DeleteOperationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status DataprocMetastoreConnection::CancelOperation(
    google::longrunning::CancelOperationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<DataprocMetastoreConnection> MakeDataprocMetastoreConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 DataprocMetastorePolicyOptionList>(options,
                                                                    __func__);
  options = metastore_v1_internal::DataprocMetastoreDefaultOptions(
      std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = metastore_v1_internal::CreateDefaultDataprocMetastoreStub(
      std::move(auth), options);
  return metastore_v1_internal::MakeDataprocMetastoreTracingConnection(
      std::make_shared<metastore_v1_internal::DataprocMetastoreConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace metastore_v1
}  // namespace cloud
}  // namespace google
