// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/memcache/v1/cloud_memcache.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MEMCACHE_V1_INTERNAL_CLOUD_MEMCACHE_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MEMCACHE_V1_INTERNAL_CLOUD_MEMCACHE_TRACING_CONNECTION_H

#include "google/cloud/memcache/v1/cloud_memcache_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace memcache_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class CloudMemcacheTracingConnection
    : public memcache_v1::CloudMemcacheConnection {
 public:
  ~CloudMemcacheTracingConnection() override = default;

  explicit CloudMemcacheTracingConnection(
      std::shared_ptr<memcache_v1::CloudMemcacheConnection> child);

  Options options() override { return child_->options(); }

  StreamRange<google::cloud::memcache::v1::Instance> ListInstances(
      google::cloud::memcache::v1::ListInstancesRequest request) override;

  StatusOr<google::cloud::memcache::v1::Instance> GetInstance(
      google::cloud::memcache::v1::GetInstanceRequest const& request) override;

  future<StatusOr<google::cloud::memcache::v1::Instance>> CreateInstance(
      google::cloud::memcache::v1::CreateInstanceRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> CreateInstance(
      NoAwaitTag,
      google::cloud::memcache::v1::CreateInstanceRequest const& request)
      override;

  future<StatusOr<google::cloud::memcache::v1::Instance>> CreateInstance(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::memcache::v1::Instance>> UpdateInstance(
      google::cloud::memcache::v1::UpdateInstanceRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> UpdateInstance(
      NoAwaitTag,
      google::cloud::memcache::v1::UpdateInstanceRequest const& request)
      override;

  future<StatusOr<google::cloud::memcache::v1::Instance>> UpdateInstance(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::memcache::v1::Instance>> UpdateParameters(
      google::cloud::memcache::v1::UpdateParametersRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> UpdateParameters(
      NoAwaitTag,
      google::cloud::memcache::v1::UpdateParametersRequest const& request)
      override;

  future<StatusOr<google::cloud::memcache::v1::Instance>> UpdateParameters(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::memcache::v1::OperationMetadata>>
  DeleteInstance(google::cloud::memcache::v1::DeleteInstanceRequest const&
                     request) override;

  StatusOr<google::longrunning::Operation> DeleteInstance(
      NoAwaitTag,
      google::cloud::memcache::v1::DeleteInstanceRequest const& request)
      override;

  future<StatusOr<google::cloud::memcache::v1::OperationMetadata>>
  DeleteInstance(google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::memcache::v1::Instance>> ApplyParameters(
      google::cloud::memcache::v1::ApplyParametersRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> ApplyParameters(
      NoAwaitTag,
      google::cloud::memcache::v1::ApplyParametersRequest const& request)
      override;

  future<StatusOr<google::cloud::memcache::v1::Instance>> ApplyParameters(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::memcache::v1::Instance>> RescheduleMaintenance(
      google::cloud::memcache::v1::RescheduleMaintenanceRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> RescheduleMaintenance(
      NoAwaitTag,
      google::cloud::memcache::v1::RescheduleMaintenanceRequest const& request)
      override;

  future<StatusOr<google::cloud::memcache::v1::Instance>> RescheduleMaintenance(
      google::longrunning::Operation const& operation) override;

  StreamRange<google::cloud::location::Location> ListLocations(
      google::cloud::location::ListLocationsRequest request) override;

  StatusOr<google::cloud::location::Location> GetLocation(
      google::cloud::location::GetLocationRequest const& request) override;

  StreamRange<google::longrunning::Operation> ListOperations(
      google::longrunning::ListOperationsRequest request) override;

  StatusOr<google::longrunning::Operation> GetOperation(
      google::longrunning::GetOperationRequest const& request) override;

  Status DeleteOperation(
      google::longrunning::DeleteOperationRequest const& request) override;

  Status CancelOperation(
      google::longrunning::CancelOperationRequest const& request) override;

 private:
  std::shared_ptr<memcache_v1::CloudMemcacheConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<memcache_v1::CloudMemcacheConnection>
MakeCloudMemcacheTracingConnection(
    std::shared_ptr<memcache_v1::CloudMemcacheConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace memcache_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MEMCACHE_V1_INTERNAL_CLOUD_MEMCACHE_TRACING_CONNECTION_H
