// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/memcache/v1/cloud_memcache.proto

#include "google/cloud/memcache/v1/cloud_memcache_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace memcache_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

CloudMemcacheConnectionIdempotencyPolicy::
    ~CloudMemcacheConnectionIdempotencyPolicy() = default;

std::unique_ptr<CloudMemcacheConnectionIdempotencyPolicy>
CloudMemcacheConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<CloudMemcacheConnectionIdempotencyPolicy>(*this);
}

Idempotency CloudMemcacheConnectionIdempotencyPolicy::ListInstances(
    google::cloud::memcache::v1::ListInstancesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency CloudMemcacheConnectionIdempotencyPolicy::GetInstance(
    google::cloud::memcache::v1::GetInstanceRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency CloudMemcacheConnectionIdempotencyPolicy::CreateInstance(
    google::cloud::memcache::v1::CreateInstanceRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency CloudMemcacheConnectionIdempotencyPolicy::UpdateInstance(
    google::cloud::memcache::v1::UpdateInstanceRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency CloudMemcacheConnectionIdempotencyPolicy::UpdateParameters(
    google::cloud::memcache::v1::UpdateParametersRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency CloudMemcacheConnectionIdempotencyPolicy::DeleteInstance(
    google::cloud::memcache::v1::DeleteInstanceRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency CloudMemcacheConnectionIdempotencyPolicy::ApplyParameters(
    google::cloud::memcache::v1::ApplyParametersRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency CloudMemcacheConnectionIdempotencyPolicy::RescheduleMaintenance(
    google::cloud::memcache::v1::RescheduleMaintenanceRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency CloudMemcacheConnectionIdempotencyPolicy::ListLocations(
    google::cloud::location::ListLocationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency CloudMemcacheConnectionIdempotencyPolicy::GetLocation(
    google::cloud::location::GetLocationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency CloudMemcacheConnectionIdempotencyPolicy::ListOperations(
    google::longrunning::ListOperationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency CloudMemcacheConnectionIdempotencyPolicy::GetOperation(
    google::longrunning::GetOperationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency CloudMemcacheConnectionIdempotencyPolicy::DeleteOperation(
    google::longrunning::DeleteOperationRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency CloudMemcacheConnectionIdempotencyPolicy::CancelOperation(
    google::longrunning::CancelOperationRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<CloudMemcacheConnectionIdempotencyPolicy>
MakeDefaultCloudMemcacheConnectionIdempotencyPolicy() {
  return std::make_unique<CloudMemcacheConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace memcache_v1
}  // namespace cloud
}  // namespace google
