// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/managedkafka/v1/managed_kafka.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MANAGEDKAFKA_V1_MANAGED_KAFKA_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MANAGEDKAFKA_V1_MANAGED_KAFKA_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <google/cloud/location/locations.grpc.pb.h>
#include <google/cloud/managedkafka/v1/managed_kafka.grpc.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace managedkafka_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class ManagedKafkaConnectionIdempotencyPolicy {
 public:
  virtual ~ManagedKafkaConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<ManagedKafkaConnectionIdempotencyPolicy> clone()
      const;

  virtual google::cloud::Idempotency ListClusters(
      google::cloud::managedkafka::v1::ListClustersRequest request);

  virtual google::cloud::Idempotency GetCluster(
      google::cloud::managedkafka::v1::GetClusterRequest const& request);

  virtual google::cloud::Idempotency CreateCluster(
      google::cloud::managedkafka::v1::CreateClusterRequest const& request);

  virtual google::cloud::Idempotency UpdateCluster(
      google::cloud::managedkafka::v1::UpdateClusterRequest const& request);

  virtual google::cloud::Idempotency DeleteCluster(
      google::cloud::managedkafka::v1::DeleteClusterRequest const& request);

  virtual google::cloud::Idempotency ListTopics(
      google::cloud::managedkafka::v1::ListTopicsRequest request);

  virtual google::cloud::Idempotency GetTopic(
      google::cloud::managedkafka::v1::GetTopicRequest const& request);

  virtual google::cloud::Idempotency CreateTopic(
      google::cloud::managedkafka::v1::CreateTopicRequest const& request);

  virtual google::cloud::Idempotency UpdateTopic(
      google::cloud::managedkafka::v1::UpdateTopicRequest const& request);

  virtual google::cloud::Idempotency DeleteTopic(
      google::cloud::managedkafka::v1::DeleteTopicRequest const& request);

  virtual google::cloud::Idempotency ListConsumerGroups(
      google::cloud::managedkafka::v1::ListConsumerGroupsRequest request);

  virtual google::cloud::Idempotency GetConsumerGroup(
      google::cloud::managedkafka::v1::GetConsumerGroupRequest const& request);

  virtual google::cloud::Idempotency UpdateConsumerGroup(
      google::cloud::managedkafka::v1::UpdateConsumerGroupRequest const&
          request);

  virtual google::cloud::Idempotency DeleteConsumerGroup(
      google::cloud::managedkafka::v1::DeleteConsumerGroupRequest const&
          request);

  virtual google::cloud::Idempotency ListLocations(
      google::cloud::location::ListLocationsRequest request);

  virtual google::cloud::Idempotency GetLocation(
      google::cloud::location::GetLocationRequest const& request);

  virtual google::cloud::Idempotency ListOperations(
      google::longrunning::ListOperationsRequest request);

  virtual google::cloud::Idempotency GetOperation(
      google::longrunning::GetOperationRequest const& request);

  virtual google::cloud::Idempotency DeleteOperation(
      google::longrunning::DeleteOperationRequest const& request);

  virtual google::cloud::Idempotency CancelOperation(
      google::longrunning::CancelOperationRequest const& request);
};

std::unique_ptr<ManagedKafkaConnectionIdempotencyPolicy>
MakeDefaultManagedKafkaConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace managedkafka_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MANAGEDKAFKA_V1_MANAGED_KAFKA_CONNECTION_IDEMPOTENCY_POLICY_H
