// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/managedkafka/v1/managed_kafka.proto

#include "google/cloud/managedkafka/v1/managed_kafka_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace managedkafka_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

ManagedKafkaConnectionIdempotencyPolicy::
    ~ManagedKafkaConnectionIdempotencyPolicy() = default;

std::unique_ptr<ManagedKafkaConnectionIdempotencyPolicy>
ManagedKafkaConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<ManagedKafkaConnectionIdempotencyPolicy>(*this);
}

Idempotency ManagedKafkaConnectionIdempotencyPolicy::ListClusters(
    google::cloud::managedkafka::v1::ListClustersRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency ManagedKafkaConnectionIdempotencyPolicy::GetCluster(
    google::cloud::managedkafka::v1::GetClusterRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency ManagedKafkaConnectionIdempotencyPolicy::CreateCluster(
    google::cloud::managedkafka::v1::CreateClusterRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ManagedKafkaConnectionIdempotencyPolicy::UpdateCluster(
    google::cloud::managedkafka::v1::UpdateClusterRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ManagedKafkaConnectionIdempotencyPolicy::DeleteCluster(
    google::cloud::managedkafka::v1::DeleteClusterRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ManagedKafkaConnectionIdempotencyPolicy::ListTopics(
    google::cloud::managedkafka::v1::ListTopicsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency ManagedKafkaConnectionIdempotencyPolicy::GetTopic(
    google::cloud::managedkafka::v1::GetTopicRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency ManagedKafkaConnectionIdempotencyPolicy::CreateTopic(
    google::cloud::managedkafka::v1::CreateTopicRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ManagedKafkaConnectionIdempotencyPolicy::UpdateTopic(
    google::cloud::managedkafka::v1::UpdateTopicRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ManagedKafkaConnectionIdempotencyPolicy::DeleteTopic(
    google::cloud::managedkafka::v1::DeleteTopicRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ManagedKafkaConnectionIdempotencyPolicy::ListConsumerGroups(
    google::cloud::managedkafka::v1::ListConsumerGroupsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency ManagedKafkaConnectionIdempotencyPolicy::GetConsumerGroup(
    google::cloud::managedkafka::v1::GetConsumerGroupRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency ManagedKafkaConnectionIdempotencyPolicy::UpdateConsumerGroup(
    google::cloud::managedkafka::v1::UpdateConsumerGroupRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ManagedKafkaConnectionIdempotencyPolicy::DeleteConsumerGroup(
    google::cloud::managedkafka::v1::DeleteConsumerGroupRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ManagedKafkaConnectionIdempotencyPolicy::ListLocations(
    google::cloud::location::ListLocationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency ManagedKafkaConnectionIdempotencyPolicy::GetLocation(
    google::cloud::location::GetLocationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency ManagedKafkaConnectionIdempotencyPolicy::ListOperations(
    google::longrunning::ListOperationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency ManagedKafkaConnectionIdempotencyPolicy::GetOperation(
    google::longrunning::GetOperationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency ManagedKafkaConnectionIdempotencyPolicy::DeleteOperation(
    google::longrunning::DeleteOperationRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ManagedKafkaConnectionIdempotencyPolicy::CancelOperation(
    google::longrunning::CancelOperationRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<ManagedKafkaConnectionIdempotencyPolicy>
MakeDefaultManagedKafkaConnectionIdempotencyPolicy() {
  return std::make_unique<ManagedKafkaConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace managedkafka_v1
}  // namespace cloud
}  // namespace google
