// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/managedkafka/v1/managed_kafka.proto

#include "google/cloud/managedkafka/v1/managed_kafka_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace managedkafka_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ManagedKafkaClient::ManagedKafkaClient(
    std::shared_ptr<ManagedKafkaConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
ManagedKafkaClient::~ManagedKafkaClient() = default;

StreamRange<google::cloud::managedkafka::v1::Cluster>
ManagedKafkaClient::ListClusters(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::managedkafka::v1::ListClustersRequest request;
  request.set_parent(parent);
  return connection_->ListClusters(request);
}

StreamRange<google::cloud::managedkafka::v1::Cluster>
ManagedKafkaClient::ListClusters(
    google::cloud::managedkafka::v1::ListClustersRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListClusters(std::move(request));
}

StatusOr<google::cloud::managedkafka::v1::Cluster>
ManagedKafkaClient::GetCluster(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::managedkafka::v1::GetClusterRequest request;
  request.set_name(name);
  return connection_->GetCluster(request);
}

StatusOr<google::cloud::managedkafka::v1::Cluster>
ManagedKafkaClient::GetCluster(
    google::cloud::managedkafka::v1::GetClusterRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetCluster(request);
}

future<StatusOr<google::cloud::managedkafka::v1::Cluster>>
ManagedKafkaClient::CreateCluster(
    std::string const& parent,
    google::cloud::managedkafka::v1::Cluster const& cluster,
    std::string const& cluster_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::managedkafka::v1::CreateClusterRequest request;
  request.set_parent(parent);
  *request.mutable_cluster() = cluster;
  request.set_cluster_id(cluster_id);
  return connection_->CreateCluster(request);
}

StatusOr<google::longrunning::Operation> ManagedKafkaClient::CreateCluster(
    NoAwaitTag, std::string const& parent,
    google::cloud::managedkafka::v1::Cluster const& cluster,
    std::string const& cluster_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::managedkafka::v1::CreateClusterRequest request;
  request.set_parent(parent);
  *request.mutable_cluster() = cluster;
  request.set_cluster_id(cluster_id);
  return connection_->CreateCluster(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::managedkafka::v1::Cluster>>
ManagedKafkaClient::CreateCluster(
    google::cloud::managedkafka::v1::CreateClusterRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateCluster(request);
}

StatusOr<google::longrunning::Operation> ManagedKafkaClient::CreateCluster(
    NoAwaitTag,
    google::cloud::managedkafka::v1::CreateClusterRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateCluster(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::managedkafka::v1::Cluster>>
ManagedKafkaClient::CreateCluster(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateCluster(operation);
}

future<StatusOr<google::cloud::managedkafka::v1::Cluster>>
ManagedKafkaClient::UpdateCluster(
    google::cloud::managedkafka::v1::Cluster const& cluster,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::managedkafka::v1::UpdateClusterRequest request;
  *request.mutable_cluster() = cluster;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateCluster(request);
}

StatusOr<google::longrunning::Operation> ManagedKafkaClient::UpdateCluster(
    NoAwaitTag, google::cloud::managedkafka::v1::Cluster const& cluster,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::managedkafka::v1::UpdateClusterRequest request;
  *request.mutable_cluster() = cluster;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateCluster(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::managedkafka::v1::Cluster>>
ManagedKafkaClient::UpdateCluster(
    google::cloud::managedkafka::v1::UpdateClusterRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateCluster(request);
}

StatusOr<google::longrunning::Operation> ManagedKafkaClient::UpdateCluster(
    NoAwaitTag,
    google::cloud::managedkafka::v1::UpdateClusterRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateCluster(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::managedkafka::v1::Cluster>>
ManagedKafkaClient::UpdateCluster(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateCluster(operation);
}

future<StatusOr<google::cloud::managedkafka::v1::OperationMetadata>>
ManagedKafkaClient::DeleteCluster(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::managedkafka::v1::DeleteClusterRequest request;
  request.set_name(name);
  return connection_->DeleteCluster(request);
}

StatusOr<google::longrunning::Operation> ManagedKafkaClient::DeleteCluster(
    NoAwaitTag, std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::managedkafka::v1::DeleteClusterRequest request;
  request.set_name(name);
  return connection_->DeleteCluster(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::managedkafka::v1::OperationMetadata>>
ManagedKafkaClient::DeleteCluster(
    google::cloud::managedkafka::v1::DeleteClusterRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteCluster(request);
}

StatusOr<google::longrunning::Operation> ManagedKafkaClient::DeleteCluster(
    NoAwaitTag,
    google::cloud::managedkafka::v1::DeleteClusterRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteCluster(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::managedkafka::v1::OperationMetadata>>
ManagedKafkaClient::DeleteCluster(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteCluster(operation);
}

StreamRange<google::cloud::managedkafka::v1::Topic>
ManagedKafkaClient::ListTopics(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::managedkafka::v1::ListTopicsRequest request;
  request.set_parent(parent);
  return connection_->ListTopics(request);
}

StreamRange<google::cloud::managedkafka::v1::Topic>
ManagedKafkaClient::ListTopics(
    google::cloud::managedkafka::v1::ListTopicsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListTopics(std::move(request));
}

StatusOr<google::cloud::managedkafka::v1::Topic> ManagedKafkaClient::GetTopic(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::managedkafka::v1::GetTopicRequest request;
  request.set_name(name);
  return connection_->GetTopic(request);
}

StatusOr<google::cloud::managedkafka::v1::Topic> ManagedKafkaClient::GetTopic(
    google::cloud::managedkafka::v1::GetTopicRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetTopic(request);
}

StatusOr<google::cloud::managedkafka::v1::Topic>
ManagedKafkaClient::CreateTopic(
    std::string const& parent,
    google::cloud::managedkafka::v1::Topic const& topic,
    std::string const& topic_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::managedkafka::v1::CreateTopicRequest request;
  request.set_parent(parent);
  *request.mutable_topic() = topic;
  request.set_topic_id(topic_id);
  return connection_->CreateTopic(request);
}

StatusOr<google::cloud::managedkafka::v1::Topic>
ManagedKafkaClient::CreateTopic(
    google::cloud::managedkafka::v1::CreateTopicRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateTopic(request);
}

StatusOr<google::cloud::managedkafka::v1::Topic>
ManagedKafkaClient::UpdateTopic(
    google::cloud::managedkafka::v1::Topic const& topic,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::managedkafka::v1::UpdateTopicRequest request;
  *request.mutable_topic() = topic;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateTopic(request);
}

StatusOr<google::cloud::managedkafka::v1::Topic>
ManagedKafkaClient::UpdateTopic(
    google::cloud::managedkafka::v1::UpdateTopicRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateTopic(request);
}

Status ManagedKafkaClient::DeleteTopic(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::managedkafka::v1::DeleteTopicRequest request;
  request.set_name(name);
  return connection_->DeleteTopic(request);
}

Status ManagedKafkaClient::DeleteTopic(
    google::cloud::managedkafka::v1::DeleteTopicRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteTopic(request);
}

StreamRange<google::cloud::managedkafka::v1::ConsumerGroup>
ManagedKafkaClient::ListConsumerGroups(std::string const& parent,
                                       Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::managedkafka::v1::ListConsumerGroupsRequest request;
  request.set_parent(parent);
  return connection_->ListConsumerGroups(request);
}

StreamRange<google::cloud::managedkafka::v1::ConsumerGroup>
ManagedKafkaClient::ListConsumerGroups(
    google::cloud::managedkafka::v1::ListConsumerGroupsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListConsumerGroups(std::move(request));
}

StatusOr<google::cloud::managedkafka::v1::ConsumerGroup>
ManagedKafkaClient::GetConsumerGroup(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::managedkafka::v1::GetConsumerGroupRequest request;
  request.set_name(name);
  return connection_->GetConsumerGroup(request);
}

StatusOr<google::cloud::managedkafka::v1::ConsumerGroup>
ManagedKafkaClient::GetConsumerGroup(
    google::cloud::managedkafka::v1::GetConsumerGroupRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetConsumerGroup(request);
}

StatusOr<google::cloud::managedkafka::v1::ConsumerGroup>
ManagedKafkaClient::UpdateConsumerGroup(
    google::cloud::managedkafka::v1::ConsumerGroup const& consumer_group,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::managedkafka::v1::UpdateConsumerGroupRequest request;
  *request.mutable_consumer_group() = consumer_group;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateConsumerGroup(request);
}

StatusOr<google::cloud::managedkafka::v1::ConsumerGroup>
ManagedKafkaClient::UpdateConsumerGroup(
    google::cloud::managedkafka::v1::UpdateConsumerGroupRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateConsumerGroup(request);
}

Status ManagedKafkaClient::DeleteConsumerGroup(std::string const& name,
                                               Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::managedkafka::v1::DeleteConsumerGroupRequest request;
  request.set_name(name);
  return connection_->DeleteConsumerGroup(request);
}

Status ManagedKafkaClient::DeleteConsumerGroup(
    google::cloud::managedkafka::v1::DeleteConsumerGroupRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteConsumerGroup(request);
}

StreamRange<google::cloud::location::Location>
ManagedKafkaClient::ListLocations(
    google::cloud::location::ListLocationsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListLocations(std::move(request));
}

StatusOr<google::cloud::location::Location> ManagedKafkaClient::GetLocation(
    google::cloud::location::GetLocationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetLocation(request);
}

StreamRange<google::longrunning::Operation> ManagedKafkaClient::ListOperations(
    std::string const& name, std::string const& filter, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::ListOperationsRequest request;
  request.set_name(name);
  request.set_filter(filter);
  return connection_->ListOperations(request);
}

StreamRange<google::longrunning::Operation> ManagedKafkaClient::ListOperations(
    google::longrunning::ListOperationsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListOperations(std::move(request));
}

StatusOr<google::longrunning::Operation> ManagedKafkaClient::GetOperation(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::GetOperationRequest request;
  request.set_name(name);
  return connection_->GetOperation(request);
}

StatusOr<google::longrunning::Operation> ManagedKafkaClient::GetOperation(
    google::longrunning::GetOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetOperation(request);
}

Status ManagedKafkaClient::DeleteOperation(std::string const& name,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::DeleteOperationRequest request;
  request.set_name(name);
  return connection_->DeleteOperation(request);
}

Status ManagedKafkaClient::DeleteOperation(
    google::longrunning::DeleteOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteOperation(request);
}

Status ManagedKafkaClient::CancelOperation(std::string const& name,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::CancelOperationRequest request;
  request.set_name(name);
  return connection_->CancelOperation(request);
}

Status ManagedKafkaClient::CancelOperation(
    google::longrunning::CancelOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CancelOperation(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace managedkafka_v1
}  // namespace cloud
}  // namespace google
