// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/logging/v2/logging_metrics.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_LOGGING_V2_INTERNAL_METRICS_SERVICE_V2_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_LOGGING_V2_INTERNAL_METRICS_SERVICE_V2_TRACING_CONNECTION_H

#include "google/cloud/logging/v2/metrics_service_v2_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace logging_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class MetricsServiceV2TracingConnection
    : public logging_v2::MetricsServiceV2Connection {
 public:
  ~MetricsServiceV2TracingConnection() override = default;

  explicit MetricsServiceV2TracingConnection(
      std::shared_ptr<logging_v2::MetricsServiceV2Connection> child);

  Options options() override { return child_->options(); }

  StreamRange<google::logging::v2::LogMetric> ListLogMetrics(
      google::logging::v2::ListLogMetricsRequest request) override;

  StatusOr<google::logging::v2::LogMetric> GetLogMetric(
      google::logging::v2::GetLogMetricRequest const& request) override;

  StatusOr<google::logging::v2::LogMetric> CreateLogMetric(
      google::logging::v2::CreateLogMetricRequest const& request) override;

  StatusOr<google::logging::v2::LogMetric> UpdateLogMetric(
      google::logging::v2::UpdateLogMetricRequest const& request) override;

  Status DeleteLogMetric(
      google::logging::v2::DeleteLogMetricRequest const& request) override;

  StreamRange<google::longrunning::Operation> ListOperations(
      google::longrunning::ListOperationsRequest request) override;

  StatusOr<google::longrunning::Operation> GetOperation(
      google::longrunning::GetOperationRequest const& request) override;

  Status CancelOperation(
      google::longrunning::CancelOperationRequest const& request) override;

 private:
  std::shared_ptr<logging_v2::MetricsServiceV2Connection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<logging_v2::MetricsServiceV2Connection>
MakeMetricsServiceV2TracingConnection(
    std::shared_ptr<logging_v2::MetricsServiceV2Connection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace logging_v2_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_LOGGING_V2_INTERNAL_METRICS_SERVICE_V2_TRACING_CONNECTION_H
