// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/logging/v2/logging_metrics.proto

#include "google/cloud/logging/v2/internal/metrics_service_v2_stub.h"
#include "google/cloud/grpc_error_delegate.h"
#include "google/cloud/status_or.h"
#include <google/logging/v2/logging_metrics.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace logging_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

MetricsServiceV2Stub::~MetricsServiceV2Stub() = default;

StatusOr<google::logging::v2::ListLogMetricsResponse>
DefaultMetricsServiceV2Stub::ListLogMetrics(
    grpc::ClientContext& context, Options const&,
    google::logging::v2::ListLogMetricsRequest const& request) {
  google::logging::v2::ListLogMetricsResponse response;
  auto status = grpc_stub_->ListLogMetrics(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::logging::v2::LogMetric>
DefaultMetricsServiceV2Stub::GetLogMetric(
    grpc::ClientContext& context, Options const&,
    google::logging::v2::GetLogMetricRequest const& request) {
  google::logging::v2::LogMetric response;
  auto status = grpc_stub_->GetLogMetric(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::logging::v2::LogMetric>
DefaultMetricsServiceV2Stub::CreateLogMetric(
    grpc::ClientContext& context, Options const&,
    google::logging::v2::CreateLogMetricRequest const& request) {
  google::logging::v2::LogMetric response;
  auto status = grpc_stub_->CreateLogMetric(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::logging::v2::LogMetric>
DefaultMetricsServiceV2Stub::UpdateLogMetric(
    grpc::ClientContext& context, Options const&,
    google::logging::v2::UpdateLogMetricRequest const& request) {
  google::logging::v2::LogMetric response;
  auto status = grpc_stub_->UpdateLogMetric(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

Status DefaultMetricsServiceV2Stub::DeleteLogMetric(
    grpc::ClientContext& context, Options const&,
    google::logging::v2::DeleteLogMetricRequest const& request) {
  google::protobuf::Empty response;
  auto status = grpc_stub_->DeleteLogMetric(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return google::cloud::Status();
}

StatusOr<google::longrunning::ListOperationsResponse>
DefaultMetricsServiceV2Stub::ListOperations(
    grpc::ClientContext& context, Options const&,
    google::longrunning::ListOperationsRequest const& request) {
  google::longrunning::ListOperationsResponse response;
  auto status = operations_stub_->ListOperations(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::longrunning::Operation>
DefaultMetricsServiceV2Stub::GetOperation(
    grpc::ClientContext& context, Options const&,
    google::longrunning::GetOperationRequest const& request) {
  google::longrunning::Operation response;
  auto status = operations_stub_->GetOperation(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

Status DefaultMetricsServiceV2Stub::CancelOperation(
    grpc::ClientContext& context, Options const&,
    google::longrunning::CancelOperationRequest const& request) {
  google::protobuf::Empty response;
  auto status = operations_stub_->CancelOperation(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return google::cloud::Status();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace logging_v2_internal
}  // namespace cloud
}  // namespace google
