// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/logging/v2/logging.proto

#include "google/cloud/logging/v2/internal/logging_service_v2_stub.h"
#include "google/cloud/grpc_error_delegate.h"
#include "google/cloud/internal/async_read_write_stream_impl.h"
#include "google/cloud/status_or.h"
#include <google/logging/v2/logging.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace logging_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

LoggingServiceV2Stub::~LoggingServiceV2Stub() = default;

Status DefaultLoggingServiceV2Stub::DeleteLog(
    grpc::ClientContext& context, Options const&,
    google::logging::v2::DeleteLogRequest const& request) {
  google::protobuf::Empty response;
  auto status = grpc_stub_->DeleteLog(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return google::cloud::Status();
}

StatusOr<google::logging::v2::WriteLogEntriesResponse>
DefaultLoggingServiceV2Stub::WriteLogEntries(
    grpc::ClientContext& context, Options const&,
    google::logging::v2::WriteLogEntriesRequest const& request) {
  google::logging::v2::WriteLogEntriesResponse response;
  auto status = grpc_stub_->WriteLogEntries(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::logging::v2::ListLogEntriesResponse>
DefaultLoggingServiceV2Stub::ListLogEntries(
    grpc::ClientContext& context, Options const&,
    google::logging::v2::ListLogEntriesRequest const& request) {
  google::logging::v2::ListLogEntriesResponse response;
  auto status = grpc_stub_->ListLogEntries(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::logging::v2::ListMonitoredResourceDescriptorsResponse>
DefaultLoggingServiceV2Stub::ListMonitoredResourceDescriptors(
    grpc::ClientContext& context, Options const&,
    google::logging::v2::ListMonitoredResourceDescriptorsRequest const&
        request) {
  google::logging::v2::ListMonitoredResourceDescriptorsResponse response;
  auto status = grpc_stub_->ListMonitoredResourceDescriptors(&context, request,
                                                             &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::logging::v2::ListLogsResponse>
DefaultLoggingServiceV2Stub::ListLogs(
    grpc::ClientContext& context, Options const&,
    google::logging::v2::ListLogsRequest const& request) {
  google::logging::v2::ListLogsResponse response;
  auto status = grpc_stub_->ListLogs(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

std::unique_ptr<::google::cloud::AsyncStreamingReadWriteRpc<
    google::logging::v2::TailLogEntriesRequest,
    google::logging::v2::TailLogEntriesResponse>>
DefaultLoggingServiceV2Stub::AsyncTailLogEntries(
    google::cloud::CompletionQueue const& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options) {
  return google::cloud::internal::MakeStreamingReadWriteRpc<
      google::logging::v2::TailLogEntriesRequest,
      google::logging::v2::TailLogEntriesResponse>(
      cq, std::move(context), std::move(options),
      [this](grpc::ClientContext* context, grpc::CompletionQueue* cq) {
        return grpc_stub_->PrepareAsyncTailLogEntries(context, cq);
      });
}

StatusOr<google::longrunning::ListOperationsResponse>
DefaultLoggingServiceV2Stub::ListOperations(
    grpc::ClientContext& context, Options const&,
    google::longrunning::ListOperationsRequest const& request) {
  google::longrunning::ListOperationsResponse response;
  auto status = operations_stub_->ListOperations(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::longrunning::Operation>
DefaultLoggingServiceV2Stub::GetOperation(
    grpc::ClientContext& context, Options const&,
    google::longrunning::GetOperationRequest const& request) {
  google::longrunning::Operation response;
  auto status = operations_stub_->GetOperation(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

Status DefaultLoggingServiceV2Stub::CancelOperation(
    grpc::ClientContext& context, Options const&,
    google::longrunning::CancelOperationRequest const& request) {
  google::protobuf::Empty response;
  auto status = operations_stub_->CancelOperation(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return google::cloud::Status();
}

future<StatusOr<google::logging::v2::WriteLogEntriesResponse>>
DefaultLoggingServiceV2Stub::AsyncWriteLogEntries(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    // NOLINTNEXTLINE(performance-unnecessary-value-param)
    google::cloud::internal::ImmutableOptions,
    google::logging::v2::WriteLogEntriesRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::logging::v2::WriteLogEntriesRequest,
      google::logging::v2::WriteLogEntriesResponse>(
      cq,
      [this](grpc::ClientContext* context,
             google::logging::v2::WriteLogEntriesRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncWriteLogEntries(context, request, cq);
      },
      request, std::move(context));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace logging_v2_internal
}  // namespace cloud
}  // namespace google
