// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/logging/v2/logging.proto

#include "google/cloud/logging/v2/internal/logging_service_v2_connection_impl.h"
#include "google/cloud/logging/v2/internal/logging_service_v2_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_retry_loop.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace logging_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<logging_v2::LoggingServiceV2RetryPolicy> retry_policy(
    Options const& options) {
  return options.get<logging_v2::LoggingServiceV2RetryPolicyOption>()->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options.get<logging_v2::LoggingServiceV2BackoffPolicyOption>()
      ->clone();
}

std::unique_ptr<logging_v2::LoggingServiceV2ConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<logging_v2::LoggingServiceV2ConnectionIdempotencyPolicyOption>()
      ->clone();
}

}  // namespace

LoggingServiceV2ConnectionImpl::LoggingServiceV2ConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<logging_v2_internal::LoggingServiceV2Stub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(std::move(options),
                                      LoggingServiceV2Connection::options())) {}

Status LoggingServiceV2ConnectionImpl::DeleteLog(
    google::logging::v2::DeleteLogRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteLog(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::logging::v2::DeleteLogRequest const& request) {
        return stub_->DeleteLog(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::logging::v2::WriteLogEntriesResponse>
LoggingServiceV2ConnectionImpl::WriteLogEntries(
    google::logging::v2::WriteLogEntriesRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->WriteLogEntries(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::logging::v2::WriteLogEntriesRequest const& request) {
        return stub_->WriteLogEntries(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::logging::v2::LogEntry>
LoggingServiceV2ConnectionImpl::ListLogEntries(
    google::logging::v2::ListLogEntriesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListLogEntries(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::logging::v2::LogEntry>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<logging_v2::LoggingServiceV2RetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::logging::v2::ListLogEntriesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::logging::v2::ListLogEntriesRequest const& request) {
              return stub->ListLogEntries(context, options, request);
            },
            options, r, function_name);
      },
      [](google::logging::v2::ListLogEntriesResponse r) {
        std::vector<google::logging::v2::LogEntry> result(r.entries().size());
        auto& messages = *r.mutable_entries();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StreamRange<google::api::MonitoredResourceDescriptor>
LoggingServiceV2ConnectionImpl::ListMonitoredResourceDescriptors(
    google::logging::v2::ListMonitoredResourceDescriptorsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListMonitoredResourceDescriptors(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::api::MonitoredResourceDescriptor>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<logging_v2::LoggingServiceV2RetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::logging::v2::ListMonitoredResourceDescriptorsRequest const&
              r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::logging::v2::
                       ListMonitoredResourceDescriptorsRequest const& request) {
              return stub->ListMonitoredResourceDescriptors(context, options,
                                                            request);
            },
            options, r, function_name);
      },
      [](google::logging::v2::ListMonitoredResourceDescriptorsResponse r) {
        std::vector<google::api::MonitoredResourceDescriptor> result(
            r.resource_descriptors().size());
        auto& messages = *r.mutable_resource_descriptors();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StreamRange<std::string> LoggingServiceV2ConnectionImpl::ListLogs(
    google::logging::v2::ListLogsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListLogs(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<StreamRange<std::string>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<logging_v2::LoggingServiceV2RetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::logging::v2::ListLogsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::logging::v2::ListLogsRequest const& request) {
              return stub->ListLogs(context, options, request);
            },
            options, r, function_name);
      },
      [](google::logging::v2::ListLogsResponse r) {
        std::vector<std::string> result(r.log_names().size());
        auto& messages = *r.mutable_log_names();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

std::unique_ptr<::google::cloud::AsyncStreamingReadWriteRpc<
    google::logging::v2::TailLogEntriesRequest,
    google::logging::v2::TailLogEntriesResponse>>
LoggingServiceV2ConnectionImpl::AsyncTailLogEntries() {
  return stub_->AsyncTailLogEntries(background_->cq(),
                                    std::make_shared<grpc::ClientContext>(),
                                    internal::SaveCurrentOptions());
}

StreamRange<google::longrunning::Operation>
LoggingServiceV2ConnectionImpl::ListOperations(
    google::longrunning::ListOperationsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListOperations(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::longrunning::Operation>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<logging_v2::LoggingServiceV2RetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::longrunning::ListOperationsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::longrunning::ListOperationsRequest const& request) {
              return stub->ListOperations(context, options, request);
            },
            options, r, function_name);
      },
      [](google::longrunning::ListOperationsResponse r) {
        std::vector<google::longrunning::Operation> result(
            r.operations().size());
        auto& messages = *r.mutable_operations();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::longrunning::Operation>
LoggingServiceV2ConnectionImpl::GetOperation(
    google::longrunning::GetOperationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetOperation(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::longrunning::GetOperationRequest const& request) {
        return stub_->GetOperation(context, options, request);
      },
      *current, request, __func__);
}

Status LoggingServiceV2ConnectionImpl::CancelOperation(
    google::longrunning::CancelOperationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CancelOperation(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::longrunning::CancelOperationRequest const& request) {
        return stub_->CancelOperation(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::logging::v2::WriteLogEntriesResponse>>
LoggingServiceV2ConnectionImpl::AsyncWriteLogEntries(
    google::logging::v2::WriteLogEntriesRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->WriteLogEntries(request_copy);
  auto retry = retry_policy(*current);
  auto backoff = backoff_policy(*current);
  return google::cloud::internal::AsyncRetryLoop(
      std::move(retry), std::move(backoff), idempotent, background_->cq(),
      [stub = stub_](
          CompletionQueue& cq, std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::logging::v2::WriteLogEntriesRequest const& request) {
        return stub->AsyncWriteLogEntries(cq, std::move(context),
                                          std::move(options), request);
      },
      std::move(current), std::move(request_copy), __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace logging_v2_internal
}  // namespace cloud
}  // namespace google
