// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/kms/v1/service.proto

#include "google/cloud/kms/v1/key_management_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace kms_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

KeyManagementServiceConnectionIdempotencyPolicy::
    ~KeyManagementServiceConnectionIdempotencyPolicy() = default;

std::unique_ptr<KeyManagementServiceConnectionIdempotencyPolicy>
KeyManagementServiceConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<KeyManagementServiceConnectionIdempotencyPolicy>(
      *this);
}

Idempotency KeyManagementServiceConnectionIdempotencyPolicy::ListKeyRings(
    google::cloud::kms::v1::ListKeyRingsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency KeyManagementServiceConnectionIdempotencyPolicy::ListCryptoKeys(
    google::cloud::kms::v1::ListCryptoKeysRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency
KeyManagementServiceConnectionIdempotencyPolicy::ListCryptoKeyVersions(
    google::cloud::kms::v1::ListCryptoKeyVersionsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency KeyManagementServiceConnectionIdempotencyPolicy::ListImportJobs(
    google::cloud::kms::v1::ListImportJobsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency KeyManagementServiceConnectionIdempotencyPolicy::GetKeyRing(
    google::cloud::kms::v1::GetKeyRingRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency KeyManagementServiceConnectionIdempotencyPolicy::GetCryptoKey(
    google::cloud::kms::v1::GetCryptoKeyRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency
KeyManagementServiceConnectionIdempotencyPolicy::GetCryptoKeyVersion(
    google::cloud::kms::v1::GetCryptoKeyVersionRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency KeyManagementServiceConnectionIdempotencyPolicy::GetPublicKey(
    google::cloud::kms::v1::GetPublicKeyRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency KeyManagementServiceConnectionIdempotencyPolicy::GetImportJob(
    google::cloud::kms::v1::GetImportJobRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency KeyManagementServiceConnectionIdempotencyPolicy::CreateKeyRing(
    google::cloud::kms::v1::CreateKeyRingRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency KeyManagementServiceConnectionIdempotencyPolicy::CreateCryptoKey(
    google::cloud::kms::v1::CreateCryptoKeyRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
KeyManagementServiceConnectionIdempotencyPolicy::CreateCryptoKeyVersion(
    google::cloud::kms::v1::CreateCryptoKeyVersionRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
KeyManagementServiceConnectionIdempotencyPolicy::ImportCryptoKeyVersion(
    google::cloud::kms::v1::ImportCryptoKeyVersionRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency KeyManagementServiceConnectionIdempotencyPolicy::CreateImportJob(
    google::cloud::kms::v1::CreateImportJobRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency KeyManagementServiceConnectionIdempotencyPolicy::UpdateCryptoKey(
    google::cloud::kms::v1::UpdateCryptoKeyRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
KeyManagementServiceConnectionIdempotencyPolicy::UpdateCryptoKeyVersion(
    google::cloud::kms::v1::UpdateCryptoKeyVersionRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
KeyManagementServiceConnectionIdempotencyPolicy::UpdateCryptoKeyPrimaryVersion(
    google::cloud::kms::v1::UpdateCryptoKeyPrimaryVersionRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
KeyManagementServiceConnectionIdempotencyPolicy::DestroyCryptoKeyVersion(
    google::cloud::kms::v1::DestroyCryptoKeyVersionRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
KeyManagementServiceConnectionIdempotencyPolicy::RestoreCryptoKeyVersion(
    google::cloud::kms::v1::RestoreCryptoKeyVersionRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency KeyManagementServiceConnectionIdempotencyPolicy::Encrypt(
    google::cloud::kms::v1::EncryptRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency KeyManagementServiceConnectionIdempotencyPolicy::Decrypt(
    google::cloud::kms::v1::DecryptRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency KeyManagementServiceConnectionIdempotencyPolicy::RawEncrypt(
    google::cloud::kms::v1::RawEncryptRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency KeyManagementServiceConnectionIdempotencyPolicy::RawDecrypt(
    google::cloud::kms::v1::RawDecryptRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency KeyManagementServiceConnectionIdempotencyPolicy::AsymmetricSign(
    google::cloud::kms::v1::AsymmetricSignRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency KeyManagementServiceConnectionIdempotencyPolicy::AsymmetricDecrypt(
    google::cloud::kms::v1::AsymmetricDecryptRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency KeyManagementServiceConnectionIdempotencyPolicy::MacSign(
    google::cloud::kms::v1::MacSignRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency KeyManagementServiceConnectionIdempotencyPolicy::MacVerify(
    google::cloud::kms::v1::MacVerifyRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
KeyManagementServiceConnectionIdempotencyPolicy::GenerateRandomBytes(
    google::cloud::kms::v1::GenerateRandomBytesRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency KeyManagementServiceConnectionIdempotencyPolicy::ListLocations(
    google::cloud::location::ListLocationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency KeyManagementServiceConnectionIdempotencyPolicy::GetLocation(
    google::cloud::location::GetLocationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency KeyManagementServiceConnectionIdempotencyPolicy::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  return request.policy().etag().empty() ? Idempotency::kNonIdempotent
                                         : Idempotency::kIdempotent;
}

Idempotency KeyManagementServiceConnectionIdempotencyPolicy::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency KeyManagementServiceConnectionIdempotencyPolicy::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency KeyManagementServiceConnectionIdempotencyPolicy::GetOperation(
    google::longrunning::GetOperationRequest const&) {
  return Idempotency::kIdempotent;
}

std::unique_ptr<KeyManagementServiceConnectionIdempotencyPolicy>
MakeDefaultKeyManagementServiceConnectionIdempotencyPolicy() {
  return std::make_unique<KeyManagementServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace kms_v1
}  // namespace cloud
}  // namespace google
