// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/kms/v1/ekm_service.proto

#include "google/cloud/kms/v1/internal/ekm_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace kms_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

EkmServiceTracingConnection::EkmServiceTracingConnection(
    std::shared_ptr<kms_v1::EkmServiceConnection> child)
    : child_(std::move(child)) {}

StreamRange<google::cloud::kms::v1::EkmConnection>
EkmServiceTracingConnection::ListEkmConnections(
    google::cloud::kms::v1::ListEkmConnectionsRequest request) {
  auto span =
      internal::MakeSpan("kms_v1::EkmServiceConnection::ListEkmConnections");
  internal::OTelScope scope(span);
  auto sr = child_->ListEkmConnections(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::kms::v1::EkmConnection>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::kms::v1::EkmConnection>
EkmServiceTracingConnection::GetEkmConnection(
    google::cloud::kms::v1::GetEkmConnectionRequest const& request) {
  auto span =
      internal::MakeSpan("kms_v1::EkmServiceConnection::GetEkmConnection");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetEkmConnection(request));
}

StatusOr<google::cloud::kms::v1::EkmConnection>
EkmServiceTracingConnection::CreateEkmConnection(
    google::cloud::kms::v1::CreateEkmConnectionRequest const& request) {
  auto span =
      internal::MakeSpan("kms_v1::EkmServiceConnection::CreateEkmConnection");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateEkmConnection(request));
}

StatusOr<google::cloud::kms::v1::EkmConnection>
EkmServiceTracingConnection::UpdateEkmConnection(
    google::cloud::kms::v1::UpdateEkmConnectionRequest const& request) {
  auto span =
      internal::MakeSpan("kms_v1::EkmServiceConnection::UpdateEkmConnection");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateEkmConnection(request));
}

StatusOr<google::cloud::kms::v1::EkmConfig>
EkmServiceTracingConnection::GetEkmConfig(
    google::cloud::kms::v1::GetEkmConfigRequest const& request) {
  auto span = internal::MakeSpan("kms_v1::EkmServiceConnection::GetEkmConfig");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetEkmConfig(request));
}

StatusOr<google::cloud::kms::v1::EkmConfig>
EkmServiceTracingConnection::UpdateEkmConfig(
    google::cloud::kms::v1::UpdateEkmConfigRequest const& request) {
  auto span =
      internal::MakeSpan("kms_v1::EkmServiceConnection::UpdateEkmConfig");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateEkmConfig(request));
}

StatusOr<google::cloud::kms::v1::VerifyConnectivityResponse>
EkmServiceTracingConnection::VerifyConnectivity(
    google::cloud::kms::v1::VerifyConnectivityRequest const& request) {
  auto span =
      internal::MakeSpan("kms_v1::EkmServiceConnection::VerifyConnectivity");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->VerifyConnectivity(request));
}

StreamRange<google::cloud::location::Location>
EkmServiceTracingConnection::ListLocations(
    google::cloud::location::ListLocationsRequest request) {
  auto span = internal::MakeSpan("kms_v1::EkmServiceConnection::ListLocations");
  internal::OTelScope scope(span);
  auto sr = child_->ListLocations(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::location::Location>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::location::Location>
EkmServiceTracingConnection::GetLocation(
    google::cloud::location::GetLocationRequest const& request) {
  auto span = internal::MakeSpan("kms_v1::EkmServiceConnection::GetLocation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetLocation(request));
}

StatusOr<google::iam::v1::Policy> EkmServiceTracingConnection::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  auto span = internal::MakeSpan("kms_v1::EkmServiceConnection::SetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->SetIamPolicy(request));
}

StatusOr<google::iam::v1::Policy> EkmServiceTracingConnection::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const& request) {
  auto span = internal::MakeSpan("kms_v1::EkmServiceConnection::GetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetIamPolicy(request));
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
EkmServiceTracingConnection::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const& request) {
  auto span =
      internal::MakeSpan("kms_v1::EkmServiceConnection::TestIamPermissions");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->TestIamPermissions(request));
}

StatusOr<google::longrunning::Operation>
EkmServiceTracingConnection::GetOperation(
    google::longrunning::GetOperationRequest const& request) {
  auto span = internal::MakeSpan("kms_v1::EkmServiceConnection::GetOperation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetOperation(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<kms_v1::EkmServiceConnection> MakeEkmServiceTracingConnection(
    std::shared_ptr<kms_v1::EkmServiceConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<EkmServiceTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace kms_v1_internal
}  // namespace cloud
}  // namespace google
