// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/kms/v1/ekm_service.proto

#include "google/cloud/kms/v1/internal/ekm_connection_impl.h"
#include "google/cloud/kms/v1/internal/ekm_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace kms_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<kms_v1::EkmServiceRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<kms_v1::EkmServiceRetryPolicyOption>()->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options.get<kms_v1::EkmServiceBackoffPolicyOption>()->clone();
}

std::unique_ptr<kms_v1::EkmServiceConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options.get<kms_v1::EkmServiceConnectionIdempotencyPolicyOption>()
      ->clone();
}

}  // namespace

EkmServiceConnectionImpl::EkmServiceConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<kms_v1_internal::EkmServiceStub> stub, Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(std::move(options),
                                      EkmServiceConnection::options())) {}

StreamRange<google::cloud::kms::v1::EkmConnection>
EkmServiceConnectionImpl::ListEkmConnections(
    google::cloud::kms::v1::ListEkmConnectionsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListEkmConnections(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::kms::v1::EkmConnection>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<kms_v1::EkmServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::kms::v1::ListEkmConnectionsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::kms::v1::ListEkmConnectionsRequest const&
                       request) {
              return stub->ListEkmConnections(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::kms::v1::ListEkmConnectionsResponse r) {
        std::vector<google::cloud::kms::v1::EkmConnection> result(
            r.ekm_connections().size());
        auto& messages = *r.mutable_ekm_connections();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::kms::v1::EkmConnection>
EkmServiceConnectionImpl::GetEkmConnection(
    google::cloud::kms::v1::GetEkmConnectionRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetEkmConnection(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::kms::v1::GetEkmConnectionRequest const& request) {
        return stub_->GetEkmConnection(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::kms::v1::EkmConnection>
EkmServiceConnectionImpl::CreateEkmConnection(
    google::cloud::kms::v1::CreateEkmConnectionRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateEkmConnection(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::kms::v1::CreateEkmConnectionRequest const& request) {
        return stub_->CreateEkmConnection(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::kms::v1::EkmConnection>
EkmServiceConnectionImpl::UpdateEkmConnection(
    google::cloud::kms::v1::UpdateEkmConnectionRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateEkmConnection(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::kms::v1::UpdateEkmConnectionRequest const& request) {
        return stub_->UpdateEkmConnection(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::kms::v1::EkmConfig>
EkmServiceConnectionImpl::GetEkmConfig(
    google::cloud::kms::v1::GetEkmConfigRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetEkmConfig(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::kms::v1::GetEkmConfigRequest const& request) {
        return stub_->GetEkmConfig(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::kms::v1::EkmConfig>
EkmServiceConnectionImpl::UpdateEkmConfig(
    google::cloud::kms::v1::UpdateEkmConfigRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateEkmConfig(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::kms::v1::UpdateEkmConfigRequest const& request) {
        return stub_->UpdateEkmConfig(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::kms::v1::VerifyConnectivityResponse>
EkmServiceConnectionImpl::VerifyConnectivity(
    google::cloud::kms::v1::VerifyConnectivityRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->VerifyConnectivity(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::kms::v1::VerifyConnectivityRequest const& request) {
        return stub_->VerifyConnectivity(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::location::Location>
EkmServiceConnectionImpl::ListLocations(
    google::cloud::location::ListLocationsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListLocations(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::location::Location>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<kms_v1::EkmServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::location::ListLocationsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context, Options const& options,
                google::cloud::location::ListLocationsRequest const& request) {
              return stub->ListLocations(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::location::ListLocationsResponse r) {
        std::vector<google::cloud::location::Location> result(
            r.locations().size());
        auto& messages = *r.mutable_locations();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::location::Location>
EkmServiceConnectionImpl::GetLocation(
    google::cloud::location::GetLocationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetLocation(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::location::GetLocationRequest const& request) {
        return stub_->GetLocation(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::iam::v1::Policy> EkmServiceConnectionImpl::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->SetIamPolicy(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::iam::v1::SetIamPolicyRequest const& request) {
        return stub_->SetIamPolicy(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::iam::v1::Policy> EkmServiceConnectionImpl::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetIamPolicy(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::iam::v1::GetIamPolicyRequest const& request) {
        return stub_->GetIamPolicy(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
EkmServiceConnectionImpl::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->TestIamPermissions(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::iam::v1::TestIamPermissionsRequest const& request) {
        return stub_->TestIamPermissions(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::longrunning::Operation> EkmServiceConnectionImpl::GetOperation(
    google::longrunning::GetOperationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetOperation(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::longrunning::GetOperationRequest const& request) {
        return stub_->GetOperation(context, options, request);
      },
      *current, request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace kms_v1_internal
}  // namespace cloud
}  // namespace google
