// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/kms/v1/ekm_service.proto

#include "google/cloud/kms/v1/internal/ekm_auth_decorator.h"
#include <google/cloud/kms/v1/ekm_service.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace kms_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

EkmServiceAuth::EkmServiceAuth(
    std::shared_ptr<google::cloud::internal::GrpcAuthenticationStrategy> auth,
    std::shared_ptr<EkmServiceStub> child)
    : auth_(std::move(auth)), child_(std::move(child)) {}

StatusOr<google::cloud::kms::v1::ListEkmConnectionsResponse>
EkmServiceAuth::ListEkmConnections(
    grpc::ClientContext& context, Options const& options,
    google::cloud::kms::v1::ListEkmConnectionsRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListEkmConnections(context, options, request);
}

StatusOr<google::cloud::kms::v1::EkmConnection>
EkmServiceAuth::GetEkmConnection(
    grpc::ClientContext& context, Options const& options,
    google::cloud::kms::v1::GetEkmConnectionRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetEkmConnection(context, options, request);
}

StatusOr<google::cloud::kms::v1::EkmConnection>
EkmServiceAuth::CreateEkmConnection(
    grpc::ClientContext& context, Options const& options,
    google::cloud::kms::v1::CreateEkmConnectionRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->CreateEkmConnection(context, options, request);
}

StatusOr<google::cloud::kms::v1::EkmConnection>
EkmServiceAuth::UpdateEkmConnection(
    grpc::ClientContext& context, Options const& options,
    google::cloud::kms::v1::UpdateEkmConnectionRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->UpdateEkmConnection(context, options, request);
}

StatusOr<google::cloud::kms::v1::EkmConfig> EkmServiceAuth::GetEkmConfig(
    grpc::ClientContext& context, Options const& options,
    google::cloud::kms::v1::GetEkmConfigRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetEkmConfig(context, options, request);
}

StatusOr<google::cloud::kms::v1::EkmConfig> EkmServiceAuth::UpdateEkmConfig(
    grpc::ClientContext& context, Options const& options,
    google::cloud::kms::v1::UpdateEkmConfigRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->UpdateEkmConfig(context, options, request);
}

StatusOr<google::cloud::kms::v1::VerifyConnectivityResponse>
EkmServiceAuth::VerifyConnectivity(
    grpc::ClientContext& context, Options const& options,
    google::cloud::kms::v1::VerifyConnectivityRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->VerifyConnectivity(context, options, request);
}

StatusOr<google::cloud::location::ListLocationsResponse>
EkmServiceAuth::ListLocations(
    grpc::ClientContext& context, Options const& options,
    google::cloud::location::ListLocationsRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->ListLocations(context, options, request);
}

StatusOr<google::cloud::location::Location> EkmServiceAuth::GetLocation(
    grpc::ClientContext& context, Options const& options,
    google::cloud::location::GetLocationRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetLocation(context, options, request);
}

StatusOr<google::iam::v1::Policy> EkmServiceAuth::SetIamPolicy(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::SetIamPolicyRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->SetIamPolicy(context, options, request);
}

StatusOr<google::iam::v1::Policy> EkmServiceAuth::GetIamPolicy(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::GetIamPolicyRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetIamPolicy(context, options, request);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
EkmServiceAuth::TestIamPermissions(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::TestIamPermissionsRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->TestIamPermissions(context, options, request);
}

StatusOr<google::longrunning::Operation> EkmServiceAuth::GetOperation(
    grpc::ClientContext& context, Options const& options,
    google::longrunning::GetOperationRequest const& request) {
  auto status = auth_->ConfigureContext(context);
  if (!status.ok()) return status;
  return child_->GetOperation(context, options, request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace kms_v1_internal
}  // namespace cloud
}  // namespace google
